package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceInstanceSpecBuilder extends ServiceInstanceSpecFluent<ServiceInstanceSpecBuilder> implements VisitableBuilder<ServiceInstanceSpec,ServiceInstanceSpecBuilder>{
  public ServiceInstanceSpecBuilder() {
    this(false);
  }
  public ServiceInstanceSpecBuilder(Boolean validationEnabled) {
    this(new ServiceInstanceSpec(), validationEnabled);
  }
  public ServiceInstanceSpecBuilder(ServiceInstanceSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceInstanceSpecBuilder(ServiceInstanceSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServiceInstanceSpec(), validationEnabled);
  }
  public ServiceInstanceSpecBuilder(ServiceInstanceSpecFluent<?> fluent,ServiceInstanceSpec instance) {
    this(fluent, instance, false);
  }
  public ServiceInstanceSpecBuilder(ServiceInstanceSpecFluent<?> fluent,ServiceInstanceSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ServiceInstanceSpec());

    if (instance != null) {
      fluent.withClusterServiceClassExternalID(instance.getClusterServiceClassExternalID());
      fluent.withClusterServiceClassExternalName(instance.getClusterServiceClassExternalName());
      fluent.withClusterServiceClassName(instance.getClusterServiceClassName());
      fluent.withClusterServiceClassRef(instance.getClusterServiceClassRef());
      fluent.withClusterServicePlanExternalID(instance.getClusterServicePlanExternalID());
      fluent.withClusterServicePlanExternalName(instance.getClusterServicePlanExternalName());
      fluent.withClusterServicePlanName(instance.getClusterServicePlanName());
      fluent.withClusterServicePlanRef(instance.getClusterServicePlanRef());
      fluent.withExternalID(instance.getExternalID());
      fluent.withParameters(instance.getParameters());
      fluent.withParametersFrom(instance.getParametersFrom());
      fluent.withServiceClassExternalID(instance.getServiceClassExternalID());
      fluent.withServiceClassExternalName(instance.getServiceClassExternalName());
      fluent.withServiceClassName(instance.getServiceClassName());
      fluent.withServiceClassRef(instance.getServiceClassRef());
      fluent.withServicePlanExternalID(instance.getServicePlanExternalID());
      fluent.withServicePlanExternalName(instance.getServicePlanExternalName());
      fluent.withServicePlanName(instance.getServicePlanName());
      fluent.withServicePlanRef(instance.getServicePlanRef());
      fluent.withUpdateRequests(instance.getUpdateRequests());
      fluent.withUserInfo(instance.getUserInfo());
      fluent.withClusterServiceClassExternalID(instance.getClusterServiceClassExternalID());
      fluent.withClusterServiceClassExternalName(instance.getClusterServiceClassExternalName());
      fluent.withClusterServiceClassName(instance.getClusterServiceClassName());
      fluent.withClusterServiceClassRef(instance.getClusterServiceClassRef());
      fluent.withClusterServicePlanExternalID(instance.getClusterServicePlanExternalID());
      fluent.withClusterServicePlanExternalName(instance.getClusterServicePlanExternalName());
      fluent.withClusterServicePlanName(instance.getClusterServicePlanName());
      fluent.withClusterServicePlanRef(instance.getClusterServicePlanRef());
      fluent.withExternalID(instance.getExternalID());
      fluent.withParameters(instance.getParameters());
      fluent.withParametersFrom(instance.getParametersFrom());
      fluent.withServiceClassExternalID(instance.getServiceClassExternalID());
      fluent.withServiceClassExternalName(instance.getServiceClassExternalName());
      fluent.withServiceClassName(instance.getServiceClassName());
      fluent.withServiceClassRef(instance.getServiceClassRef());
      fluent.withServicePlanExternalID(instance.getServicePlanExternalID());
      fluent.withServicePlanExternalName(instance.getServicePlanExternalName());
      fluent.withServicePlanName(instance.getServicePlanName());
      fluent.withServicePlanRef(instance.getServicePlanRef());
      fluent.withUpdateRequests(instance.getUpdateRequests());
      fluent.withUserInfo(instance.getUserInfo());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ServiceInstanceSpecBuilder(ServiceInstanceSpec instance) {
    this(instance,false);
  }
  public ServiceInstanceSpecBuilder(ServiceInstanceSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ServiceInstanceSpec());

    if (instance != null) {
      this.withClusterServiceClassExternalID(instance.getClusterServiceClassExternalID());
      this.withClusterServiceClassExternalName(instance.getClusterServiceClassExternalName());
      this.withClusterServiceClassName(instance.getClusterServiceClassName());
      this.withClusterServiceClassRef(instance.getClusterServiceClassRef());
      this.withClusterServicePlanExternalID(instance.getClusterServicePlanExternalID());
      this.withClusterServicePlanExternalName(instance.getClusterServicePlanExternalName());
      this.withClusterServicePlanName(instance.getClusterServicePlanName());
      this.withClusterServicePlanRef(instance.getClusterServicePlanRef());
      this.withExternalID(instance.getExternalID());
      this.withParameters(instance.getParameters());
      this.withParametersFrom(instance.getParametersFrom());
      this.withServiceClassExternalID(instance.getServiceClassExternalID());
      this.withServiceClassExternalName(instance.getServiceClassExternalName());
      this.withServiceClassName(instance.getServiceClassName());
      this.withServiceClassRef(instance.getServiceClassRef());
      this.withServicePlanExternalID(instance.getServicePlanExternalID());
      this.withServicePlanExternalName(instance.getServicePlanExternalName());
      this.withServicePlanName(instance.getServicePlanName());
      this.withServicePlanRef(instance.getServicePlanRef());
      this.withUpdateRequests(instance.getUpdateRequests());
      this.withUserInfo(instance.getUserInfo());
      this.withClusterServiceClassExternalID(instance.getClusterServiceClassExternalID());
      this.withClusterServiceClassExternalName(instance.getClusterServiceClassExternalName());
      this.withClusterServiceClassName(instance.getClusterServiceClassName());
      this.withClusterServiceClassRef(instance.getClusterServiceClassRef());
      this.withClusterServicePlanExternalID(instance.getClusterServicePlanExternalID());
      this.withClusterServicePlanExternalName(instance.getClusterServicePlanExternalName());
      this.withClusterServicePlanName(instance.getClusterServicePlanName());
      this.withClusterServicePlanRef(instance.getClusterServicePlanRef());
      this.withExternalID(instance.getExternalID());
      this.withParameters(instance.getParameters());
      this.withParametersFrom(instance.getParametersFrom());
      this.withServiceClassExternalID(instance.getServiceClassExternalID());
      this.withServiceClassExternalName(instance.getServiceClassExternalName());
      this.withServiceClassName(instance.getServiceClassName());
      this.withServiceClassRef(instance.getServiceClassRef());
      this.withServicePlanExternalID(instance.getServicePlanExternalID());
      this.withServicePlanExternalName(instance.getServicePlanExternalName());
      this.withServicePlanName(instance.getServicePlanName());
      this.withServicePlanRef(instance.getServicePlanRef());
      this.withUpdateRequests(instance.getUpdateRequests());
      this.withUserInfo(instance.getUserInfo());
    }
    this.validationEnabled = validationEnabled; 
  }
  ServiceInstanceSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ServiceInstanceSpec build() {
    ServiceInstanceSpec buildable = new ServiceInstanceSpec(fluent.getClusterServiceClassExternalID(),fluent.getClusterServiceClassExternalName(),fluent.getClusterServiceClassName(),fluent.buildClusterServiceClassRef(),fluent.getClusterServicePlanExternalID(),fluent.getClusterServicePlanExternalName(),fluent.getClusterServicePlanName(),fluent.buildClusterServicePlanRef(),fluent.getExternalID(),fluent.getParameters(),fluent.buildParametersFrom(),fluent.getServiceClassExternalID(),fluent.getServiceClassExternalName(),fluent.getServiceClassName(),fluent.buildServiceClassRef(),fluent.getServicePlanExternalID(),fluent.getServicePlanExternalName(),fluent.getServicePlanName(),fluent.buildServicePlanRef(),fluent.getUpdateRequests(),fluent.buildUserInfo());
    return buildable;
  }
  
}