package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceInstanceListBuilder extends ServiceInstanceListFluent<ServiceInstanceListBuilder> implements VisitableBuilder<ServiceInstanceList,ServiceInstanceListBuilder>{
  public ServiceInstanceListBuilder() {
    this(false);
  }
  public ServiceInstanceListBuilder(Boolean validationEnabled) {
    this(new ServiceInstanceList(), validationEnabled);
  }
  public ServiceInstanceListBuilder(ServiceInstanceListFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceInstanceListBuilder(ServiceInstanceListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServiceInstanceList(), validationEnabled);
  }
  public ServiceInstanceListBuilder(ServiceInstanceListFluent<?> fluent,ServiceInstanceList instance) {
    this(fluent, instance, false);
  }
  public ServiceInstanceListBuilder(ServiceInstanceListFluent<?> fluent,ServiceInstanceList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ServiceInstanceList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ServiceInstanceListBuilder(ServiceInstanceList instance) {
    this(instance,false);
  }
  public ServiceInstanceListBuilder(ServiceInstanceList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ServiceInstanceList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  ServiceInstanceListFluent<?> fluent;
  Boolean validationEnabled;
  public ServiceInstanceList build() {
    ServiceInstanceList buildable = new ServiceInstanceList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}