package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceBrokerConditionBuilder extends ServiceBrokerConditionFluent<ServiceBrokerConditionBuilder> implements VisitableBuilder<ServiceBrokerCondition,ServiceBrokerConditionBuilder>{
  public ServiceBrokerConditionBuilder() {
    this(false);
  }
  public ServiceBrokerConditionBuilder(Boolean validationEnabled) {
    this(new ServiceBrokerCondition(), validationEnabled);
  }
  public ServiceBrokerConditionBuilder(ServiceBrokerConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceBrokerConditionBuilder(ServiceBrokerConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServiceBrokerCondition(), validationEnabled);
  }
  public ServiceBrokerConditionBuilder(ServiceBrokerConditionFluent<?> fluent,ServiceBrokerCondition instance) {
    this(fluent, instance, false);
  }
  public ServiceBrokerConditionBuilder(ServiceBrokerConditionFluent<?> fluent,ServiceBrokerCondition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ServiceBrokerCondition());

    if (instance != null) {
      fluent.withLastTransitionTime(instance.getLastTransitionTime());
      fluent.withMessage(instance.getMessage());
      fluent.withReason(instance.getReason());
      fluent.withStatus(instance.getStatus());
      fluent.withType(instance.getType());
      fluent.withLastTransitionTime(instance.getLastTransitionTime());
      fluent.withMessage(instance.getMessage());
      fluent.withReason(instance.getReason());
      fluent.withStatus(instance.getStatus());
      fluent.withType(instance.getType());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ServiceBrokerConditionBuilder(ServiceBrokerCondition instance) {
    this(instance,false);
  }
  public ServiceBrokerConditionBuilder(ServiceBrokerCondition instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ServiceBrokerCondition());

    if (instance != null) {
      this.withLastTransitionTime(instance.getLastTransitionTime());
      this.withMessage(instance.getMessage());
      this.withReason(instance.getReason());
      this.withStatus(instance.getStatus());
      this.withType(instance.getType());
      this.withLastTransitionTime(instance.getLastTransitionTime());
      this.withMessage(instance.getMessage());
      this.withReason(instance.getReason());
      this.withStatus(instance.getStatus());
      this.withType(instance.getType());
    }
    this.validationEnabled = validationEnabled; 
  }
  ServiceBrokerConditionFluent<?> fluent;
  Boolean validationEnabled;
  public ServiceBrokerCondition build() {
    ServiceBrokerCondition buildable = new ServiceBrokerCondition(fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    return buildable;
  }
  
}