package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SecretKeyReferenceBuilder extends SecretKeyReferenceFluent<SecretKeyReferenceBuilder> implements VisitableBuilder<SecretKeyReference,SecretKeyReferenceBuilder>{
  public SecretKeyReferenceBuilder() {
    this(false);
  }
  public SecretKeyReferenceBuilder(Boolean validationEnabled) {
    this(new SecretKeyReference(), validationEnabled);
  }
  public SecretKeyReferenceBuilder(SecretKeyReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public SecretKeyReferenceBuilder(SecretKeyReferenceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SecretKeyReference(), validationEnabled);
  }
  public SecretKeyReferenceBuilder(SecretKeyReferenceFluent<?> fluent,SecretKeyReference instance) {
    this(fluent, instance, false);
  }
  public SecretKeyReferenceBuilder(SecretKeyReferenceFluent<?> fluent,SecretKeyReference instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new SecretKeyReference());

    if (instance != null) {
      fluent.withKey(instance.getKey());
      fluent.withName(instance.getName());
      fluent.withKey(instance.getKey());
      fluent.withName(instance.getName());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SecretKeyReferenceBuilder(SecretKeyReference instance) {
    this(instance,false);
  }
  public SecretKeyReferenceBuilder(SecretKeyReference instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new SecretKeyReference());

    if (instance != null) {
      this.withKey(instance.getKey());
      this.withName(instance.getName());
      this.withKey(instance.getKey());
      this.withName(instance.getName());
    }
    this.validationEnabled = validationEnabled; 
  }
  SecretKeyReferenceFluent<?> fluent;
  Boolean validationEnabled;
  public SecretKeyReference build() {
    SecretKeyReference buildable = new SecretKeyReference(fluent.getKey(),fluent.getName());
    return buildable;
  }
  
}