package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RemoveKeyTransformBuilder extends RemoveKeyTransformFluent<RemoveKeyTransformBuilder> implements VisitableBuilder<RemoveKeyTransform,RemoveKeyTransformBuilder>{
  public RemoveKeyTransformBuilder() {
    this(false);
  }
  public RemoveKeyTransformBuilder(Boolean validationEnabled) {
    this(new RemoveKeyTransform(), validationEnabled);
  }
  public RemoveKeyTransformBuilder(RemoveKeyTransformFluent<?> fluent) {
    this(fluent, false);
  }
  public RemoveKeyTransformBuilder(RemoveKeyTransformFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RemoveKeyTransform(), validationEnabled);
  }
  public RemoveKeyTransformBuilder(RemoveKeyTransformFluent<?> fluent,RemoveKeyTransform instance) {
    this(fluent, instance, false);
  }
  public RemoveKeyTransformBuilder(RemoveKeyTransformFluent<?> fluent,RemoveKeyTransform instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new RemoveKeyTransform());

    if (instance != null) {
      fluent.withKey(instance.getKey());
      fluent.withKey(instance.getKey());
    }
    this.validationEnabled = validationEnabled; 
  }
  public RemoveKeyTransformBuilder(RemoveKeyTransform instance) {
    this(instance,false);
  }
  public RemoveKeyTransformBuilder(RemoveKeyTransform instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new RemoveKeyTransform());

    if (instance != null) {
      this.withKey(instance.getKey());
      this.withKey(instance.getKey());
    }
    this.validationEnabled = validationEnabled; 
  }
  RemoveKeyTransformFluent<?> fluent;
  Boolean validationEnabled;
  public RemoveKeyTransform build() {
    RemoveKeyTransform buildable = new RemoveKeyTransform(fluent.getKey());
    return buildable;
  }
  
}