package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterServiceBrokerSpecBuilder extends ClusterServiceBrokerSpecFluent<ClusterServiceBrokerSpecBuilder> implements VisitableBuilder<ClusterServiceBrokerSpec,ClusterServiceBrokerSpecBuilder>{
  public ClusterServiceBrokerSpecBuilder() {
    this(false);
  }
  public ClusterServiceBrokerSpecBuilder(Boolean validationEnabled) {
    this(new ClusterServiceBrokerSpec(), validationEnabled);
  }
  public ClusterServiceBrokerSpecBuilder(ClusterServiceBrokerSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterServiceBrokerSpecBuilder(ClusterServiceBrokerSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterServiceBrokerSpec(), validationEnabled);
  }
  public ClusterServiceBrokerSpecBuilder(ClusterServiceBrokerSpecFluent<?> fluent,ClusterServiceBrokerSpec instance) {
    this(fluent, instance, false);
  }
  public ClusterServiceBrokerSpecBuilder(ClusterServiceBrokerSpecFluent<?> fluent,ClusterServiceBrokerSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ClusterServiceBrokerSpec());

    if (instance != null) {
      fluent.withAuthInfo(instance.getAuthInfo());
      fluent.withCaBundle(instance.getCaBundle());
      fluent.withCatalogRestrictions(instance.getCatalogRestrictions());
      fluent.withInsecureSkipTLSVerify(instance.getInsecureSkipTLSVerify());
      fluent.withRelistBehavior(instance.getRelistBehavior());
      fluent.withRelistDuration(instance.getRelistDuration());
      fluent.withRelistRequests(instance.getRelistRequests());
      fluent.withUrl(instance.getUrl());
      fluent.withAuthInfo(instance.getAuthInfo());
      fluent.withCaBundle(instance.getCaBundle());
      fluent.withCatalogRestrictions(instance.getCatalogRestrictions());
      fluent.withInsecureSkipTLSVerify(instance.getInsecureSkipTLSVerify());
      fluent.withRelistBehavior(instance.getRelistBehavior());
      fluent.withRelistDuration(instance.getRelistDuration());
      fluent.withRelistRequests(instance.getRelistRequests());
      fluent.withUrl(instance.getUrl());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterServiceBrokerSpecBuilder(ClusterServiceBrokerSpec instance) {
    this(instance,false);
  }
  public ClusterServiceBrokerSpecBuilder(ClusterServiceBrokerSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ClusterServiceBrokerSpec());

    if (instance != null) {
      this.withAuthInfo(instance.getAuthInfo());
      this.withCaBundle(instance.getCaBundle());
      this.withCatalogRestrictions(instance.getCatalogRestrictions());
      this.withInsecureSkipTLSVerify(instance.getInsecureSkipTLSVerify());
      this.withRelistBehavior(instance.getRelistBehavior());
      this.withRelistDuration(instance.getRelistDuration());
      this.withRelistRequests(instance.getRelistRequests());
      this.withUrl(instance.getUrl());
      this.withAuthInfo(instance.getAuthInfo());
      this.withCaBundle(instance.getCaBundle());
      this.withCatalogRestrictions(instance.getCatalogRestrictions());
      this.withInsecureSkipTLSVerify(instance.getInsecureSkipTLSVerify());
      this.withRelistBehavior(instance.getRelistBehavior());
      this.withRelistDuration(instance.getRelistDuration());
      this.withRelistRequests(instance.getRelistRequests());
      this.withUrl(instance.getUrl());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterServiceBrokerSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterServiceBrokerSpec build() {
    ClusterServiceBrokerSpec buildable = new ClusterServiceBrokerSpec(fluent.buildAuthInfo(),fluent.getCaBundle(),fluent.buildCatalogRestrictions(),fluent.getInsecureSkipTLSVerify(),fluent.getRelistBehavior(),fluent.getRelistDuration(),fluent.getRelistRequests(),fluent.getUrl());
    return buildable;
  }
  
}