package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterServiceBrokerAuthInfoBuilder extends ClusterServiceBrokerAuthInfoFluent<ClusterServiceBrokerAuthInfoBuilder> implements VisitableBuilder<ClusterServiceBrokerAuthInfo,ClusterServiceBrokerAuthInfoBuilder>{
  public ClusterServiceBrokerAuthInfoBuilder() {
    this(false);
  }
  public ClusterServiceBrokerAuthInfoBuilder(Boolean validationEnabled) {
    this(new ClusterServiceBrokerAuthInfo(), validationEnabled);
  }
  public ClusterServiceBrokerAuthInfoBuilder(ClusterServiceBrokerAuthInfoFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterServiceBrokerAuthInfoBuilder(ClusterServiceBrokerAuthInfoFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterServiceBrokerAuthInfo(), validationEnabled);
  }
  public ClusterServiceBrokerAuthInfoBuilder(ClusterServiceBrokerAuthInfoFluent<?> fluent,ClusterServiceBrokerAuthInfo instance) {
    this(fluent, instance, false);
  }
  public ClusterServiceBrokerAuthInfoBuilder(ClusterServiceBrokerAuthInfoFluent<?> fluent,ClusterServiceBrokerAuthInfo instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ClusterServiceBrokerAuthInfo());

    if (instance != null) {
      fluent.withBasic(instance.getBasic());
      fluent.withBearer(instance.getBearer());
      fluent.withBasic(instance.getBasic());
      fluent.withBearer(instance.getBearer());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterServiceBrokerAuthInfoBuilder(ClusterServiceBrokerAuthInfo instance) {
    this(instance,false);
  }
  public ClusterServiceBrokerAuthInfoBuilder(ClusterServiceBrokerAuthInfo instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ClusterServiceBrokerAuthInfo());

    if (instance != null) {
      this.withBasic(instance.getBasic());
      this.withBearer(instance.getBearer());
      this.withBasic(instance.getBasic());
      this.withBearer(instance.getBearer());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterServiceBrokerAuthInfoFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterServiceBrokerAuthInfo build() {
    ClusterServiceBrokerAuthInfo buildable = new ClusterServiceBrokerAuthInfo(fluent.buildBasic(),fluent.buildBearer());
    return buildable;
  }
  
}