/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.servicecatalog.api.model.CatalogRestrictions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class CatalogRestrictionsFluent<A extends CatalogRestrictionsFluent<A>>
extends BaseFluent<A> {
    private List<String> serviceClass = new ArrayList<String>();
    private List<String> servicePlan = new ArrayList<String>();

    public CatalogRestrictionsFluent() {
    }

    public CatalogRestrictionsFluent(CatalogRestrictions instance) {
        CatalogRestrictions catalogRestrictions = instance = instance != null ? instance : new CatalogRestrictions();
        if (instance != null) {
            this.withServiceClass(instance.getServiceClass());
            this.withServicePlan(instance.getServicePlan());
            this.withServiceClass(instance.getServiceClass());
            this.withServicePlan(instance.getServicePlan());
        }
    }

    public A addToServiceClass(int index, String item) {
        if (this.serviceClass == null) {
            this.serviceClass = new ArrayList<String>();
        }
        this.serviceClass.add(index, item);
        return (A)((Object)this);
    }

    public A setToServiceClass(int index, String item) {
        if (this.serviceClass == null) {
            this.serviceClass = new ArrayList<String>();
        }
        this.serviceClass.set(index, item);
        return (A)((Object)this);
    }

    public A addToServiceClass(String ... items) {
        if (this.serviceClass == null) {
            this.serviceClass = new ArrayList<String>();
        }
        for (String item : items) {
            this.serviceClass.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToServiceClass(Collection<String> items) {
        if (this.serviceClass == null) {
            this.serviceClass = new ArrayList<String>();
        }
        for (String item : items) {
            this.serviceClass.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromServiceClass(String ... items) {
        if (this.serviceClass == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.serviceClass.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromServiceClass(Collection<String> items) {
        if (this.serviceClass == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.serviceClass.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getServiceClass() {
        return this.serviceClass;
    }

    public String getServiceClass(int index) {
        return this.serviceClass.get(index);
    }

    public String getFirstServiceClass() {
        return this.serviceClass.get(0);
    }

    public String getLastServiceClass() {
        return this.serviceClass.get(this.serviceClass.size() - 1);
    }

    public String getMatchingServiceClass(Predicate<String> predicate) {
        for (String item : this.serviceClass) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingServiceClass(Predicate<String> predicate) {
        for (String item : this.serviceClass) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withServiceClass(List<String> serviceClass) {
        if (serviceClass != null) {
            this.serviceClass = new ArrayList<String>();
            for (String item : serviceClass) {
                this.addToServiceClass(item);
            }
        } else {
            this.serviceClass = null;
        }
        return (A)((Object)this);
    }

    public A withServiceClass(String ... serviceClass) {
        if (this.serviceClass != null) {
            this.serviceClass.clear();
            this._visitables.remove((Object)"serviceClass");
        }
        if (serviceClass != null) {
            for (String item : serviceClass) {
                this.addToServiceClass(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasServiceClass() {
        return this.serviceClass != null && !this.serviceClass.isEmpty();
    }

    public A addToServicePlan(int index, String item) {
        if (this.servicePlan == null) {
            this.servicePlan = new ArrayList<String>();
        }
        this.servicePlan.add(index, item);
        return (A)((Object)this);
    }

    public A setToServicePlan(int index, String item) {
        if (this.servicePlan == null) {
            this.servicePlan = new ArrayList<String>();
        }
        this.servicePlan.set(index, item);
        return (A)((Object)this);
    }

    public A addToServicePlan(String ... items) {
        if (this.servicePlan == null) {
            this.servicePlan = new ArrayList<String>();
        }
        for (String item : items) {
            this.servicePlan.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToServicePlan(Collection<String> items) {
        if (this.servicePlan == null) {
            this.servicePlan = new ArrayList<String>();
        }
        for (String item : items) {
            this.servicePlan.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromServicePlan(String ... items) {
        if (this.servicePlan == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.servicePlan.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromServicePlan(Collection<String> items) {
        if (this.servicePlan == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.servicePlan.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getServicePlan() {
        return this.servicePlan;
    }

    public String getServicePlan(int index) {
        return this.servicePlan.get(index);
    }

    public String getFirstServicePlan() {
        return this.servicePlan.get(0);
    }

    public String getLastServicePlan() {
        return this.servicePlan.get(this.servicePlan.size() - 1);
    }

    public String getMatchingServicePlan(Predicate<String> predicate) {
        for (String item : this.servicePlan) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingServicePlan(Predicate<String> predicate) {
        for (String item : this.servicePlan) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withServicePlan(List<String> servicePlan) {
        if (servicePlan != null) {
            this.servicePlan = new ArrayList<String>();
            for (String item : servicePlan) {
                this.addToServicePlan(item);
            }
        } else {
            this.servicePlan = null;
        }
        return (A)((Object)this);
    }

    public A withServicePlan(String ... servicePlan) {
        if (this.servicePlan != null) {
            this.servicePlan.clear();
            this._visitables.remove((Object)"servicePlan");
        }
        if (servicePlan != null) {
            for (String item : servicePlan) {
                this.addToServicePlan(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasServicePlan() {
        return this.servicePlan != null && !this.servicePlan.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CatalogRestrictionsFluent that = (CatalogRestrictionsFluent)((Object)o);
        if (!Objects.equals(this.serviceClass, that.serviceClass)) {
            return false;
        }
        return Objects.equals(this.servicePlan, that.servicePlan);
    }

    public int hashCode() {
        return Objects.hash(this.serviceClass, this.servicePlan, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.serviceClass != null && !this.serviceClass.isEmpty()) {
            sb.append("serviceClass:");
            sb.append(this.serviceClass + ",");
        }
        if (this.servicePlan != null && !this.servicePlan.isEmpty()) {
            sb.append("servicePlan:");
            sb.append(this.servicePlan);
        }
        sb.append("}");
        return sb.toString();
    }
}

