package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServicePlanListBuilder extends ServicePlanListFluent<ServicePlanListBuilder> implements VisitableBuilder<ServicePlanList,ServicePlanListBuilder>{
  public ServicePlanListBuilder() {
    this(false);
  }
  public ServicePlanListBuilder(Boolean validationEnabled) {
    this(new ServicePlanList(), validationEnabled);
  }
  public ServicePlanListBuilder(ServicePlanListFluent<?> fluent) {
    this(fluent, false);
  }
  public ServicePlanListBuilder(ServicePlanListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServicePlanList(), validationEnabled);
  }
  public ServicePlanListBuilder(ServicePlanListFluent<?> fluent,ServicePlanList instance) {
    this(fluent, instance, false);
  }
  public ServicePlanListBuilder(ServicePlanListFluent<?> fluent,ServicePlanList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ServicePlanList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ServicePlanListBuilder(ServicePlanList instance) {
    this(instance,false);
  }
  public ServicePlanListBuilder(ServicePlanList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ServicePlanList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  ServicePlanListFluent<?> fluent;
  Boolean validationEnabled;
  public ServicePlanList build() {
    ServicePlanList buildable = new ServicePlanList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}