package io.fabric8.servicecatalog.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ServiceInstancePropertiesStateFluent<A extends ServiceInstancePropertiesStateFluent<A>> extends BaseFluent<A>{
  public ServiceInstancePropertiesStateFluent() {
  }
  public ServiceInstancePropertiesStateFluent(ServiceInstancePropertiesState instance) {
    instance = (instance != null ? instance : new ServiceInstancePropertiesState());

    if (instance != null) {
      this.withClusterServicePlanExternalID(instance.getClusterServicePlanExternalID());
      this.withClusterServicePlanExternalName(instance.getClusterServicePlanExternalName());
      this.withParameterChecksum(instance.getParameterChecksum());
      this.withParameters(instance.getParameters());
      this.withServicePlanExternalID(instance.getServicePlanExternalID());
      this.withServicePlanExternalName(instance.getServicePlanExternalName());
      this.withUserInfo(instance.getUserInfo());
      this.withClusterServicePlanExternalID(instance.getClusterServicePlanExternalID());
      this.withClusterServicePlanExternalName(instance.getClusterServicePlanExternalName());
      this.withParameterChecksum(instance.getParameterChecksum());
      this.withParameters(instance.getParameters());
      this.withServicePlanExternalID(instance.getServicePlanExternalID());
      this.withServicePlanExternalName(instance.getServicePlanExternalName());
      this.withUserInfo(instance.getUserInfo());
    }
  }
  private String clusterServicePlanExternalID;
  private String clusterServicePlanExternalName;
  private String parameterChecksum;
  private Map<String,Object> parameters;
  private String servicePlanExternalID;
  private String servicePlanExternalName;
  private UserInfoBuilder userInfo;
  public String getClusterServicePlanExternalID() {
    return this.clusterServicePlanExternalID;
  }
  public A withClusterServicePlanExternalID(String clusterServicePlanExternalID) {
    this.clusterServicePlanExternalID=clusterServicePlanExternalID; return (A) this;
  }
  public boolean hasClusterServicePlanExternalID() {
    return this.clusterServicePlanExternalID != null;
  }
  public String getClusterServicePlanExternalName() {
    return this.clusterServicePlanExternalName;
  }
  public A withClusterServicePlanExternalName(String clusterServicePlanExternalName) {
    this.clusterServicePlanExternalName=clusterServicePlanExternalName; return (A) this;
  }
  public boolean hasClusterServicePlanExternalName() {
    return this.clusterServicePlanExternalName != null;
  }
  public String getParameterChecksum() {
    return this.parameterChecksum;
  }
  public A withParameterChecksum(String parameterChecksum) {
    this.parameterChecksum=parameterChecksum; return (A) this;
  }
  public boolean hasParameterChecksum() {
    return this.parameterChecksum != null;
  }
  public A addToParameters(String key,Object value) {
    if(this.parameters == null && key != null && value != null) { this.parameters = new LinkedHashMap(); }
    if(key != null && value != null) {this.parameters.put(key, value);} return (A)this;
  }
  public A addToParameters(Map<String,Object> map) {
    if(this.parameters == null && map != null) { this.parameters = new LinkedHashMap(); }
    if(map != null) { this.parameters.putAll(map);} return (A)this;
  }
  public A removeFromParameters(String key) {
    if(this.parameters == null) { return (A) this; }
    if(key != null && this.parameters != null) {this.parameters.remove(key);} return (A)this;
  }
  public A removeFromParameters(Map<String,Object> map) {
    if(this.parameters == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.parameters != null){this.parameters.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getParameters() {
    return this.parameters;
  }
  public <K,V>A withParameters(Map<String,Object> parameters) {
    if (parameters == null) { this.parameters =  null;} else {this.parameters = new LinkedHashMap(parameters);} return (A) this;
  }
  public boolean hasParameters() {
    return this.parameters != null;
  }
  public String getServicePlanExternalID() {
    return this.servicePlanExternalID;
  }
  public A withServicePlanExternalID(String servicePlanExternalID) {
    this.servicePlanExternalID=servicePlanExternalID; return (A) this;
  }
  public boolean hasServicePlanExternalID() {
    return this.servicePlanExternalID != null;
  }
  public String getServicePlanExternalName() {
    return this.servicePlanExternalName;
  }
  public A withServicePlanExternalName(String servicePlanExternalName) {
    this.servicePlanExternalName=servicePlanExternalName; return (A) this;
  }
  public boolean hasServicePlanExternalName() {
    return this.servicePlanExternalName != null;
  }
  public UserInfo buildUserInfo() {
    return this.userInfo!=null ?this.userInfo.build():null;
  }
  public A withUserInfo(UserInfo userInfo) {
    _visitables.get("userInfo").remove(this.userInfo);
    if (userInfo!=null){ this.userInfo= new UserInfoBuilder(userInfo); _visitables.get("userInfo").add(this.userInfo);} else { this.userInfo = null; _visitables.get("userInfo").remove(this.userInfo); } return (A) this;
  }
  public boolean hasUserInfo() {
    return this.userInfo != null;
  }
  public UserInfoNested<A> withNewUserInfo() {
    return new UserInfoNested(null);
  }
  public UserInfoNested<A> withNewUserInfoLike(UserInfo item) {
    return new UserInfoNested(item);
  }
  public UserInfoNested<A> editUserInfo() {
    return withNewUserInfoLike(java.util.Optional.ofNullable(buildUserInfo()).orElse(null));
  }
  public UserInfoNested<A> editOrNewUserInfo() {
    return withNewUserInfoLike(java.util.Optional.ofNullable(buildUserInfo()).orElse(new UserInfoBuilder().build()));
  }
  public UserInfoNested<A> editOrNewUserInfoLike(UserInfo item) {
    return withNewUserInfoLike(java.util.Optional.ofNullable(buildUserInfo()).orElse(item));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ServiceInstancePropertiesStateFluent that = (ServiceInstancePropertiesStateFluent) o;
    if (!java.util.Objects.equals(clusterServicePlanExternalID, that.clusterServicePlanExternalID)) return false;

    if (!java.util.Objects.equals(clusterServicePlanExternalName, that.clusterServicePlanExternalName)) return false;

    if (!java.util.Objects.equals(parameterChecksum, that.parameterChecksum)) return false;

    if (!java.util.Objects.equals(parameters, that.parameters)) return false;

    if (!java.util.Objects.equals(servicePlanExternalID, that.servicePlanExternalID)) return false;

    if (!java.util.Objects.equals(servicePlanExternalName, that.servicePlanExternalName)) return false;

    if (!java.util.Objects.equals(userInfo, that.userInfo)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(clusterServicePlanExternalID,  clusterServicePlanExternalName,  parameterChecksum,  parameters,  servicePlanExternalID,  servicePlanExternalName,  userInfo,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (clusterServicePlanExternalID != null) { sb.append("clusterServicePlanExternalID:"); sb.append(clusterServicePlanExternalID + ","); }
    if (clusterServicePlanExternalName != null) { sb.append("clusterServicePlanExternalName:"); sb.append(clusterServicePlanExternalName + ","); }
    if (parameterChecksum != null) { sb.append("parameterChecksum:"); sb.append(parameterChecksum + ","); }
    if (parameters != null && !parameters.isEmpty()) { sb.append("parameters:"); sb.append(parameters + ","); }
    if (servicePlanExternalID != null) { sb.append("servicePlanExternalID:"); sb.append(servicePlanExternalID + ","); }
    if (servicePlanExternalName != null) { sb.append("servicePlanExternalName:"); sb.append(servicePlanExternalName + ","); }
    if (userInfo != null) { sb.append("userInfo:"); sb.append(userInfo); }
    sb.append("}");
    return sb.toString();
  }
  public class UserInfoNested<N> extends UserInfoFluent<UserInfoNested<N>> implements Nested<N>{
    UserInfoNested(UserInfo item) {
      this.builder = new UserInfoBuilder(this, item);
    }
    UserInfoBuilder builder;
    public N and() {
      return (N) ServiceInstancePropertiesStateFluent.this.withUserInfo(builder.build());
    }
    public N endUserInfo() {
      return and();
    }
    
  }
  
}