package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceClassSpecBuilder extends ServiceClassSpecFluent<ServiceClassSpecBuilder> implements VisitableBuilder<ServiceClassSpec,ServiceClassSpecBuilder>{
  public ServiceClassSpecBuilder() {
    this(false);
  }
  public ServiceClassSpecBuilder(Boolean validationEnabled) {
    this(new ServiceClassSpec(), validationEnabled);
  }
  public ServiceClassSpecBuilder(ServiceClassSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceClassSpecBuilder(ServiceClassSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServiceClassSpec(), validationEnabled);
  }
  public ServiceClassSpecBuilder(ServiceClassSpecFluent<?> fluent,ServiceClassSpec instance) {
    this(fluent, instance, false);
  }
  public ServiceClassSpecBuilder(ServiceClassSpecFluent<?> fluent,ServiceClassSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ServiceClassSpec());

    if (instance != null) {
      fluent.withBindable(instance.getBindable());
      fluent.withBindingRetrievable(instance.getBindingRetrievable());
      fluent.withDefaultProvisionParameters(instance.getDefaultProvisionParameters());
      fluent.withDescription(instance.getDescription());
      fluent.withExternalID(instance.getExternalID());
      fluent.withExternalMetadata(instance.getExternalMetadata());
      fluent.withExternalName(instance.getExternalName());
      fluent.withPlanUpdatable(instance.getPlanUpdatable());
      fluent.withRequires(instance.getRequires());
      fluent.withServiceBrokerName(instance.getServiceBrokerName());
      fluent.withTags(instance.getTags());
      fluent.withBindable(instance.getBindable());
      fluent.withBindingRetrievable(instance.getBindingRetrievable());
      fluent.withDefaultProvisionParameters(instance.getDefaultProvisionParameters());
      fluent.withDescription(instance.getDescription());
      fluent.withExternalID(instance.getExternalID());
      fluent.withExternalMetadata(instance.getExternalMetadata());
      fluent.withExternalName(instance.getExternalName());
      fluent.withPlanUpdatable(instance.getPlanUpdatable());
      fluent.withRequires(instance.getRequires());
      fluent.withServiceBrokerName(instance.getServiceBrokerName());
      fluent.withTags(instance.getTags());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ServiceClassSpecBuilder(ServiceClassSpec instance) {
    this(instance,false);
  }
  public ServiceClassSpecBuilder(ServiceClassSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ServiceClassSpec());

    if (instance != null) {
      this.withBindable(instance.getBindable());
      this.withBindingRetrievable(instance.getBindingRetrievable());
      this.withDefaultProvisionParameters(instance.getDefaultProvisionParameters());
      this.withDescription(instance.getDescription());
      this.withExternalID(instance.getExternalID());
      this.withExternalMetadata(instance.getExternalMetadata());
      this.withExternalName(instance.getExternalName());
      this.withPlanUpdatable(instance.getPlanUpdatable());
      this.withRequires(instance.getRequires());
      this.withServiceBrokerName(instance.getServiceBrokerName());
      this.withTags(instance.getTags());
      this.withBindable(instance.getBindable());
      this.withBindingRetrievable(instance.getBindingRetrievable());
      this.withDefaultProvisionParameters(instance.getDefaultProvisionParameters());
      this.withDescription(instance.getDescription());
      this.withExternalID(instance.getExternalID());
      this.withExternalMetadata(instance.getExternalMetadata());
      this.withExternalName(instance.getExternalName());
      this.withPlanUpdatable(instance.getPlanUpdatable());
      this.withRequires(instance.getRequires());
      this.withServiceBrokerName(instance.getServiceBrokerName());
      this.withTags(instance.getTags());
    }
    this.validationEnabled = validationEnabled; 
  }
  ServiceClassSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ServiceClassSpec build() {
    ServiceClassSpec buildable = new ServiceClassSpec(fluent.getBindable(),fluent.getBindingRetrievable(),fluent.getDefaultProvisionParameters(),fluent.getDescription(),fluent.getExternalID(),fluent.getExternalMetadata(),fluent.getExternalName(),fluent.getPlanUpdatable(),fluent.getRequires(),fluent.getServiceBrokerName(),fluent.getTags());
    return buildable;
  }
  
}