package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterServicePlanBuilder extends ClusterServicePlanFluent<ClusterServicePlanBuilder> implements VisitableBuilder<ClusterServicePlan,ClusterServicePlanBuilder>{
  public ClusterServicePlanBuilder() {
    this(false);
  }
  public ClusterServicePlanBuilder(Boolean validationEnabled) {
    this(new ClusterServicePlan(), validationEnabled);
  }
  public ClusterServicePlanBuilder(ClusterServicePlanFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterServicePlanBuilder(ClusterServicePlanFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterServicePlan(), validationEnabled);
  }
  public ClusterServicePlanBuilder(ClusterServicePlanFluent<?> fluent,ClusterServicePlan instance) {
    this(fluent, instance, false);
  }
  public ClusterServicePlanBuilder(ClusterServicePlanFluent<?> fluent,ClusterServicePlan instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ClusterServicePlan());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterServicePlanBuilder(ClusterServicePlan instance) {
    this(instance,false);
  }
  public ClusterServicePlanBuilder(ClusterServicePlan instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ClusterServicePlan());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterServicePlanFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterServicePlan build() {
    ClusterServicePlan buildable = new ClusterServicePlan(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  
}