package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterServiceClassStatusBuilder extends ClusterServiceClassStatusFluent<ClusterServiceClassStatusBuilder> implements VisitableBuilder<ClusterServiceClassStatus,ClusterServiceClassStatusBuilder>{
  public ClusterServiceClassStatusBuilder() {
    this(false);
  }
  public ClusterServiceClassStatusBuilder(Boolean validationEnabled) {
    this(new ClusterServiceClassStatus(), validationEnabled);
  }
  public ClusterServiceClassStatusBuilder(ClusterServiceClassStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterServiceClassStatusBuilder(ClusterServiceClassStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterServiceClassStatus(), validationEnabled);
  }
  public ClusterServiceClassStatusBuilder(ClusterServiceClassStatusFluent<?> fluent,ClusterServiceClassStatus instance) {
    this(fluent, instance, false);
  }
  public ClusterServiceClassStatusBuilder(ClusterServiceClassStatusFluent<?> fluent,ClusterServiceClassStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ClusterServiceClassStatus());

    if (instance != null) {
      fluent.withRemovedFromBrokerCatalog(instance.getRemovedFromBrokerCatalog());
      fluent.withRemovedFromBrokerCatalog(instance.getRemovedFromBrokerCatalog());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterServiceClassStatusBuilder(ClusterServiceClassStatus instance) {
    this(instance,false);
  }
  public ClusterServiceClassStatusBuilder(ClusterServiceClassStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ClusterServiceClassStatus());

    if (instance != null) {
      this.withRemovedFromBrokerCatalog(instance.getRemovedFromBrokerCatalog());
      this.withRemovedFromBrokerCatalog(instance.getRemovedFromBrokerCatalog());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterServiceClassStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterServiceClassStatus build() {
    ClusterServiceClassStatus buildable = new ClusterServiceClassStatus(fluent.getRemovedFromBrokerCatalog());
    return buildable;
  }
  
}