package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BearerTokenAuthConfigBuilder extends BearerTokenAuthConfigFluent<BearerTokenAuthConfigBuilder> implements VisitableBuilder<BearerTokenAuthConfig,BearerTokenAuthConfigBuilder>{
  public BearerTokenAuthConfigBuilder() {
    this(false);
  }
  public BearerTokenAuthConfigBuilder(Boolean validationEnabled) {
    this(new BearerTokenAuthConfig(), validationEnabled);
  }
  public BearerTokenAuthConfigBuilder(BearerTokenAuthConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public BearerTokenAuthConfigBuilder(BearerTokenAuthConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new BearerTokenAuthConfig(), validationEnabled);
  }
  public BearerTokenAuthConfigBuilder(BearerTokenAuthConfigFluent<?> fluent,BearerTokenAuthConfig instance) {
    this(fluent, instance, false);
  }
  public BearerTokenAuthConfigBuilder(BearerTokenAuthConfigFluent<?> fluent,BearerTokenAuthConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new BearerTokenAuthConfig());

    if (instance != null) {
      fluent.withSecretRef(instance.getSecretRef());
      fluent.withSecretRef(instance.getSecretRef());
    }
    this.validationEnabled = validationEnabled; 
  }
  public BearerTokenAuthConfigBuilder(BearerTokenAuthConfig instance) {
    this(instance,false);
  }
  public BearerTokenAuthConfigBuilder(BearerTokenAuthConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new BearerTokenAuthConfig());

    if (instance != null) {
      this.withSecretRef(instance.getSecretRef());
      this.withSecretRef(instance.getSecretRef());
    }
    this.validationEnabled = validationEnabled; 
  }
  BearerTokenAuthConfigFluent<?> fluent;
  Boolean validationEnabled;
  public BearerTokenAuthConfig build() {
    BearerTokenAuthConfig buildable = new BearerTokenAuthConfig(fluent.buildSecretRef());
    return buildable;
  }
  
}