package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceInstanceConditionBuilder extends ServiceInstanceConditionFluentImpl<ServiceInstanceConditionBuilder> implements VisitableBuilder<ServiceInstanceCondition,ServiceInstanceConditionBuilder>{
  public ServiceInstanceConditionBuilder() {
    this(false);
  }
  public ServiceInstanceConditionBuilder(Boolean validationEnabled) {
    this(new ServiceInstanceCondition(), validationEnabled);
  }
  public ServiceInstanceConditionBuilder(ServiceInstanceConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceInstanceConditionBuilder(ServiceInstanceConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServiceInstanceCondition(), validationEnabled);
  }
  public ServiceInstanceConditionBuilder(ServiceInstanceConditionFluent<?> fluent,ServiceInstanceCondition instance) {
    this(fluent, instance, false);
  }
  public ServiceInstanceConditionBuilder(ServiceInstanceConditionFluent<?> fluent,ServiceInstanceCondition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withLastTransitionTime(instance.getLastTransitionTime());
      fluent.withMessage(instance.getMessage());
      fluent.withReason(instance.getReason());
      fluent.withStatus(instance.getStatus());
      fluent.withType(instance.getType());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ServiceInstanceConditionBuilder(ServiceInstanceCondition instance) {
    this(instance,false);
  }
  public ServiceInstanceConditionBuilder(ServiceInstanceCondition instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withLastTransitionTime(instance.getLastTransitionTime());
      this.withMessage(instance.getMessage());
      this.withReason(instance.getReason());
      this.withStatus(instance.getStatus());
      this.withType(instance.getType());
    }
    this.validationEnabled = validationEnabled; 
  }
  ServiceInstanceConditionFluent<?> fluent;
  Boolean validationEnabled;
  public ServiceInstanceCondition build() {
    ServiceInstanceCondition buildable = new ServiceInstanceCondition(fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    return buildable;
  }
  
}