package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceClassStatusBuilder extends ServiceClassStatusFluentImpl<ServiceClassStatusBuilder> implements VisitableBuilder<ServiceClassStatus,ServiceClassStatusBuilder>{
  public ServiceClassStatusBuilder() {
    this(false);
  }
  public ServiceClassStatusBuilder(Boolean validationEnabled) {
    this(new ServiceClassStatus(), validationEnabled);
  }
  public ServiceClassStatusBuilder(ServiceClassStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceClassStatusBuilder(ServiceClassStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServiceClassStatus(), validationEnabled);
  }
  public ServiceClassStatusBuilder(ServiceClassStatusFluent<?> fluent,ServiceClassStatus instance) {
    this(fluent, instance, false);
  }
  public ServiceClassStatusBuilder(ServiceClassStatusFluent<?> fluent,ServiceClassStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withRemovedFromBrokerCatalog(instance.getRemovedFromBrokerCatalog());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ServiceClassStatusBuilder(ServiceClassStatus instance) {
    this(instance,false);
  }
  public ServiceClassStatusBuilder(ServiceClassStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withRemovedFromBrokerCatalog(instance.getRemovedFromBrokerCatalog());
    }
    this.validationEnabled = validationEnabled; 
  }
  ServiceClassStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ServiceClassStatus build() {
    ServiceClassStatus buildable = new ServiceClassStatus(fluent.getRemovedFromBrokerCatalog());
    return buildable;
  }
  
}