package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceClassBuilder extends ServiceClassFluentImpl<ServiceClassBuilder> implements VisitableBuilder<ServiceClass,ServiceClassBuilder>{
  public ServiceClassBuilder() {
    this(false);
  }
  public ServiceClassBuilder(Boolean validationEnabled) {
    this(new ServiceClass(), validationEnabled);
  }
  public ServiceClassBuilder(ServiceClassFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceClassBuilder(ServiceClassFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServiceClass(), validationEnabled);
  }
  public ServiceClassBuilder(ServiceClassFluent<?> fluent,ServiceClass instance) {
    this(fluent, instance, false);
  }
  public ServiceClassBuilder(ServiceClassFluent<?> fluent,ServiceClass instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ServiceClassBuilder(ServiceClass instance) {
    this(instance,false);
  }
  public ServiceClassBuilder(ServiceClass instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  ServiceClassFluent<?> fluent;
  Boolean validationEnabled;
  public ServiceClass build() {
    ServiceClass buildable = new ServiceClass(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}