package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceBrokerListBuilder extends ServiceBrokerListFluentImpl<ServiceBrokerListBuilder> implements VisitableBuilder<ServiceBrokerList,ServiceBrokerListBuilder>{
  public ServiceBrokerListBuilder() {
    this(false);
  }
  public ServiceBrokerListBuilder(Boolean validationEnabled) {
    this(new ServiceBrokerList(), validationEnabled);
  }
  public ServiceBrokerListBuilder(ServiceBrokerListFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceBrokerListBuilder(ServiceBrokerListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServiceBrokerList(), validationEnabled);
  }
  public ServiceBrokerListBuilder(ServiceBrokerListFluent<?> fluent,ServiceBrokerList instance) {
    this(fluent, instance, false);
  }
  public ServiceBrokerListBuilder(ServiceBrokerListFluent<?> fluent,ServiceBrokerList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ServiceBrokerListBuilder(ServiceBrokerList instance) {
    this(instance,false);
  }
  public ServiceBrokerListBuilder(ServiceBrokerList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  ServiceBrokerListFluent<?> fluent;
  Boolean validationEnabled;
  public ServiceBrokerList build() {
    ServiceBrokerList buildable = new ServiceBrokerList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}