package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ServiceBindingStatusFluentImpl<A extends ServiceBindingStatusFluent<A>> extends BaseFluent<A> implements ServiceBindingStatusFluent<A>{
  public ServiceBindingStatusFluentImpl() {
  }
  public ServiceBindingStatusFluentImpl(ServiceBindingStatus instance) {
    if (instance != null) {
      this.withAsyncOpInProgress(instance.getAsyncOpInProgress());
      this.withConditions(instance.getConditions());
      this.withCurrentOperation(instance.getCurrentOperation());
      this.withExternalProperties(instance.getExternalProperties());
      this.withInProgressProperties(instance.getInProgressProperties());
      this.withLastOperation(instance.getLastOperation());
      this.withOperationStartTime(instance.getOperationStartTime());
      this.withOrphanMitigationInProgress(instance.getOrphanMitigationInProgress());
      this.withReconciledGeneration(instance.getReconciledGeneration());
      this.withUnbindStatus(instance.getUnbindStatus());
    }
  }
  private Boolean asyncOpInProgress;
  private ArrayList<ServiceBindingConditionBuilder> conditions = new ArrayList<ServiceBindingConditionBuilder>();
  private String currentOperation;
  private ServiceBindingPropertiesStateBuilder externalProperties;
  private ServiceBindingPropertiesStateBuilder inProgressProperties;
  private String lastOperation;
  private String operationStartTime;
  private Boolean orphanMitigationInProgress;
  private Long reconciledGeneration;
  private String unbindStatus;
  public Boolean getAsyncOpInProgress() {
    return this.asyncOpInProgress;
  }
  public A withAsyncOpInProgress(Boolean asyncOpInProgress) {
    this.asyncOpInProgress=asyncOpInProgress; return (A) this;
  }
  public Boolean hasAsyncOpInProgress() {
    return this.asyncOpInProgress != null;
  }
  public A addToConditions(int index,ServiceBindingCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ServiceBindingConditionBuilder>();}
    ServiceBindingConditionBuilder builder = new ServiceBindingConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").add(index, builder); conditions.add(index, builder);}
    return (A)this;
  }
  public A setToConditions(int index,ServiceBindingCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ServiceBindingConditionBuilder>();}
    ServiceBindingConditionBuilder builder = new ServiceBindingConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").set(index, builder); conditions.set(index, builder);}
    return (A)this;
  }
  public A addToConditions(io.fabric8.servicecatalog.api.model.ServiceBindingCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ServiceBindingConditionBuilder>();}
    for (ServiceBindingCondition item : items) {ServiceBindingConditionBuilder builder = new ServiceBindingConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<ServiceBindingCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ServiceBindingConditionBuilder>();}
    for (ServiceBindingCondition item : items) {ServiceBindingConditionBuilder builder = new ServiceBindingConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.servicecatalog.api.model.ServiceBindingCondition... items) {
    for (ServiceBindingCondition item : items) {ServiceBindingConditionBuilder builder = new ServiceBindingConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<ServiceBindingCondition> items) {
    for (ServiceBindingCondition item : items) {ServiceBindingConditionBuilder builder = new ServiceBindingConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<ServiceBindingConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<ServiceBindingConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      ServiceBindingConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ServiceBindingCondition> getConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public List<ServiceBindingCondition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public ServiceBindingCondition buildCondition(int index) {
    return this.conditions.get(index).build();
  }
  public ServiceBindingCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public ServiceBindingCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public ServiceBindingCondition buildMatchingCondition(Predicate<ServiceBindingConditionBuilder> predicate) {
    for (ServiceBindingConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<ServiceBindingConditionBuilder> predicate) {
    for (ServiceBindingConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<ServiceBindingCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").clear();}
    if (conditions != null) {this.conditions = new ArrayList(); for (ServiceBindingCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.servicecatalog.api.model.ServiceBindingCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear(); _visitables.remove("conditions"); }
    if (conditions != null) {for (ServiceBindingCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)addToConditions(new ServiceBindingCondition(lastTransitionTime, message, reason, status, type));
  }
  public ServiceBindingStatusFluentImpl.ConditionsNested<A> addNewCondition() {
    return new ServiceBindingStatusFluentImpl.ConditionsNestedImpl();
  }
  public ServiceBindingStatusFluentImpl.ConditionsNested<A> addNewConditionLike(ServiceBindingCondition item) {
    return new ServiceBindingStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public ServiceBindingStatusFluentImpl.ConditionsNested<A> setNewConditionLike(int index,ServiceBindingCondition item) {
    return new ServiceBindingStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public ServiceBindingStatusFluentImpl.ConditionsNested<A> editCondition(int index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public ServiceBindingStatusFluentImpl.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public ServiceBindingStatusFluentImpl.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public ServiceBindingStatusFluentImpl.ConditionsNested<A> editMatchingCondition(Predicate<ServiceBindingConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public String getCurrentOperation() {
    return this.currentOperation;
  }
  public A withCurrentOperation(String currentOperation) {
    this.currentOperation=currentOperation; return (A) this;
  }
  public Boolean hasCurrentOperation() {
    return this.currentOperation != null;
  }
  
  /**
   * This method has been deprecated, please use method buildExternalProperties instead.
   * @return The buildable object.
   */
  @Deprecated
  public ServiceBindingPropertiesState getExternalProperties() {
    return this.externalProperties!=null ?this.externalProperties.build():null;
  }
  public ServiceBindingPropertiesState buildExternalProperties() {
    return this.externalProperties!=null ?this.externalProperties.build():null;
  }
  public A withExternalProperties(ServiceBindingPropertiesState externalProperties) {
    _visitables.get("externalProperties").remove(this.externalProperties);
    if (externalProperties!=null){ this.externalProperties= new ServiceBindingPropertiesStateBuilder(externalProperties); _visitables.get("externalProperties").add(this.externalProperties);} else { this.externalProperties = null; _visitables.get("externalProperties").remove(this.externalProperties); } return (A) this;
  }
  public Boolean hasExternalProperties() {
    return this.externalProperties != null;
  }
  public ServiceBindingStatusFluentImpl.ExternalPropertiesNested<A> withNewExternalProperties() {
    return new ServiceBindingStatusFluentImpl.ExternalPropertiesNestedImpl();
  }
  public ServiceBindingStatusFluentImpl.ExternalPropertiesNested<A> withNewExternalPropertiesLike(ServiceBindingPropertiesState item) {
    return new ServiceBindingStatusFluentImpl.ExternalPropertiesNestedImpl(item);
  }
  public ServiceBindingStatusFluentImpl.ExternalPropertiesNested<A> editExternalProperties() {
    return withNewExternalPropertiesLike(getExternalProperties());
  }
  public ServiceBindingStatusFluentImpl.ExternalPropertiesNested<A> editOrNewExternalProperties() {
    return withNewExternalPropertiesLike(getExternalProperties() != null ? getExternalProperties(): new ServiceBindingPropertiesStateBuilder().build());
  }
  public ServiceBindingStatusFluentImpl.ExternalPropertiesNested<A> editOrNewExternalPropertiesLike(ServiceBindingPropertiesState item) {
    return withNewExternalPropertiesLike(getExternalProperties() != null ? getExternalProperties(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildInProgressProperties instead.
   * @return The buildable object.
   */
  @Deprecated
  public ServiceBindingPropertiesState getInProgressProperties() {
    return this.inProgressProperties!=null ?this.inProgressProperties.build():null;
  }
  public ServiceBindingPropertiesState buildInProgressProperties() {
    return this.inProgressProperties!=null ?this.inProgressProperties.build():null;
  }
  public A withInProgressProperties(ServiceBindingPropertiesState inProgressProperties) {
    _visitables.get("inProgressProperties").remove(this.inProgressProperties);
    if (inProgressProperties!=null){ this.inProgressProperties= new ServiceBindingPropertiesStateBuilder(inProgressProperties); _visitables.get("inProgressProperties").add(this.inProgressProperties);} else { this.inProgressProperties = null; _visitables.get("inProgressProperties").remove(this.inProgressProperties); } return (A) this;
  }
  public Boolean hasInProgressProperties() {
    return this.inProgressProperties != null;
  }
  public ServiceBindingStatusFluentImpl.InProgressPropertiesNested<A> withNewInProgressProperties() {
    return new ServiceBindingStatusFluentImpl.InProgressPropertiesNestedImpl();
  }
  public ServiceBindingStatusFluentImpl.InProgressPropertiesNested<A> withNewInProgressPropertiesLike(ServiceBindingPropertiesState item) {
    return new ServiceBindingStatusFluentImpl.InProgressPropertiesNestedImpl(item);
  }
  public ServiceBindingStatusFluentImpl.InProgressPropertiesNested<A> editInProgressProperties() {
    return withNewInProgressPropertiesLike(getInProgressProperties());
  }
  public ServiceBindingStatusFluentImpl.InProgressPropertiesNested<A> editOrNewInProgressProperties() {
    return withNewInProgressPropertiesLike(getInProgressProperties() != null ? getInProgressProperties(): new ServiceBindingPropertiesStateBuilder().build());
  }
  public ServiceBindingStatusFluentImpl.InProgressPropertiesNested<A> editOrNewInProgressPropertiesLike(ServiceBindingPropertiesState item) {
    return withNewInProgressPropertiesLike(getInProgressProperties() != null ? getInProgressProperties(): item);
  }
  public String getLastOperation() {
    return this.lastOperation;
  }
  public A withLastOperation(String lastOperation) {
    this.lastOperation=lastOperation; return (A) this;
  }
  public Boolean hasLastOperation() {
    return this.lastOperation != null;
  }
  public String getOperationStartTime() {
    return this.operationStartTime;
  }
  public A withOperationStartTime(String operationStartTime) {
    this.operationStartTime=operationStartTime; return (A) this;
  }
  public Boolean hasOperationStartTime() {
    return this.operationStartTime != null;
  }
  public Boolean getOrphanMitigationInProgress() {
    return this.orphanMitigationInProgress;
  }
  public A withOrphanMitigationInProgress(Boolean orphanMitigationInProgress) {
    this.orphanMitigationInProgress=orphanMitigationInProgress; return (A) this;
  }
  public Boolean hasOrphanMitigationInProgress() {
    return this.orphanMitigationInProgress != null;
  }
  public Long getReconciledGeneration() {
    return this.reconciledGeneration;
  }
  public A withReconciledGeneration(Long reconciledGeneration) {
    this.reconciledGeneration=reconciledGeneration; return (A) this;
  }
  public Boolean hasReconciledGeneration() {
    return this.reconciledGeneration != null;
  }
  public String getUnbindStatus() {
    return this.unbindStatus;
  }
  public A withUnbindStatus(String unbindStatus) {
    this.unbindStatus=unbindStatus; return (A) this;
  }
  public Boolean hasUnbindStatus() {
    return this.unbindStatus != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ServiceBindingStatusFluentImpl that = (ServiceBindingStatusFluentImpl) o;
    if (!java.util.Objects.equals(asyncOpInProgress, that.asyncOpInProgress)) return false;

    if (!java.util.Objects.equals(conditions, that.conditions)) return false;

    if (!java.util.Objects.equals(currentOperation, that.currentOperation)) return false;

    if (!java.util.Objects.equals(externalProperties, that.externalProperties)) return false;

    if (!java.util.Objects.equals(inProgressProperties, that.inProgressProperties)) return false;

    if (!java.util.Objects.equals(lastOperation, that.lastOperation)) return false;

    if (!java.util.Objects.equals(operationStartTime, that.operationStartTime)) return false;

    if (!java.util.Objects.equals(orphanMitigationInProgress, that.orphanMitigationInProgress)) return false;

    if (!java.util.Objects.equals(reconciledGeneration, that.reconciledGeneration)) return false;

    if (!java.util.Objects.equals(unbindStatus, that.unbindStatus)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(asyncOpInProgress,  conditions,  currentOperation,  externalProperties,  inProgressProperties,  lastOperation,  operationStartTime,  orphanMitigationInProgress,  reconciledGeneration,  unbindStatus,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (asyncOpInProgress != null) { sb.append("asyncOpInProgress:"); sb.append(asyncOpInProgress + ","); }
    if (conditions != null) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (currentOperation != null) { sb.append("currentOperation:"); sb.append(currentOperation + ","); }
    if (externalProperties != null) { sb.append("externalProperties:"); sb.append(externalProperties + ","); }
    if (inProgressProperties != null) { sb.append("inProgressProperties:"); sb.append(inProgressProperties + ","); }
    if (lastOperation != null) { sb.append("lastOperation:"); sb.append(lastOperation + ","); }
    if (operationStartTime != null) { sb.append("operationStartTime:"); sb.append(operationStartTime + ","); }
    if (orphanMitigationInProgress != null) { sb.append("orphanMitigationInProgress:"); sb.append(orphanMitigationInProgress + ","); }
    if (reconciledGeneration != null) { sb.append("reconciledGeneration:"); sb.append(reconciledGeneration + ","); }
    if (unbindStatus != null) { sb.append("unbindStatus:"); sb.append(unbindStatus); }
    sb.append("}");
    return sb.toString();
  }
  public A withAsyncOpInProgress() {
    return withAsyncOpInProgress(true);
  }
  public A withOrphanMitigationInProgress() {
    return withOrphanMitigationInProgress(true);
  }
  class ConditionsNestedImpl<N> extends ServiceBindingConditionFluentImpl<ServiceBindingStatusFluentImpl.ConditionsNested<N>> implements ServiceBindingStatusFluentImpl.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(int index,ServiceBindingCondition item) {
      this.index = index;
      this.builder = new ServiceBindingConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new ServiceBindingConditionBuilder(this);
    }
    ServiceBindingConditionBuilder builder;
    int index;
    public N and() {
      return (N) ServiceBindingStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  class ExternalPropertiesNestedImpl<N> extends ServiceBindingPropertiesStateFluentImpl<ServiceBindingStatusFluentImpl.ExternalPropertiesNested<N>> implements ServiceBindingStatusFluentImpl.ExternalPropertiesNested<N>,Nested<N>{
    ExternalPropertiesNestedImpl(ServiceBindingPropertiesState item) {
      this.builder = new ServiceBindingPropertiesStateBuilder(this, item);
    }
    ExternalPropertiesNestedImpl() {
      this.builder = new ServiceBindingPropertiesStateBuilder(this);
    }
    ServiceBindingPropertiesStateBuilder builder;
    public N and() {
      return (N) ServiceBindingStatusFluentImpl.this.withExternalProperties(builder.build());
    }
    public N endExternalProperties() {
      return and();
    }
    
  }
  class InProgressPropertiesNestedImpl<N> extends ServiceBindingPropertiesStateFluentImpl<ServiceBindingStatusFluentImpl.InProgressPropertiesNested<N>> implements ServiceBindingStatusFluentImpl.InProgressPropertiesNested<N>,Nested<N>{
    InProgressPropertiesNestedImpl(ServiceBindingPropertiesState item) {
      this.builder = new ServiceBindingPropertiesStateBuilder(this, item);
    }
    InProgressPropertiesNestedImpl() {
      this.builder = new ServiceBindingPropertiesStateBuilder(this);
    }
    ServiceBindingPropertiesStateBuilder builder;
    public N and() {
      return (N) ServiceBindingStatusFluentImpl.this.withInProgressProperties(builder.build());
    }
    public N endInProgressProperties() {
      return and();
    }
    
  }
  
}