package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterBearerTokenAuthConfigBuilder extends ClusterBearerTokenAuthConfigFluentImpl<ClusterBearerTokenAuthConfigBuilder> implements VisitableBuilder<ClusterBearerTokenAuthConfig,ClusterBearerTokenAuthConfigBuilder>{
  public ClusterBearerTokenAuthConfigBuilder() {
    this(false);
  }
  public ClusterBearerTokenAuthConfigBuilder(Boolean validationEnabled) {
    this(new ClusterBearerTokenAuthConfig(), validationEnabled);
  }
  public ClusterBearerTokenAuthConfigBuilder(ClusterBearerTokenAuthConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterBearerTokenAuthConfigBuilder(ClusterBearerTokenAuthConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterBearerTokenAuthConfig(), validationEnabled);
  }
  public ClusterBearerTokenAuthConfigBuilder(ClusterBearerTokenAuthConfigFluent<?> fluent,ClusterBearerTokenAuthConfig instance) {
    this(fluent, instance, false);
  }
  public ClusterBearerTokenAuthConfigBuilder(ClusterBearerTokenAuthConfigFluent<?> fluent,ClusterBearerTokenAuthConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withSecretRef(instance.getSecretRef());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterBearerTokenAuthConfigBuilder(ClusterBearerTokenAuthConfig instance) {
    this(instance,false);
  }
  public ClusterBearerTokenAuthConfigBuilder(ClusterBearerTokenAuthConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withSecretRef(instance.getSecretRef());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterBearerTokenAuthConfigFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterBearerTokenAuthConfig build() {
    ClusterBearerTokenAuthConfig buildable = new ClusterBearerTokenAuthConfig(fluent.getSecretRef());
    return buildable;
  }
  
}