package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AddKeyTransformBuilder extends AddKeyTransformFluentImpl<AddKeyTransformBuilder> implements VisitableBuilder<AddKeyTransform,AddKeyTransformBuilder>{
  public AddKeyTransformBuilder() {
    this(false);
  }
  public AddKeyTransformBuilder(Boolean validationEnabled) {
    this(new AddKeyTransform(), validationEnabled);
  }
  public AddKeyTransformBuilder(AddKeyTransformFluent<?> fluent) {
    this(fluent, false);
  }
  public AddKeyTransformBuilder(AddKeyTransformFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AddKeyTransform(), validationEnabled);
  }
  public AddKeyTransformBuilder(AddKeyTransformFluent<?> fluent,AddKeyTransform instance) {
    this(fluent, instance, false);
  }
  public AddKeyTransformBuilder(AddKeyTransformFluent<?> fluent,AddKeyTransform instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withJsonPathExpression(instance.getJsonPathExpression());
      fluent.withKey(instance.getKey());
      fluent.withStringValue(instance.getStringValue());
      fluent.withValue(instance.getValue());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AddKeyTransformBuilder(AddKeyTransform instance) {
    this(instance,false);
  }
  public AddKeyTransformBuilder(AddKeyTransform instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withJsonPathExpression(instance.getJsonPathExpression());
      this.withKey(instance.getKey());
      this.withStringValue(instance.getStringValue());
      this.withValue(instance.getValue());
    }
    this.validationEnabled = validationEnabled; 
  }
  AddKeyTransformFluent<?> fluent;
  Boolean validationEnabled;
  public AddKeyTransform build() {
    AddKeyTransform buildable = new AddKeyTransform(fluent.getJsonPathExpression(),fluent.getKey(),fluent.getStringValue(),fluent.getValue());
    return buildable;
  }
  
}