package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServicePlanStatusBuilder extends ServicePlanStatusFluentImpl<ServicePlanStatusBuilder> implements VisitableBuilder<ServicePlanStatus,ServicePlanStatusBuilder>{
  public ServicePlanStatusBuilder() {
    this(false);
  }
  public ServicePlanStatusBuilder(Boolean validationEnabled) {
    this(new ServicePlanStatus(), validationEnabled);
  }
  public ServicePlanStatusBuilder(ServicePlanStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ServicePlanStatusBuilder(ServicePlanStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServicePlanStatus(), validationEnabled);
  }
  public ServicePlanStatusBuilder(ServicePlanStatusFluent<?> fluent,ServicePlanStatus instance) {
    this(fluent, instance, false);
  }
  public ServicePlanStatusBuilder(ServicePlanStatusFluent<?> fluent,ServicePlanStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withRemovedFromBrokerCatalog(instance.getRemovedFromBrokerCatalog()); 
    this.validationEnabled = validationEnabled; 
  }
  public ServicePlanStatusBuilder(ServicePlanStatus instance) {
    this(instance,false);
  }
  public ServicePlanStatusBuilder(ServicePlanStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withRemovedFromBrokerCatalog(instance.getRemovedFromBrokerCatalog()); 
    this.validationEnabled = validationEnabled; 
  }
  ServicePlanStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ServicePlanStatus build() {
    ServicePlanStatus buildable = new ServicePlanStatus(fluent.getRemovedFromBrokerCatalog());
    return buildable;
  }
  
}