package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServicePlanSpecBuilder extends ServicePlanSpecFluentImpl<ServicePlanSpecBuilder> implements VisitableBuilder<ServicePlanSpec,ServicePlanSpecBuilder>{
  public ServicePlanSpecBuilder() {
    this(false);
  }
  public ServicePlanSpecBuilder(Boolean validationEnabled) {
    this(new ServicePlanSpec(), validationEnabled);
  }
  public ServicePlanSpecBuilder(ServicePlanSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ServicePlanSpecBuilder(ServicePlanSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServicePlanSpec(), validationEnabled);
  }
  public ServicePlanSpecBuilder(ServicePlanSpecFluent<?> fluent,ServicePlanSpec instance) {
    this(fluent, instance, false);
  }
  public ServicePlanSpecBuilder(ServicePlanSpecFluent<?> fluent,ServicePlanSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withBindable(instance.getBindable()); 
    fluent.withDefaultProvisionParameters(instance.getDefaultProvisionParameters()); 
    fluent.withDescription(instance.getDescription()); 
    fluent.withExternalID(instance.getExternalID()); 
    fluent.withExternalMetadata(instance.getExternalMetadata()); 
    fluent.withExternalName(instance.getExternalName()); 
    fluent.withFree(instance.getFree()); 
    fluent.withInstanceCreateParameterSchema(instance.getInstanceCreateParameterSchema()); 
    fluent.withInstanceUpdateParameterSchema(instance.getInstanceUpdateParameterSchema()); 
    fluent.withServiceBindingCreateParameterSchema(instance.getServiceBindingCreateParameterSchema()); 
    fluent.withServiceBindingCreateResponseSchema(instance.getServiceBindingCreateResponseSchema()); 
    fluent.withServiceBrokerName(instance.getServiceBrokerName()); 
    fluent.withServiceClassRef(instance.getServiceClassRef()); 
    this.validationEnabled = validationEnabled; 
  }
  public ServicePlanSpecBuilder(ServicePlanSpec instance) {
    this(instance,false);
  }
  public ServicePlanSpecBuilder(ServicePlanSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withBindable(instance.getBindable()); 
    this.withDefaultProvisionParameters(instance.getDefaultProvisionParameters()); 
    this.withDescription(instance.getDescription()); 
    this.withExternalID(instance.getExternalID()); 
    this.withExternalMetadata(instance.getExternalMetadata()); 
    this.withExternalName(instance.getExternalName()); 
    this.withFree(instance.getFree()); 
    this.withInstanceCreateParameterSchema(instance.getInstanceCreateParameterSchema()); 
    this.withInstanceUpdateParameterSchema(instance.getInstanceUpdateParameterSchema()); 
    this.withServiceBindingCreateParameterSchema(instance.getServiceBindingCreateParameterSchema()); 
    this.withServiceBindingCreateResponseSchema(instance.getServiceBindingCreateResponseSchema()); 
    this.withServiceBrokerName(instance.getServiceBrokerName()); 
    this.withServiceClassRef(instance.getServiceClassRef()); 
    this.validationEnabled = validationEnabled; 
  }
  ServicePlanSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ServicePlanSpec build() {
    ServicePlanSpec buildable = new ServicePlanSpec(fluent.getBindable(),fluent.getDefaultProvisionParameters(),fluent.getDescription(),fluent.getExternalID(),fluent.getExternalMetadata(),fluent.getExternalName(),fluent.getFree(),fluent.getInstanceCreateParameterSchema(),fluent.getInstanceUpdateParameterSchema(),fluent.getServiceBindingCreateParameterSchema(),fluent.getServiceBindingCreateResponseSchema(),fluent.getServiceBrokerName(),fluent.getServiceClassRef());
    return buildable;
  }
  
}