package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ServiceBrokerStatusFluentImpl<A extends ServiceBrokerStatusFluent<A>> extends BaseFluent<A> implements ServiceBrokerStatusFluent<A>{
  public ServiceBrokerStatusFluentImpl() {
  }
  public ServiceBrokerStatusFluentImpl(ServiceBrokerStatus instance) {
    this.withConditions(instance.getConditions()); 
    this.withLastCatalogRetrievalTime(instance.getLastCatalogRetrievalTime()); 
    this.withOperationStartTime(instance.getOperationStartTime()); 
    this.withReconciledGeneration(instance.getReconciledGeneration()); 
  }
  private ArrayList<ServiceBrokerConditionBuilder> conditions = new ArrayList<ServiceBrokerConditionBuilder>();
  private String lastCatalogRetrievalTime;
  private String operationStartTime;
  private Long reconciledGeneration;
  public A addToConditions(Integer index,ServiceBrokerCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ServiceBrokerConditionBuilder>();}
    ServiceBrokerConditionBuilder builder = new ServiceBrokerConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
  }
  public A setToConditions(Integer index,ServiceBrokerCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ServiceBrokerConditionBuilder>();}
    ServiceBrokerConditionBuilder builder = new ServiceBrokerConditionBuilder(item);
    if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
    if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
     return (A)this;
  }
  public A addToConditions(io.fabric8.servicecatalog.api.model.ServiceBrokerCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ServiceBrokerConditionBuilder>();}
    for (ServiceBrokerCondition item : items) {ServiceBrokerConditionBuilder builder = new ServiceBrokerConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<ServiceBrokerCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ServiceBrokerConditionBuilder>();}
    for (ServiceBrokerCondition item : items) {ServiceBrokerConditionBuilder builder = new ServiceBrokerConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.servicecatalog.api.model.ServiceBrokerCondition... items) {
    for (ServiceBrokerCondition item : items) {ServiceBrokerConditionBuilder builder = new ServiceBrokerConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<ServiceBrokerCondition> items) {
    for (ServiceBrokerCondition item : items) {ServiceBrokerConditionBuilder builder = new ServiceBrokerConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<ServiceBrokerConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<ServiceBrokerConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      ServiceBrokerConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ServiceBrokerCondition> getConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public List<ServiceBrokerCondition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public ServiceBrokerCondition buildCondition(Integer index) {
    return this.conditions.get(index).build();
  }
  public ServiceBrokerCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public ServiceBrokerCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public ServiceBrokerCondition buildMatchingCondition(Predicate<ServiceBrokerConditionBuilder> predicate) {
    for (ServiceBrokerConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<ServiceBrokerConditionBuilder> predicate) {
    for (ServiceBrokerConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<ServiceBrokerCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
    if (conditions != null) {this.conditions = new ArrayList(); for (ServiceBrokerCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.servicecatalog.api.model.ServiceBrokerCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (ServiceBrokerCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)addToConditions(new ServiceBrokerCondition(lastTransitionTime, message, reason, status, type));
  }
  public ServiceBrokerStatusFluent.ConditionsNested<A> addNewCondition() {
    return new ServiceBrokerStatusFluentImpl.ConditionsNestedImpl();
  }
  public ServiceBrokerStatusFluent.ConditionsNested<A> addNewConditionLike(ServiceBrokerCondition item) {
    return new ServiceBrokerStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public ServiceBrokerStatusFluent.ConditionsNested<A> setNewConditionLike(Integer index,ServiceBrokerCondition item) {
    return new ServiceBrokerStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public ServiceBrokerStatusFluent.ConditionsNested<A> editCondition(Integer index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public ServiceBrokerStatusFluent.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public ServiceBrokerStatusFluent.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public ServiceBrokerStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<ServiceBrokerConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public String getLastCatalogRetrievalTime() {
    return this.lastCatalogRetrievalTime;
  }
  public A withLastCatalogRetrievalTime(String lastCatalogRetrievalTime) {
    this.lastCatalogRetrievalTime=lastCatalogRetrievalTime; return (A) this;
  }
  public Boolean hasLastCatalogRetrievalTime() {
    return this.lastCatalogRetrievalTime != null;
  }
  public String getOperationStartTime() {
    return this.operationStartTime;
  }
  public A withOperationStartTime(String operationStartTime) {
    this.operationStartTime=operationStartTime; return (A) this;
  }
  public Boolean hasOperationStartTime() {
    return this.operationStartTime != null;
  }
  public Long getReconciledGeneration() {
    return this.reconciledGeneration;
  }
  public A withReconciledGeneration(Long reconciledGeneration) {
    this.reconciledGeneration=reconciledGeneration; return (A) this;
  }
  public Boolean hasReconciledGeneration() {
    return this.reconciledGeneration != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ServiceBrokerStatusFluentImpl that = (ServiceBrokerStatusFluentImpl) o;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (lastCatalogRetrievalTime != null ? !lastCatalogRetrievalTime.equals(that.lastCatalogRetrievalTime) :that.lastCatalogRetrievalTime != null) return false;
    if (operationStartTime != null ? !operationStartTime.equals(that.operationStartTime) :that.operationStartTime != null) return false;
    if (reconciledGeneration != null ? !reconciledGeneration.equals(that.reconciledGeneration) :that.reconciledGeneration != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(conditions,  lastCatalogRetrievalTime,  operationStartTime,  reconciledGeneration,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (lastCatalogRetrievalTime != null) { sb.append("lastCatalogRetrievalTime:"); sb.append(lastCatalogRetrievalTime + ","); }
    if (operationStartTime != null) { sb.append("operationStartTime:"); sb.append(operationStartTime + ","); }
    if (reconciledGeneration != null) { sb.append("reconciledGeneration:"); sb.append(reconciledGeneration); }
    sb.append("}");
    return sb.toString();
  }
  class ConditionsNestedImpl<N> extends ServiceBrokerConditionFluentImpl<ServiceBrokerStatusFluent.ConditionsNested<N>> implements ServiceBrokerStatusFluent.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(Integer index,ServiceBrokerCondition item) {
      this.index = index;
      this.builder = new ServiceBrokerConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new ServiceBrokerConditionBuilder(this);
    }
    ServiceBrokerConditionBuilder builder;
    Integer index;
    public N and() {
      return (N) ServiceBrokerStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  
}