package io.fabric8.servicecatalog.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ServiceBrokerFluentImpl<A extends ServiceBrokerFluent<A>> extends BaseFluent<A> implements ServiceBrokerFluent<A>{
  public ServiceBrokerFluentImpl() {
  }
  public ServiceBrokerFluentImpl(ServiceBroker instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
  }
  private String apiVersion;
  private String kind;
  private ObjectMetaBuilder metadata;
  private ServiceBrokerSpecBuilder spec;
  private ServiceBrokerStatusBuilder status;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public ServiceBrokerFluent.MetadataNested<A> withNewMetadata() {
    return new ServiceBrokerFluentImpl.MetadataNestedImpl();
  }
  public ServiceBrokerFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new ServiceBrokerFluentImpl.MetadataNestedImpl(item);
  }
  public ServiceBrokerFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public ServiceBrokerFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public ServiceBrokerFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public ServiceBrokerSpec getSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public ServiceBrokerSpec buildSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public A withSpec(ServiceBrokerSpec spec) {
    _visitables.get("spec").remove(this.spec);
    if (spec!=null){ this.spec= new ServiceBrokerSpecBuilder(spec); _visitables.get("spec").add(this.spec);} else { this.spec = null; _visitables.get("spec").remove(this.spec); } return (A) this;
  }
  public Boolean hasSpec() {
    return this.spec != null;
  }
  public ServiceBrokerFluent.SpecNested<A> withNewSpec() {
    return new ServiceBrokerFluentImpl.SpecNestedImpl();
  }
  public ServiceBrokerFluent.SpecNested<A> withNewSpecLike(ServiceBrokerSpec item) {
    return new ServiceBrokerFluentImpl.SpecNestedImpl(item);
  }
  public ServiceBrokerFluent.SpecNested<A> editSpec() {
    return withNewSpecLike(getSpec());
  }
  public ServiceBrokerFluent.SpecNested<A> editOrNewSpec() {
    return withNewSpecLike(getSpec() != null ? getSpec(): new ServiceBrokerSpecBuilder().build());
  }
  public ServiceBrokerFluent.SpecNested<A> editOrNewSpecLike(ServiceBrokerSpec item) {
    return withNewSpecLike(getSpec() != null ? getSpec(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public ServiceBrokerStatus getStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public ServiceBrokerStatus buildStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public A withStatus(ServiceBrokerStatus status) {
    _visitables.get("status").remove(this.status);
    if (status!=null){ this.status= new ServiceBrokerStatusBuilder(status); _visitables.get("status").add(this.status);} else { this.status = null; _visitables.get("status").remove(this.status); } return (A) this;
  }
  public Boolean hasStatus() {
    return this.status != null;
  }
  public ServiceBrokerFluent.StatusNested<A> withNewStatus() {
    return new ServiceBrokerFluentImpl.StatusNestedImpl();
  }
  public ServiceBrokerFluent.StatusNested<A> withNewStatusLike(ServiceBrokerStatus item) {
    return new ServiceBrokerFluentImpl.StatusNestedImpl(item);
  }
  public ServiceBrokerFluent.StatusNested<A> editStatus() {
    return withNewStatusLike(getStatus());
  }
  public ServiceBrokerFluent.StatusNested<A> editOrNewStatus() {
    return withNewStatusLike(getStatus() != null ? getStatus(): new ServiceBrokerStatusBuilder().build());
  }
  public ServiceBrokerFluent.StatusNested<A> editOrNewStatusLike(ServiceBrokerStatus item) {
    return withNewStatusLike(getStatus() != null ? getStatus(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ServiceBrokerFluentImpl that = (ServiceBrokerFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
    if (status != null ? !status.equals(that.status) :that.status != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  metadata,  spec,  status,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (spec != null) { sb.append("spec:"); sb.append(spec + ","); }
    if (status != null) { sb.append("status:"); sb.append(status); }
    sb.append("}");
    return sb.toString();
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<ServiceBrokerFluent.MetadataNested<N>> implements ServiceBrokerFluent.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) ServiceBrokerFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class SpecNestedImpl<N> extends ServiceBrokerSpecFluentImpl<ServiceBrokerFluent.SpecNested<N>> implements ServiceBrokerFluent.SpecNested<N>,Nested<N>{
    SpecNestedImpl(ServiceBrokerSpec item) {
      this.builder = new ServiceBrokerSpecBuilder(this, item);
    }
    SpecNestedImpl() {
      this.builder = new ServiceBrokerSpecBuilder(this);
    }
    ServiceBrokerSpecBuilder builder;
    public N and() {
      return (N) ServiceBrokerFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec() {
      return and();
    }
    
  }
  class StatusNestedImpl<N> extends ServiceBrokerStatusFluentImpl<ServiceBrokerFluent.StatusNested<N>> implements ServiceBrokerFluent.StatusNested<N>,Nested<N>{
    StatusNestedImpl(ServiceBrokerStatus item) {
      this.builder = new ServiceBrokerStatusBuilder(this, item);
    }
    StatusNestedImpl() {
      this.builder = new ServiceBrokerStatusBuilder(this);
    }
    ServiceBrokerStatusBuilder builder;
    public N and() {
      return (N) ServiceBrokerFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus() {
      return and();
    }
    
  }
  
}