package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterServiceClassListBuilder extends ClusterServiceClassListFluentImpl<ClusterServiceClassListBuilder> implements VisitableBuilder<ClusterServiceClassList,ClusterServiceClassListBuilder>{
  public ClusterServiceClassListBuilder() {
    this(false);
  }
  public ClusterServiceClassListBuilder(Boolean validationEnabled) {
    this(new ClusterServiceClassList(), validationEnabled);
  }
  public ClusterServiceClassListBuilder(ClusterServiceClassListFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterServiceClassListBuilder(ClusterServiceClassListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterServiceClassList(), validationEnabled);
  }
  public ClusterServiceClassListBuilder(ClusterServiceClassListFluent<?> fluent,ClusterServiceClassList instance) {
    this(fluent, instance, false);
  }
  public ClusterServiceClassListBuilder(ClusterServiceClassListFluent<?> fluent,ClusterServiceClassList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  public ClusterServiceClassListBuilder(ClusterServiceClassList instance) {
    this(instance,false);
  }
  public ClusterServiceClassListBuilder(ClusterServiceClassList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  ClusterServiceClassListFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterServiceClassList build() {
    ClusterServiceClassList buildable = new ClusterServiceClassList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}