package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ServiceInstanceStatusFluentImpl<A extends ServiceInstanceStatusFluent<A>> extends BaseFluent<A> implements ServiceInstanceStatusFluent<A>{
  public ServiceInstanceStatusFluentImpl() {
  }
  public ServiceInstanceStatusFluentImpl(ServiceInstanceStatus instance) {
    this.withAsyncOpInProgress(instance.getAsyncOpInProgress()); 
    this.withConditions(instance.getConditions()); 
    this.withCurrentOperation(instance.getCurrentOperation()); 
    this.withDashboardURL(instance.getDashboardURL()); 
    this.withDefaultProvisionParameters(instance.getDefaultProvisionParameters()); 
    this.withDeprovisionStatus(instance.getDeprovisionStatus()); 
    this.withExternalProperties(instance.getExternalProperties()); 
    this.withInProgressProperties(instance.getInProgressProperties()); 
    this.withLastOperation(instance.getLastOperation()); 
    this.withObservedGeneration(instance.getObservedGeneration()); 
    this.withOperationStartTime(instance.getOperationStartTime()); 
    this.withOrphanMitigationInProgress(instance.getOrphanMitigationInProgress()); 
    this.withProvisionStatus(instance.getProvisionStatus()); 
    this.withReconciledGeneration(instance.getReconciledGeneration()); 
  }
  private Boolean asyncOpInProgress;
  private ArrayList<ServiceInstanceConditionBuilder> conditions = new ArrayList<ServiceInstanceConditionBuilder>();
  private String currentOperation;
  private String dashboardURL;
  private Map<String,Object> defaultProvisionParameters;
  private String deprovisionStatus;
  private ServiceInstancePropertiesStateBuilder externalProperties;
  private ServiceInstancePropertiesStateBuilder inProgressProperties;
  private String lastOperation;
  private Long observedGeneration;
  private String operationStartTime;
  private Boolean orphanMitigationInProgress;
  private String provisionStatus;
  private Long reconciledGeneration;
  public Boolean getAsyncOpInProgress() {
    return this.asyncOpInProgress;
  }
  public A withAsyncOpInProgress(Boolean asyncOpInProgress) {
    this.asyncOpInProgress=asyncOpInProgress; return (A) this;
  }
  public Boolean hasAsyncOpInProgress() {
    return this.asyncOpInProgress != null;
  }
  public A addToConditions(Integer index,ServiceInstanceCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ServiceInstanceConditionBuilder>();}
    ServiceInstanceConditionBuilder builder = new ServiceInstanceConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
  }
  public A setToConditions(Integer index,ServiceInstanceCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ServiceInstanceConditionBuilder>();}
    ServiceInstanceConditionBuilder builder = new ServiceInstanceConditionBuilder(item);
    if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
    if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
     return (A)this;
  }
  public A addToConditions(io.fabric8.servicecatalog.api.model.ServiceInstanceCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ServiceInstanceConditionBuilder>();}
    for (ServiceInstanceCondition item : items) {ServiceInstanceConditionBuilder builder = new ServiceInstanceConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<ServiceInstanceCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ServiceInstanceConditionBuilder>();}
    for (ServiceInstanceCondition item : items) {ServiceInstanceConditionBuilder builder = new ServiceInstanceConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.servicecatalog.api.model.ServiceInstanceCondition... items) {
    for (ServiceInstanceCondition item : items) {ServiceInstanceConditionBuilder builder = new ServiceInstanceConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<ServiceInstanceCondition> items) {
    for (ServiceInstanceCondition item : items) {ServiceInstanceConditionBuilder builder = new ServiceInstanceConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<ServiceInstanceConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<ServiceInstanceConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      ServiceInstanceConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ServiceInstanceCondition> getConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public List<ServiceInstanceCondition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public ServiceInstanceCondition buildCondition(Integer index) {
    return this.conditions.get(index).build();
  }
  public ServiceInstanceCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public ServiceInstanceCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public ServiceInstanceCondition buildMatchingCondition(Predicate<ServiceInstanceConditionBuilder> predicate) {
    for (ServiceInstanceConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<ServiceInstanceConditionBuilder> predicate) {
    for (ServiceInstanceConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<ServiceInstanceCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
    if (conditions != null) {this.conditions = new ArrayList(); for (ServiceInstanceCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.servicecatalog.api.model.ServiceInstanceCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (ServiceInstanceCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)addToConditions(new ServiceInstanceCondition(lastTransitionTime, message, reason, status, type));
  }
  public ServiceInstanceStatusFluent.ConditionsNested<A> addNewCondition() {
    return new ServiceInstanceStatusFluentImpl.ConditionsNestedImpl();
  }
  public ServiceInstanceStatusFluent.ConditionsNested<A> addNewConditionLike(ServiceInstanceCondition item) {
    return new ServiceInstanceStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public ServiceInstanceStatusFluent.ConditionsNested<A> setNewConditionLike(Integer index,ServiceInstanceCondition item) {
    return new ServiceInstanceStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public ServiceInstanceStatusFluent.ConditionsNested<A> editCondition(Integer index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public ServiceInstanceStatusFluent.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public ServiceInstanceStatusFluent.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public ServiceInstanceStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<ServiceInstanceConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public String getCurrentOperation() {
    return this.currentOperation;
  }
  public A withCurrentOperation(String currentOperation) {
    this.currentOperation=currentOperation; return (A) this;
  }
  public Boolean hasCurrentOperation() {
    return this.currentOperation != null;
  }
  public String getDashboardURL() {
    return this.dashboardURL;
  }
  public A withDashboardURL(String dashboardURL) {
    this.dashboardURL=dashboardURL; return (A) this;
  }
  public Boolean hasDashboardURL() {
    return this.dashboardURL != null;
  }
  public A addToDefaultProvisionParameters(String key,Object value) {
    if(this.defaultProvisionParameters == null && key != null && value != null) { this.defaultProvisionParameters = new LinkedHashMap(); }
    if(key != null && value != null) {this.defaultProvisionParameters.put(key, value);} return (A)this;
  }
  public A addToDefaultProvisionParameters(Map<String,Object> map) {
    if(this.defaultProvisionParameters == null && map != null) { this.defaultProvisionParameters = new LinkedHashMap(); }
    if(map != null) { this.defaultProvisionParameters.putAll(map);} return (A)this;
  }
  public A removeFromDefaultProvisionParameters(String key) {
    if(this.defaultProvisionParameters == null) { return (A) this; }
    if(key != null && this.defaultProvisionParameters != null) {this.defaultProvisionParameters.remove(key);} return (A)this;
  }
  public A removeFromDefaultProvisionParameters(Map<String,Object> map) {
    if(this.defaultProvisionParameters == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.defaultProvisionParameters != null){this.defaultProvisionParameters.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getDefaultProvisionParameters() {
    return this.defaultProvisionParameters;
  }
  public <K,V>A withDefaultProvisionParameters(Map<String,Object> defaultProvisionParameters) {
    if (defaultProvisionParameters == null) { this.defaultProvisionParameters =  null;} else {this.defaultProvisionParameters = new LinkedHashMap(defaultProvisionParameters);} return (A) this;
  }
  public Boolean hasDefaultProvisionParameters() {
    return this.defaultProvisionParameters != null;
  }
  public String getDeprovisionStatus() {
    return this.deprovisionStatus;
  }
  public A withDeprovisionStatus(String deprovisionStatus) {
    this.deprovisionStatus=deprovisionStatus; return (A) this;
  }
  public Boolean hasDeprovisionStatus() {
    return this.deprovisionStatus != null;
  }
  
  /**
   * This method has been deprecated, please use method buildExternalProperties instead.
   * @return The buildable object.
   */
  @Deprecated
  public ServiceInstancePropertiesState getExternalProperties() {
    return this.externalProperties!=null ?this.externalProperties.build():null;
  }
  public ServiceInstancePropertiesState buildExternalProperties() {
    return this.externalProperties!=null ?this.externalProperties.build():null;
  }
  public A withExternalProperties(ServiceInstancePropertiesState externalProperties) {
    _visitables.get("externalProperties").remove(this.externalProperties);
    if (externalProperties!=null){ this.externalProperties= new ServiceInstancePropertiesStateBuilder(externalProperties); _visitables.get("externalProperties").add(this.externalProperties);} else { this.externalProperties = null; _visitables.get("externalProperties").remove(this.externalProperties); } return (A) this;
  }
  public Boolean hasExternalProperties() {
    return this.externalProperties != null;
  }
  public ServiceInstanceStatusFluent.ExternalPropertiesNested<A> withNewExternalProperties() {
    return new ServiceInstanceStatusFluentImpl.ExternalPropertiesNestedImpl();
  }
  public ServiceInstanceStatusFluent.ExternalPropertiesNested<A> withNewExternalPropertiesLike(ServiceInstancePropertiesState item) {
    return new ServiceInstanceStatusFluentImpl.ExternalPropertiesNestedImpl(item);
  }
  public ServiceInstanceStatusFluent.ExternalPropertiesNested<A> editExternalProperties() {
    return withNewExternalPropertiesLike(getExternalProperties());
  }
  public ServiceInstanceStatusFluent.ExternalPropertiesNested<A> editOrNewExternalProperties() {
    return withNewExternalPropertiesLike(getExternalProperties() != null ? getExternalProperties(): new ServiceInstancePropertiesStateBuilder().build());
  }
  public ServiceInstanceStatusFluent.ExternalPropertiesNested<A> editOrNewExternalPropertiesLike(ServiceInstancePropertiesState item) {
    return withNewExternalPropertiesLike(getExternalProperties() != null ? getExternalProperties(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildInProgressProperties instead.
   * @return The buildable object.
   */
  @Deprecated
  public ServiceInstancePropertiesState getInProgressProperties() {
    return this.inProgressProperties!=null ?this.inProgressProperties.build():null;
  }
  public ServiceInstancePropertiesState buildInProgressProperties() {
    return this.inProgressProperties!=null ?this.inProgressProperties.build():null;
  }
  public A withInProgressProperties(ServiceInstancePropertiesState inProgressProperties) {
    _visitables.get("inProgressProperties").remove(this.inProgressProperties);
    if (inProgressProperties!=null){ this.inProgressProperties= new ServiceInstancePropertiesStateBuilder(inProgressProperties); _visitables.get("inProgressProperties").add(this.inProgressProperties);} else { this.inProgressProperties = null; _visitables.get("inProgressProperties").remove(this.inProgressProperties); } return (A) this;
  }
  public Boolean hasInProgressProperties() {
    return this.inProgressProperties != null;
  }
  public ServiceInstanceStatusFluent.InProgressPropertiesNested<A> withNewInProgressProperties() {
    return new ServiceInstanceStatusFluentImpl.InProgressPropertiesNestedImpl();
  }
  public ServiceInstanceStatusFluent.InProgressPropertiesNested<A> withNewInProgressPropertiesLike(ServiceInstancePropertiesState item) {
    return new ServiceInstanceStatusFluentImpl.InProgressPropertiesNestedImpl(item);
  }
  public ServiceInstanceStatusFluent.InProgressPropertiesNested<A> editInProgressProperties() {
    return withNewInProgressPropertiesLike(getInProgressProperties());
  }
  public ServiceInstanceStatusFluent.InProgressPropertiesNested<A> editOrNewInProgressProperties() {
    return withNewInProgressPropertiesLike(getInProgressProperties() != null ? getInProgressProperties(): new ServiceInstancePropertiesStateBuilder().build());
  }
  public ServiceInstanceStatusFluent.InProgressPropertiesNested<A> editOrNewInProgressPropertiesLike(ServiceInstancePropertiesState item) {
    return withNewInProgressPropertiesLike(getInProgressProperties() != null ? getInProgressProperties(): item);
  }
  public String getLastOperation() {
    return this.lastOperation;
  }
  public A withLastOperation(String lastOperation) {
    this.lastOperation=lastOperation; return (A) this;
  }
  public Boolean hasLastOperation() {
    return this.lastOperation != null;
  }
  public Long getObservedGeneration() {
    return this.observedGeneration;
  }
  public A withObservedGeneration(Long observedGeneration) {
    this.observedGeneration=observedGeneration; return (A) this;
  }
  public Boolean hasObservedGeneration() {
    return this.observedGeneration != null;
  }
  public String getOperationStartTime() {
    return this.operationStartTime;
  }
  public A withOperationStartTime(String operationStartTime) {
    this.operationStartTime=operationStartTime; return (A) this;
  }
  public Boolean hasOperationStartTime() {
    return this.operationStartTime != null;
  }
  public Boolean getOrphanMitigationInProgress() {
    return this.orphanMitigationInProgress;
  }
  public A withOrphanMitigationInProgress(Boolean orphanMitigationInProgress) {
    this.orphanMitigationInProgress=orphanMitigationInProgress; return (A) this;
  }
  public Boolean hasOrphanMitigationInProgress() {
    return this.orphanMitigationInProgress != null;
  }
  public String getProvisionStatus() {
    return this.provisionStatus;
  }
  public A withProvisionStatus(String provisionStatus) {
    this.provisionStatus=provisionStatus; return (A) this;
  }
  public Boolean hasProvisionStatus() {
    return this.provisionStatus != null;
  }
  public Long getReconciledGeneration() {
    return this.reconciledGeneration;
  }
  public A withReconciledGeneration(Long reconciledGeneration) {
    this.reconciledGeneration=reconciledGeneration; return (A) this;
  }
  public Boolean hasReconciledGeneration() {
    return this.reconciledGeneration != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ServiceInstanceStatusFluentImpl that = (ServiceInstanceStatusFluentImpl) o;
    if (asyncOpInProgress != null ? !asyncOpInProgress.equals(that.asyncOpInProgress) :that.asyncOpInProgress != null) return false;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (currentOperation != null ? !currentOperation.equals(that.currentOperation) :that.currentOperation != null) return false;
    if (dashboardURL != null ? !dashboardURL.equals(that.dashboardURL) :that.dashboardURL != null) return false;
    if (defaultProvisionParameters != null ? !defaultProvisionParameters.equals(that.defaultProvisionParameters) :that.defaultProvisionParameters != null) return false;
    if (deprovisionStatus != null ? !deprovisionStatus.equals(that.deprovisionStatus) :that.deprovisionStatus != null) return false;
    if (externalProperties != null ? !externalProperties.equals(that.externalProperties) :that.externalProperties != null) return false;
    if (inProgressProperties != null ? !inProgressProperties.equals(that.inProgressProperties) :that.inProgressProperties != null) return false;
    if (lastOperation != null ? !lastOperation.equals(that.lastOperation) :that.lastOperation != null) return false;
    if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
    if (operationStartTime != null ? !operationStartTime.equals(that.operationStartTime) :that.operationStartTime != null) return false;
    if (orphanMitigationInProgress != null ? !orphanMitigationInProgress.equals(that.orphanMitigationInProgress) :that.orphanMitigationInProgress != null) return false;
    if (provisionStatus != null ? !provisionStatus.equals(that.provisionStatus) :that.provisionStatus != null) return false;
    if (reconciledGeneration != null ? !reconciledGeneration.equals(that.reconciledGeneration) :that.reconciledGeneration != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(asyncOpInProgress,  conditions,  currentOperation,  dashboardURL,  defaultProvisionParameters,  deprovisionStatus,  externalProperties,  inProgressProperties,  lastOperation,  observedGeneration,  operationStartTime,  orphanMitigationInProgress,  provisionStatus,  reconciledGeneration,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (asyncOpInProgress != null) { sb.append("asyncOpInProgress:"); sb.append(asyncOpInProgress + ","); }
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (currentOperation != null) { sb.append("currentOperation:"); sb.append(currentOperation + ","); }
    if (dashboardURL != null) { sb.append("dashboardURL:"); sb.append(dashboardURL + ","); }
    if (defaultProvisionParameters != null && !defaultProvisionParameters.isEmpty()) { sb.append("defaultProvisionParameters:"); sb.append(defaultProvisionParameters + ","); }
    if (deprovisionStatus != null) { sb.append("deprovisionStatus:"); sb.append(deprovisionStatus + ","); }
    if (externalProperties != null) { sb.append("externalProperties:"); sb.append(externalProperties + ","); }
    if (inProgressProperties != null) { sb.append("inProgressProperties:"); sb.append(inProgressProperties + ","); }
    if (lastOperation != null) { sb.append("lastOperation:"); sb.append(lastOperation + ","); }
    if (observedGeneration != null) { sb.append("observedGeneration:"); sb.append(observedGeneration + ","); }
    if (operationStartTime != null) { sb.append("operationStartTime:"); sb.append(operationStartTime + ","); }
    if (orphanMitigationInProgress != null) { sb.append("orphanMitigationInProgress:"); sb.append(orphanMitigationInProgress + ","); }
    if (provisionStatus != null) { sb.append("provisionStatus:"); sb.append(provisionStatus + ","); }
    if (reconciledGeneration != null) { sb.append("reconciledGeneration:"); sb.append(reconciledGeneration); }
    sb.append("}");
    return sb.toString();
  }
  public A withAsyncOpInProgress() {
    return withAsyncOpInProgress(true);
  }
  public A withOrphanMitigationInProgress() {
    return withOrphanMitigationInProgress(true);
  }
  class ConditionsNestedImpl<N> extends ServiceInstanceConditionFluentImpl<ServiceInstanceStatusFluent.ConditionsNested<N>> implements ServiceInstanceStatusFluent.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(Integer index,ServiceInstanceCondition item) {
      this.index = index;
      this.builder = new ServiceInstanceConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new ServiceInstanceConditionBuilder(this);
    }
    ServiceInstanceConditionBuilder builder;
    Integer index;
    public N and() {
      return (N) ServiceInstanceStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  class ExternalPropertiesNestedImpl<N> extends ServiceInstancePropertiesStateFluentImpl<ServiceInstanceStatusFluent.ExternalPropertiesNested<N>> implements ServiceInstanceStatusFluent.ExternalPropertiesNested<N>,Nested<N>{
    ExternalPropertiesNestedImpl(ServiceInstancePropertiesState item) {
      this.builder = new ServiceInstancePropertiesStateBuilder(this, item);
    }
    ExternalPropertiesNestedImpl() {
      this.builder = new ServiceInstancePropertiesStateBuilder(this);
    }
    ServiceInstancePropertiesStateBuilder builder;
    public N and() {
      return (N) ServiceInstanceStatusFluentImpl.this.withExternalProperties(builder.build());
    }
    public N endExternalProperties() {
      return and();
    }
    
  }
  class InProgressPropertiesNestedImpl<N> extends ServiceInstancePropertiesStateFluentImpl<ServiceInstanceStatusFluent.InProgressPropertiesNested<N>> implements ServiceInstanceStatusFluent.InProgressPropertiesNested<N>,Nested<N>{
    InProgressPropertiesNestedImpl(ServiceInstancePropertiesState item) {
      this.builder = new ServiceInstancePropertiesStateBuilder(this, item);
    }
    InProgressPropertiesNestedImpl() {
      this.builder = new ServiceInstancePropertiesStateBuilder(this);
    }
    ServiceInstancePropertiesStateBuilder builder;
    public N and() {
      return (N) ServiceInstanceStatusFluentImpl.this.withInProgressProperties(builder.build());
    }
    public N endInProgressProperties() {
      return and();
    }
    
  }
  
}