package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceInstancePropertiesStateBuilder extends ServiceInstancePropertiesStateFluentImpl<ServiceInstancePropertiesStateBuilder> implements VisitableBuilder<ServiceInstancePropertiesState,ServiceInstancePropertiesStateBuilder>{
  public ServiceInstancePropertiesStateBuilder() {
    this(false);
  }
  public ServiceInstancePropertiesStateBuilder(Boolean validationEnabled) {
    this(new ServiceInstancePropertiesState(), validationEnabled);
  }
  public ServiceInstancePropertiesStateBuilder(ServiceInstancePropertiesStateFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceInstancePropertiesStateBuilder(ServiceInstancePropertiesStateFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServiceInstancePropertiesState(), validationEnabled);
  }
  public ServiceInstancePropertiesStateBuilder(ServiceInstancePropertiesStateFluent<?> fluent,ServiceInstancePropertiesState instance) {
    this(fluent, instance, false);
  }
  public ServiceInstancePropertiesStateBuilder(ServiceInstancePropertiesStateFluent<?> fluent,ServiceInstancePropertiesState instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withClusterServicePlanExternalID(instance.getClusterServicePlanExternalID()); 
    fluent.withClusterServicePlanExternalName(instance.getClusterServicePlanExternalName()); 
    fluent.withParameterChecksum(instance.getParameterChecksum()); 
    fluent.withParameters(instance.getParameters()); 
    fluent.withServicePlanExternalID(instance.getServicePlanExternalID()); 
    fluent.withServicePlanExternalName(instance.getServicePlanExternalName()); 
    fluent.withUserInfo(instance.getUserInfo()); 
    this.validationEnabled = validationEnabled; 
  }
  public ServiceInstancePropertiesStateBuilder(ServiceInstancePropertiesState instance) {
    this(instance,false);
  }
  public ServiceInstancePropertiesStateBuilder(ServiceInstancePropertiesState instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withClusterServicePlanExternalID(instance.getClusterServicePlanExternalID()); 
    this.withClusterServicePlanExternalName(instance.getClusterServicePlanExternalName()); 
    this.withParameterChecksum(instance.getParameterChecksum()); 
    this.withParameters(instance.getParameters()); 
    this.withServicePlanExternalID(instance.getServicePlanExternalID()); 
    this.withServicePlanExternalName(instance.getServicePlanExternalName()); 
    this.withUserInfo(instance.getUserInfo()); 
    this.validationEnabled = validationEnabled; 
  }
  ServiceInstancePropertiesStateFluent<?> fluent;
  Boolean validationEnabled;
  public ServiceInstancePropertiesState build() {
    ServiceInstancePropertiesState buildable = new ServiceInstancePropertiesState(fluent.getClusterServicePlanExternalID(),fluent.getClusterServicePlanExternalName(),fluent.getParameterChecksum(),fluent.getParameters(),fluent.getServicePlanExternalID(),fluent.getServicePlanExternalName(),fluent.getUserInfo());
    return buildable;
  }
  
}