package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterObjectReferenceBuilder extends ClusterObjectReferenceFluentImpl<ClusterObjectReferenceBuilder> implements VisitableBuilder<ClusterObjectReference,ClusterObjectReferenceBuilder>{
  public ClusterObjectReferenceBuilder() {
    this(false);
  }
  public ClusterObjectReferenceBuilder(Boolean validationEnabled) {
    this(new ClusterObjectReference(), validationEnabled);
  }
  public ClusterObjectReferenceBuilder(ClusterObjectReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterObjectReferenceBuilder(ClusterObjectReferenceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterObjectReference(), validationEnabled);
  }
  public ClusterObjectReferenceBuilder(ClusterObjectReferenceFluent<?> fluent,ClusterObjectReference instance) {
    this(fluent, instance, false);
  }
  public ClusterObjectReferenceBuilder(ClusterObjectReferenceFluent<?> fluent,ClusterObjectReference instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withName(instance.getName()); 
    this.validationEnabled = validationEnabled; 
  }
  public ClusterObjectReferenceBuilder(ClusterObjectReference instance) {
    this(instance,false);
  }
  public ClusterObjectReferenceBuilder(ClusterObjectReference instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withName(instance.getName()); 
    this.validationEnabled = validationEnabled; 
  }
  ClusterObjectReferenceFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterObjectReference build() {
    ClusterObjectReference buildable = new ClusterObjectReference(fluent.getName());
    return buildable;
  }
  
}