package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ServiceBindingSpecFluent<A extends ServiceBindingSpecFluent<A>> extends BaseFluent<A>{
  public ServiceBindingSpecFluent() {
  }
  
  public ServiceBindingSpecFluent(ServiceBindingSpec instance) {
    this.copyInstance(instance);
  }
  private String externalID;
  private LocalObjectReferenceBuilder instanceRef;
  private Map<String,Object> parameters;
  private ArrayList<ParametersFromSourceBuilder> parametersFrom = new ArrayList<ParametersFromSourceBuilder>();
  private String secretName;
  private ArrayList<SecretTransformBuilder> secretTransforms = new ArrayList<SecretTransformBuilder>();
  private UserInfoBuilder userInfo;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ServiceBindingSpec instance) {
    instance = (instance != null ? instance : new ServiceBindingSpec());
    if (instance != null) {
          this.withExternalID(instance.getExternalID());
          this.withInstanceRef(instance.getInstanceRef());
          this.withParameters(instance.getParameters());
          this.withParametersFrom(instance.getParametersFrom());
          this.withSecretName(instance.getSecretName());
          this.withSecretTransforms(instance.getSecretTransforms());
          this.withUserInfo(instance.getUserInfo());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getExternalID() {
    return this.externalID;
  }
  
  public A withExternalID(String externalID) {
    this.externalID = externalID;
    return (A) this;
  }
  
  public boolean hasExternalID() {
    return this.externalID != null;
  }
  
  public LocalObjectReference buildInstanceRef() {
    return this.instanceRef != null ? this.instanceRef.build() : null;
  }
  
  public A withInstanceRef(LocalObjectReference instanceRef) {
    this._visitables.remove("instanceRef");
    if (instanceRef != null) {
        this.instanceRef = new LocalObjectReferenceBuilder(instanceRef);
        this._visitables.get("instanceRef").add(this.instanceRef);
    } else {
        this.instanceRef = null;
        this._visitables.get("instanceRef").remove(this.instanceRef);
    }
    return (A) this;
  }
  
  public boolean hasInstanceRef() {
    return this.instanceRef != null;
  }
  
  public A withNewInstanceRef(String name) {
    return (A)withInstanceRef(new LocalObjectReference(name));
  }
  
  public InstanceRefNested<A> withNewInstanceRef() {
    return new InstanceRefNested(null);
  }
  
  public InstanceRefNested<A> withNewInstanceRefLike(LocalObjectReference item) {
    return new InstanceRefNested(item);
  }
  
  public InstanceRefNested<A> editInstanceRef() {
    return withNewInstanceRefLike(java.util.Optional.ofNullable(buildInstanceRef()).orElse(null));
  }
  
  public InstanceRefNested<A> editOrNewInstanceRef() {
    return withNewInstanceRefLike(java.util.Optional.ofNullable(buildInstanceRef()).orElse(new LocalObjectReferenceBuilder().build()));
  }
  
  public InstanceRefNested<A> editOrNewInstanceRefLike(LocalObjectReference item) {
    return withNewInstanceRefLike(java.util.Optional.ofNullable(buildInstanceRef()).orElse(item));
  }
  
  public A addToParameters(String key,Object value) {
    if(this.parameters == null && key != null && value != null) { this.parameters = new LinkedHashMap(); }
    if(key != null && value != null) {this.parameters.put(key, value);} return (A)this;
  }
  
  public A addToParameters(Map<String,Object> map) {
    if(this.parameters == null && map != null) { this.parameters = new LinkedHashMap(); }
    if(map != null) { this.parameters.putAll(map);} return (A)this;
  }
  
  public A removeFromParameters(String key) {
    if(this.parameters == null) { return (A) this; }
    if(key != null && this.parameters != null) {this.parameters.remove(key);} return (A)this;
  }
  
  public A removeFromParameters(Map<String,Object> map) {
    if(this.parameters == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.parameters != null){this.parameters.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getParameters() {
    return this.parameters;
  }
  
  public <K,V>A withParameters(Map<String,Object> parameters) {
    if (parameters == null) {
      this.parameters = null;
    } else {
      this.parameters = new LinkedHashMap(parameters);
    }
    return (A) this;
  }
  
  public boolean hasParameters() {
    return this.parameters != null;
  }
  
  public A addToParametersFrom(int index,ParametersFromSource item) {
    if (this.parametersFrom == null) {this.parametersFrom = new ArrayList<ParametersFromSourceBuilder>();}
    ParametersFromSourceBuilder builder = new ParametersFromSourceBuilder(item);
    if (index < 0 || index >= parametersFrom.size()) { _visitables.get("parametersFrom").add(builder); parametersFrom.add(builder); } else { _visitables.get("parametersFrom").add(index, builder); parametersFrom.add(index, builder);}
    return (A)this;
  }
  
  public A setToParametersFrom(int index,ParametersFromSource item) {
    if (this.parametersFrom == null) {this.parametersFrom = new ArrayList<ParametersFromSourceBuilder>();}
    ParametersFromSourceBuilder builder = new ParametersFromSourceBuilder(item);
    if (index < 0 || index >= parametersFrom.size()) { _visitables.get("parametersFrom").add(builder); parametersFrom.add(builder); } else { _visitables.get("parametersFrom").set(index, builder); parametersFrom.set(index, builder);}
    return (A)this;
  }
  
  public A addToParametersFrom(io.fabric8.servicecatalog.api.model.ParametersFromSource... items) {
    if (this.parametersFrom == null) {this.parametersFrom = new ArrayList<ParametersFromSourceBuilder>();}
    for (ParametersFromSource item : items) {ParametersFromSourceBuilder builder = new ParametersFromSourceBuilder(item);_visitables.get("parametersFrom").add(builder);this.parametersFrom.add(builder);} return (A)this;
  }
  
  public A addAllToParametersFrom(Collection<ParametersFromSource> items) {
    if (this.parametersFrom == null) {this.parametersFrom = new ArrayList<ParametersFromSourceBuilder>();}
    for (ParametersFromSource item : items) {ParametersFromSourceBuilder builder = new ParametersFromSourceBuilder(item);_visitables.get("parametersFrom").add(builder);this.parametersFrom.add(builder);} return (A)this;
  }
  
  public A removeFromParametersFrom(io.fabric8.servicecatalog.api.model.ParametersFromSource... items) {
    if (this.parametersFrom == null) return (A)this;
    for (ParametersFromSource item : items) {ParametersFromSourceBuilder builder = new ParametersFromSourceBuilder(item);_visitables.get("parametersFrom").remove(builder); this.parametersFrom.remove(builder);} return (A)this;
  }
  
  public A removeAllFromParametersFrom(Collection<ParametersFromSource> items) {
    if (this.parametersFrom == null) return (A)this;
    for (ParametersFromSource item : items) {ParametersFromSourceBuilder builder = new ParametersFromSourceBuilder(item);_visitables.get("parametersFrom").remove(builder); this.parametersFrom.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromParametersFrom(Predicate<ParametersFromSourceBuilder> predicate) {
    if (parametersFrom == null) return (A) this;
    final Iterator<ParametersFromSourceBuilder> each = parametersFrom.iterator();
    final List visitables = _visitables.get("parametersFrom");
    while (each.hasNext()) {
      ParametersFromSourceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ParametersFromSource> buildParametersFrom() {
    return this.parametersFrom != null ? build(parametersFrom) : null;
  }
  
  public ParametersFromSource buildParametersFrom(int index) {
    return this.parametersFrom.get(index).build();
  }
  
  public ParametersFromSource buildFirstParametersFrom() {
    return this.parametersFrom.get(0).build();
  }
  
  public ParametersFromSource buildLastParametersFrom() {
    return this.parametersFrom.get(parametersFrom.size() - 1).build();
  }
  
  public ParametersFromSource buildMatchingParametersFrom(Predicate<ParametersFromSourceBuilder> predicate) {
      for (ParametersFromSourceBuilder item : parametersFrom) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingParametersFrom(Predicate<ParametersFromSourceBuilder> predicate) {
      for (ParametersFromSourceBuilder item : parametersFrom) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withParametersFrom(List<ParametersFromSource> parametersFrom) {
    if (this.parametersFrom != null) {
      this._visitables.get("parametersFrom").clear();
    }
    if (parametersFrom != null) {
        this.parametersFrom = new ArrayList();
        for (ParametersFromSource item : parametersFrom) {
          this.addToParametersFrom(item);
        }
    } else {
      this.parametersFrom = null;
    }
    return (A) this;
  }
  
  public A withParametersFrom(io.fabric8.servicecatalog.api.model.ParametersFromSource... parametersFrom) {
    if (this.parametersFrom != null) {
        this.parametersFrom.clear();
        _visitables.remove("parametersFrom");
    }
    if (parametersFrom != null) {
      for (ParametersFromSource item : parametersFrom) {
        this.addToParametersFrom(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasParametersFrom() {
    return this.parametersFrom != null && !this.parametersFrom.isEmpty();
  }
  
  public ParametersFromNested<A> addNewParametersFrom() {
    return new ParametersFromNested(-1, null);
  }
  
  public ParametersFromNested<A> addNewParametersFromLike(ParametersFromSource item) {
    return new ParametersFromNested(-1, item);
  }
  
  public ParametersFromNested<A> setNewParametersFromLike(int index,ParametersFromSource item) {
    return new ParametersFromNested(index, item);
  }
  
  public ParametersFromNested<A> editParametersFrom(int index) {
    if (parametersFrom.size() <= index) throw new RuntimeException("Can't edit parametersFrom. Index exceeds size.");
    return setNewParametersFromLike(index, buildParametersFrom(index));
  }
  
  public ParametersFromNested<A> editFirstParametersFrom() {
    if (parametersFrom.size() == 0) throw new RuntimeException("Can't edit first parametersFrom. The list is empty.");
    return setNewParametersFromLike(0, buildParametersFrom(0));
  }
  
  public ParametersFromNested<A> editLastParametersFrom() {
    int index = parametersFrom.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last parametersFrom. The list is empty.");
    return setNewParametersFromLike(index, buildParametersFrom(index));
  }
  
  public ParametersFromNested<A> editMatchingParametersFrom(Predicate<ParametersFromSourceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<parametersFrom.size();i++) { 
    if (predicate.test(parametersFrom.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching parametersFrom. No match found.");
    return setNewParametersFromLike(index, buildParametersFrom(index));
  }
  
  public String getSecretName() {
    return this.secretName;
  }
  
  public A withSecretName(String secretName) {
    this.secretName = secretName;
    return (A) this;
  }
  
  public boolean hasSecretName() {
    return this.secretName != null;
  }
  
  public A addToSecretTransforms(int index,SecretTransform item) {
    if (this.secretTransforms == null) {this.secretTransforms = new ArrayList<SecretTransformBuilder>();}
    SecretTransformBuilder builder = new SecretTransformBuilder(item);
    if (index < 0 || index >= secretTransforms.size()) { _visitables.get("secretTransforms").add(builder); secretTransforms.add(builder); } else { _visitables.get("secretTransforms").add(index, builder); secretTransforms.add(index, builder);}
    return (A)this;
  }
  
  public A setToSecretTransforms(int index,SecretTransform item) {
    if (this.secretTransforms == null) {this.secretTransforms = new ArrayList<SecretTransformBuilder>();}
    SecretTransformBuilder builder = new SecretTransformBuilder(item);
    if (index < 0 || index >= secretTransforms.size()) { _visitables.get("secretTransforms").add(builder); secretTransforms.add(builder); } else { _visitables.get("secretTransforms").set(index, builder); secretTransforms.set(index, builder);}
    return (A)this;
  }
  
  public A addToSecretTransforms(io.fabric8.servicecatalog.api.model.SecretTransform... items) {
    if (this.secretTransforms == null) {this.secretTransforms = new ArrayList<SecretTransformBuilder>();}
    for (SecretTransform item : items) {SecretTransformBuilder builder = new SecretTransformBuilder(item);_visitables.get("secretTransforms").add(builder);this.secretTransforms.add(builder);} return (A)this;
  }
  
  public A addAllToSecretTransforms(Collection<SecretTransform> items) {
    if (this.secretTransforms == null) {this.secretTransforms = new ArrayList<SecretTransformBuilder>();}
    for (SecretTransform item : items) {SecretTransformBuilder builder = new SecretTransformBuilder(item);_visitables.get("secretTransforms").add(builder);this.secretTransforms.add(builder);} return (A)this;
  }
  
  public A removeFromSecretTransforms(io.fabric8.servicecatalog.api.model.SecretTransform... items) {
    if (this.secretTransforms == null) return (A)this;
    for (SecretTransform item : items) {SecretTransformBuilder builder = new SecretTransformBuilder(item);_visitables.get("secretTransforms").remove(builder); this.secretTransforms.remove(builder);} return (A)this;
  }
  
  public A removeAllFromSecretTransforms(Collection<SecretTransform> items) {
    if (this.secretTransforms == null) return (A)this;
    for (SecretTransform item : items) {SecretTransformBuilder builder = new SecretTransformBuilder(item);_visitables.get("secretTransforms").remove(builder); this.secretTransforms.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromSecretTransforms(Predicate<SecretTransformBuilder> predicate) {
    if (secretTransforms == null) return (A) this;
    final Iterator<SecretTransformBuilder> each = secretTransforms.iterator();
    final List visitables = _visitables.get("secretTransforms");
    while (each.hasNext()) {
      SecretTransformBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<SecretTransform> buildSecretTransforms() {
    return this.secretTransforms != null ? build(secretTransforms) : null;
  }
  
  public SecretTransform buildSecretTransform(int index) {
    return this.secretTransforms.get(index).build();
  }
  
  public SecretTransform buildFirstSecretTransform() {
    return this.secretTransforms.get(0).build();
  }
  
  public SecretTransform buildLastSecretTransform() {
    return this.secretTransforms.get(secretTransforms.size() - 1).build();
  }
  
  public SecretTransform buildMatchingSecretTransform(Predicate<SecretTransformBuilder> predicate) {
      for (SecretTransformBuilder item : secretTransforms) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingSecretTransform(Predicate<SecretTransformBuilder> predicate) {
      for (SecretTransformBuilder item : secretTransforms) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withSecretTransforms(List<SecretTransform> secretTransforms) {
    if (this.secretTransforms != null) {
      this._visitables.get("secretTransforms").clear();
    }
    if (secretTransforms != null) {
        this.secretTransforms = new ArrayList();
        for (SecretTransform item : secretTransforms) {
          this.addToSecretTransforms(item);
        }
    } else {
      this.secretTransforms = null;
    }
    return (A) this;
  }
  
  public A withSecretTransforms(io.fabric8.servicecatalog.api.model.SecretTransform... secretTransforms) {
    if (this.secretTransforms != null) {
        this.secretTransforms.clear();
        _visitables.remove("secretTransforms");
    }
    if (secretTransforms != null) {
      for (SecretTransform item : secretTransforms) {
        this.addToSecretTransforms(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasSecretTransforms() {
    return this.secretTransforms != null && !this.secretTransforms.isEmpty();
  }
  
  public SecretTransformsNested<A> addNewSecretTransform() {
    return new SecretTransformsNested(-1, null);
  }
  
  public SecretTransformsNested<A> addNewSecretTransformLike(SecretTransform item) {
    return new SecretTransformsNested(-1, item);
  }
  
  public SecretTransformsNested<A> setNewSecretTransformLike(int index,SecretTransform item) {
    return new SecretTransformsNested(index, item);
  }
  
  public SecretTransformsNested<A> editSecretTransform(int index) {
    if (secretTransforms.size() <= index) throw new RuntimeException("Can't edit secretTransforms. Index exceeds size.");
    return setNewSecretTransformLike(index, buildSecretTransform(index));
  }
  
  public SecretTransformsNested<A> editFirstSecretTransform() {
    if (secretTransforms.size() == 0) throw new RuntimeException("Can't edit first secretTransforms. The list is empty.");
    return setNewSecretTransformLike(0, buildSecretTransform(0));
  }
  
  public SecretTransformsNested<A> editLastSecretTransform() {
    int index = secretTransforms.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last secretTransforms. The list is empty.");
    return setNewSecretTransformLike(index, buildSecretTransform(index));
  }
  
  public SecretTransformsNested<A> editMatchingSecretTransform(Predicate<SecretTransformBuilder> predicate) {
    int index = -1;
    for (int i=0;i<secretTransforms.size();i++) { 
    if (predicate.test(secretTransforms.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching secretTransforms. No match found.");
    return setNewSecretTransformLike(index, buildSecretTransform(index));
  }
  
  public UserInfo buildUserInfo() {
    return this.userInfo != null ? this.userInfo.build() : null;
  }
  
  public A withUserInfo(UserInfo userInfo) {
    this._visitables.remove("userInfo");
    if (userInfo != null) {
        this.userInfo = new UserInfoBuilder(userInfo);
        this._visitables.get("userInfo").add(this.userInfo);
    } else {
        this.userInfo = null;
        this._visitables.get("userInfo").remove(this.userInfo);
    }
    return (A) this;
  }
  
  public boolean hasUserInfo() {
    return this.userInfo != null;
  }
  
  public UserInfoNested<A> withNewUserInfo() {
    return new UserInfoNested(null);
  }
  
  public UserInfoNested<A> withNewUserInfoLike(UserInfo item) {
    return new UserInfoNested(item);
  }
  
  public UserInfoNested<A> editUserInfo() {
    return withNewUserInfoLike(java.util.Optional.ofNullable(buildUserInfo()).orElse(null));
  }
  
  public UserInfoNested<A> editOrNewUserInfo() {
    return withNewUserInfoLike(java.util.Optional.ofNullable(buildUserInfo()).orElse(new UserInfoBuilder().build()));
  }
  
  public UserInfoNested<A> editOrNewUserInfoLike(UserInfo item) {
    return withNewUserInfoLike(java.util.Optional.ofNullable(buildUserInfo()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ServiceBindingSpecFluent that = (ServiceBindingSpecFluent) o;
    if (!java.util.Objects.equals(externalID, that.externalID)) return false;
    if (!java.util.Objects.equals(instanceRef, that.instanceRef)) return false;
    if (!java.util.Objects.equals(parameters, that.parameters)) return false;
    if (!java.util.Objects.equals(parametersFrom, that.parametersFrom)) return false;
    if (!java.util.Objects.equals(secretName, that.secretName)) return false;
    if (!java.util.Objects.equals(secretTransforms, that.secretTransforms)) return false;
    if (!java.util.Objects.equals(userInfo, that.userInfo)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(externalID,  instanceRef,  parameters,  parametersFrom,  secretName,  secretTransforms,  userInfo,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (externalID != null) { sb.append("externalID:"); sb.append(externalID + ","); }
    if (instanceRef != null) { sb.append("instanceRef:"); sb.append(instanceRef + ","); }
    if (parameters != null && !parameters.isEmpty()) { sb.append("parameters:"); sb.append(parameters + ","); }
    if (parametersFrom != null && !parametersFrom.isEmpty()) { sb.append("parametersFrom:"); sb.append(parametersFrom + ","); }
    if (secretName != null) { sb.append("secretName:"); sb.append(secretName + ","); }
    if (secretTransforms != null && !secretTransforms.isEmpty()) { sb.append("secretTransforms:"); sb.append(secretTransforms + ","); }
    if (userInfo != null) { sb.append("userInfo:"); sb.append(userInfo + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class InstanceRefNested<N> extends LocalObjectReferenceFluent<InstanceRefNested<N>> implements Nested<N>{
    InstanceRefNested(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    LocalObjectReferenceBuilder builder;
    
    public N and() {
      return (N) ServiceBindingSpecFluent.this.withInstanceRef(builder.build());
    }
    
    public N endInstanceRef() {
      return and();
    }
    
  
  }
  public class ParametersFromNested<N> extends ParametersFromSourceFluent<ParametersFromNested<N>> implements Nested<N>{
    ParametersFromNested(int index,ParametersFromSource item) {
      this.index = index;
      this.builder = new ParametersFromSourceBuilder(this, item);
    }
    ParametersFromSourceBuilder builder;
    int index;
    
    public N and() {
      return (N) ServiceBindingSpecFluent.this.setToParametersFrom(index,builder.build());
    }
    
    public N endParametersFrom() {
      return and();
    }
    
  
  }
  public class SecretTransformsNested<N> extends SecretTransformFluent<SecretTransformsNested<N>> implements Nested<N>{
    SecretTransformsNested(int index,SecretTransform item) {
      this.index = index;
      this.builder = new SecretTransformBuilder(this, item);
    }
    SecretTransformBuilder builder;
    int index;
    
    public N and() {
      return (N) ServiceBindingSpecFluent.this.setToSecretTransforms(index,builder.build());
    }
    
    public N endSecretTransform() {
      return and();
    }
    
  
  }
  public class UserInfoNested<N> extends UserInfoFluent<UserInfoNested<N>> implements Nested<N>{
    UserInfoNested(UserInfo item) {
      this.builder = new UserInfoBuilder(this, item);
    }
    UserInfoBuilder builder;
    
    public N and() {
      return (N) ServiceBindingSpecFluent.this.withUserInfo(builder.build());
    }
    
    public N endUserInfo() {
      return and();
    }
    
  
  }

}