package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class SecretKeyReferenceBuilder extends SecretKeyReferenceFluent<SecretKeyReferenceBuilder> implements VisitableBuilder<SecretKeyReference,SecretKeyReferenceBuilder>{
  public SecretKeyReferenceBuilder() {
    this(new SecretKeyReference());
  }
  
  public SecretKeyReferenceBuilder(SecretKeyReferenceFluent<?> fluent) {
    this(fluent, new SecretKeyReference());
  }
  
  public SecretKeyReferenceBuilder(SecretKeyReferenceFluent<?> fluent,SecretKeyReference instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public SecretKeyReferenceBuilder(SecretKeyReference instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  SecretKeyReferenceFluent<?> fluent;
  
  public SecretKeyReference build() {
    SecretKeyReference buildable = new SecretKeyReference(fluent.getKey(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}