/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.servicecatalog.api.model.CatalogRestrictions;
import io.fabric8.servicecatalog.api.model.CatalogRestrictionsFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class CatalogRestrictionsFluentImpl<A extends CatalogRestrictionsFluent<A>>
extends BaseFluent<A>
implements CatalogRestrictionsFluent<A> {
    private List<String> serviceClass;
    private List<String> servicePlan;

    public CatalogRestrictionsFluentImpl() {
    }

    public CatalogRestrictionsFluentImpl(CatalogRestrictions instance) {
        this.withServiceClass(instance.getServiceClass());
        this.withServicePlan(instance.getServicePlan());
    }

    @Override
    public A addToServiceClass(Integer index, String item) {
        if (this.serviceClass == null) {
            this.serviceClass = new ArrayList<String>();
        }
        this.serviceClass.add(index, item);
        return (A)this;
    }

    @Override
    public A setToServiceClass(Integer index, String item) {
        if (this.serviceClass == null) {
            this.serviceClass = new ArrayList<String>();
        }
        this.serviceClass.set(index, item);
        return (A)this;
    }

    @Override
    public A addToServiceClass(String ... items) {
        if (this.serviceClass == null) {
            this.serviceClass = new ArrayList<String>();
        }
        for (String item : items) {
            this.serviceClass.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToServiceClass(Collection<String> items) {
        if (this.serviceClass == null) {
            this.serviceClass = new ArrayList<String>();
        }
        for (String item : items) {
            this.serviceClass.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromServiceClass(String ... items) {
        for (String item : items) {
            if (this.serviceClass == null) continue;
            this.serviceClass.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromServiceClass(Collection<String> items) {
        for (String item : items) {
            if (this.serviceClass == null) continue;
            this.serviceClass.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getServiceClass() {
        return this.serviceClass;
    }

    @Override
    public String getServiceClass(Integer index) {
        return this.serviceClass.get(index);
    }

    @Override
    public String getFirstServiceClass() {
        return this.serviceClass.get(0);
    }

    @Override
    public String getLastServiceClass() {
        return this.serviceClass.get(this.serviceClass.size() - 1);
    }

    @Override
    public String getMatchingServiceClass(Predicate<String> predicate) {
        for (String item : this.serviceClass) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingServiceClass(Predicate<String> predicate) {
        for (String item : this.serviceClass) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withServiceClass(List<String> serviceClass) {
        if (serviceClass != null) {
            this.serviceClass = new ArrayList<String>();
            for (String item : serviceClass) {
                this.addToServiceClass(item);
            }
        } else {
            this.serviceClass = null;
        }
        return (A)this;
    }

    @Override
    public A withServiceClass(String ... serviceClass) {
        if (this.serviceClass != null) {
            this.serviceClass.clear();
        }
        if (serviceClass != null) {
            for (String item : serviceClass) {
                this.addToServiceClass(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasServiceClass() {
        return this.serviceClass != null && !this.serviceClass.isEmpty();
    }

    @Override
    public A addNewServiceClass(String arg0) {
        return this.addToServiceClass(new String(arg0));
    }

    @Override
    public A addToServicePlan(Integer index, String item) {
        if (this.servicePlan == null) {
            this.servicePlan = new ArrayList<String>();
        }
        this.servicePlan.add(index, item);
        return (A)this;
    }

    @Override
    public A setToServicePlan(Integer index, String item) {
        if (this.servicePlan == null) {
            this.servicePlan = new ArrayList<String>();
        }
        this.servicePlan.set(index, item);
        return (A)this;
    }

    @Override
    public A addToServicePlan(String ... items) {
        if (this.servicePlan == null) {
            this.servicePlan = new ArrayList<String>();
        }
        for (String item : items) {
            this.servicePlan.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToServicePlan(Collection<String> items) {
        if (this.servicePlan == null) {
            this.servicePlan = new ArrayList<String>();
        }
        for (String item : items) {
            this.servicePlan.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromServicePlan(String ... items) {
        for (String item : items) {
            if (this.servicePlan == null) continue;
            this.servicePlan.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromServicePlan(Collection<String> items) {
        for (String item : items) {
            if (this.servicePlan == null) continue;
            this.servicePlan.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getServicePlan() {
        return this.servicePlan;
    }

    @Override
    public String getServicePlan(Integer index) {
        return this.servicePlan.get(index);
    }

    @Override
    public String getFirstServicePlan() {
        return this.servicePlan.get(0);
    }

    @Override
    public String getLastServicePlan() {
        return this.servicePlan.get(this.servicePlan.size() - 1);
    }

    @Override
    public String getMatchingServicePlan(Predicate<String> predicate) {
        for (String item : this.servicePlan) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingServicePlan(Predicate<String> predicate) {
        for (String item : this.servicePlan) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withServicePlan(List<String> servicePlan) {
        if (servicePlan != null) {
            this.servicePlan = new ArrayList<String>();
            for (String item : servicePlan) {
                this.addToServicePlan(item);
            }
        } else {
            this.servicePlan = null;
        }
        return (A)this;
    }

    @Override
    public A withServicePlan(String ... servicePlan) {
        if (this.servicePlan != null) {
            this.servicePlan.clear();
        }
        if (servicePlan != null) {
            for (String item : servicePlan) {
                this.addToServicePlan(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasServicePlan() {
        return this.servicePlan != null && !this.servicePlan.isEmpty();
    }

    @Override
    public A addNewServicePlan(String arg0) {
        return this.addToServicePlan(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CatalogRestrictionsFluentImpl that = (CatalogRestrictionsFluentImpl)o;
        if (this.serviceClass != null ? !this.serviceClass.equals(that.serviceClass) : that.serviceClass != null) {
            return false;
        }
        return !(this.servicePlan != null ? !this.servicePlan.equals(that.servicePlan) : that.servicePlan != null);
    }

    public int hashCode() {
        return Objects.hash(this.serviceClass, this.servicePlan, super.hashCode());
    }
}

