package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public class ServiceInstanceSpecFluentImpl<A extends io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluent<A>{
  public ServiceInstanceSpecFluentImpl() {
  }
  public ServiceInstanceSpecFluentImpl(io.fabric8.servicecatalog.api.model.ServiceInstanceSpec instance) {
    this.withClusterServiceClassExternalID(instance.getClusterServiceClassExternalID()); 
    this.withClusterServiceClassExternalName(instance.getClusterServiceClassExternalName()); 
    this.withClusterServiceClassName(instance.getClusterServiceClassName()); 
    this.withClusterServiceClassRef(instance.getClusterServiceClassRef()); 
    this.withClusterServicePlanExternalID(instance.getClusterServicePlanExternalID()); 
    this.withClusterServicePlanExternalName(instance.getClusterServicePlanExternalName()); 
    this.withClusterServicePlanName(instance.getClusterServicePlanName()); 
    this.withClusterServicePlanRef(instance.getClusterServicePlanRef()); 
    this.withExternalID(instance.getExternalID()); 
    this.withParameters(instance.getParameters()); 
    this.withParametersFrom(instance.getParametersFrom()); 
    this.withServiceClassExternalID(instance.getServiceClassExternalID()); 
    this.withServiceClassExternalName(instance.getServiceClassExternalName()); 
    this.withServiceClassName(instance.getServiceClassName()); 
    this.withServiceClassRef(instance.getServiceClassRef()); 
    this.withServicePlanExternalID(instance.getServicePlanExternalID()); 
    this.withServicePlanExternalName(instance.getServicePlanExternalName()); 
    this.withServicePlanName(instance.getServicePlanName()); 
    this.withServicePlanRef(instance.getServicePlanRef()); 
    this.withUpdateRequests(instance.getUpdateRequests()); 
    this.withUserInfo(instance.getUserInfo()); 
  }
  private java.lang.String clusterServiceClassExternalID;
  private java.lang.String clusterServiceClassExternalName;
  private java.lang.String clusterServiceClassName;
  private io.fabric8.servicecatalog.api.model.ClusterObjectReferenceBuilder clusterServiceClassRef;
  private java.lang.String clusterServicePlanExternalID;
  private java.lang.String clusterServicePlanExternalName;
  private java.lang.String clusterServicePlanName;
  private io.fabric8.servicecatalog.api.model.ClusterObjectReferenceBuilder clusterServicePlanRef;
  private java.lang.String externalID;
  private java.util.Map<java.lang.String,java.lang.Object> parameters;
  private java.util.List<io.fabric8.servicecatalog.api.model.ParametersFromSourceBuilder> parametersFrom;
  private java.lang.String serviceClassExternalID;
  private java.lang.String serviceClassExternalName;
  private java.lang.String serviceClassName;
  private io.fabric8.servicecatalog.api.model.LocalObjectReferenceBuilder serviceClassRef;
  private java.lang.String servicePlanExternalID;
  private java.lang.String servicePlanExternalName;
  private java.lang.String servicePlanName;
  private io.fabric8.servicecatalog.api.model.LocalObjectReferenceBuilder servicePlanRef;
  private java.lang.Long updateRequests;
  private io.fabric8.servicecatalog.api.model.UserInfoBuilder userInfo;
  public java.lang.String getClusterServiceClassExternalID() {
    return this.clusterServiceClassExternalID;
  }
  public A withClusterServiceClassExternalID(java.lang.String clusterServiceClassExternalID) {
    this.clusterServiceClassExternalID=clusterServiceClassExternalID; return (A) this;
  }
  public java.lang.Boolean hasClusterServiceClassExternalID() {
    return this.clusterServiceClassExternalID != null;
  }
  
  /**
   * Method is deprecated. use withClusterServiceClassExternalID instead.
   */
  @java.lang.Deprecated
  public A withNewClusterServiceClassExternalID(java.lang.String arg0) {
    return (A)withClusterServiceClassExternalID(new String(arg0));
  }
  public java.lang.String getClusterServiceClassExternalName() {
    return this.clusterServiceClassExternalName;
  }
  public A withClusterServiceClassExternalName(java.lang.String clusterServiceClassExternalName) {
    this.clusterServiceClassExternalName=clusterServiceClassExternalName; return (A) this;
  }
  public java.lang.Boolean hasClusterServiceClassExternalName() {
    return this.clusterServiceClassExternalName != null;
  }
  
  /**
   * Method is deprecated. use withClusterServiceClassExternalName instead.
   */
  @java.lang.Deprecated
  public A withNewClusterServiceClassExternalName(java.lang.String arg0) {
    return (A)withClusterServiceClassExternalName(new String(arg0));
  }
  public java.lang.String getClusterServiceClassName() {
    return this.clusterServiceClassName;
  }
  public A withClusterServiceClassName(java.lang.String clusterServiceClassName) {
    this.clusterServiceClassName=clusterServiceClassName; return (A) this;
  }
  public java.lang.Boolean hasClusterServiceClassName() {
    return this.clusterServiceClassName != null;
  }
  
  /**
   * Method is deprecated. use withClusterServiceClassName instead.
   */
  @java.lang.Deprecated
  public A withNewClusterServiceClassName(java.lang.String arg0) {
    return (A)withClusterServiceClassName(new String(arg0));
  }
  
  /**
   * This method has been deprecated, please use method buildClusterServiceClassRef instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.servicecatalog.api.model.ClusterObjectReference getClusterServiceClassRef() {
    return this.clusterServiceClassRef!=null?this.clusterServiceClassRef.build():null;
  }
  public io.fabric8.servicecatalog.api.model.ClusterObjectReference buildClusterServiceClassRef() {
    return this.clusterServiceClassRef!=null?this.clusterServiceClassRef.build():null;
  }
  public A withClusterServiceClassRef(io.fabric8.servicecatalog.api.model.ClusterObjectReference clusterServiceClassRef) {
    _visitables.get("clusterServiceClassRef").remove(this.clusterServiceClassRef);
    if (clusterServiceClassRef!=null){ this.clusterServiceClassRef= new io.fabric8.servicecatalog.api.model.ClusterObjectReferenceBuilder(clusterServiceClassRef); _visitables.get("clusterServiceClassRef").add(this.clusterServiceClassRef);} return (A) this;
  }
  public java.lang.Boolean hasClusterServiceClassRef() {
    return this.clusterServiceClassRef != null;
  }
  public A withNewClusterServiceClassRef(java.lang.String name) {
    return (A)withClusterServiceClassRef(new ClusterObjectReference(name));
  }
  public io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluent.ClusterServiceClassRefNested<A> withNewClusterServiceClassRef() {
    return new io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluentImpl.ClusterServiceClassRefNestedImpl();
  }
  public io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluent.ClusterServiceClassRefNested<A> withNewClusterServiceClassRefLike(io.fabric8.servicecatalog.api.model.ClusterObjectReference item) {
    return new io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluentImpl.ClusterServiceClassRefNestedImpl(item);
  }
  public io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluent.ClusterServiceClassRefNested<A> editClusterServiceClassRef() {
    return withNewClusterServiceClassRefLike(getClusterServiceClassRef());
  }
  public io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluent.ClusterServiceClassRefNested<A> editOrNewClusterServiceClassRef() {
    return withNewClusterServiceClassRefLike(getClusterServiceClassRef() != null ? getClusterServiceClassRef(): new io.fabric8.servicecatalog.api.model.ClusterObjectReferenceBuilder().build());
  }
  public io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluent.ClusterServiceClassRefNested<A> editOrNewClusterServiceClassRefLike(io.fabric8.servicecatalog.api.model.ClusterObjectReference item) {
    return withNewClusterServiceClassRefLike(getClusterServiceClassRef() != null ? getClusterServiceClassRef(): item);
  }
  public java.lang.String getClusterServicePlanExternalID() {
    return this.clusterServicePlanExternalID;
  }
  public A withClusterServicePlanExternalID(java.lang.String clusterServicePlanExternalID) {
    this.clusterServicePlanExternalID=clusterServicePlanExternalID; return (A) this;
  }
  public java.lang.Boolean hasClusterServicePlanExternalID() {
    return this.clusterServicePlanExternalID != null;
  }
  
  /**
   * Method is deprecated. use withClusterServicePlanExternalID instead.
   */
  @java.lang.Deprecated
  public A withNewClusterServicePlanExternalID(java.lang.String arg0) {
    return (A)withClusterServicePlanExternalID(new String(arg0));
  }
  public java.lang.String getClusterServicePlanExternalName() {
    return this.clusterServicePlanExternalName;
  }
  public A withClusterServicePlanExternalName(java.lang.String clusterServicePlanExternalName) {
    this.clusterServicePlanExternalName=clusterServicePlanExternalName; return (A) this;
  }
  public java.lang.Boolean hasClusterServicePlanExternalName() {
    return this.clusterServicePlanExternalName != null;
  }
  
  /**
   * Method is deprecated. use withClusterServicePlanExternalName instead.
   */
  @java.lang.Deprecated
  public A withNewClusterServicePlanExternalName(java.lang.String arg0) {
    return (A)withClusterServicePlanExternalName(new String(arg0));
  }
  public java.lang.String getClusterServicePlanName() {
    return this.clusterServicePlanName;
  }
  public A withClusterServicePlanName(java.lang.String clusterServicePlanName) {
    this.clusterServicePlanName=clusterServicePlanName; return (A) this;
  }
  public java.lang.Boolean hasClusterServicePlanName() {
    return this.clusterServicePlanName != null;
  }
  
  /**
   * Method is deprecated. use withClusterServicePlanName instead.
   */
  @java.lang.Deprecated
  public A withNewClusterServicePlanName(java.lang.String arg0) {
    return (A)withClusterServicePlanName(new String(arg0));
  }
  
  /**
   * This method has been deprecated, please use method buildClusterServicePlanRef instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.servicecatalog.api.model.ClusterObjectReference getClusterServicePlanRef() {
    return this.clusterServicePlanRef!=null?this.clusterServicePlanRef.build():null;
  }
  public io.fabric8.servicecatalog.api.model.ClusterObjectReference buildClusterServicePlanRef() {
    return this.clusterServicePlanRef!=null?this.clusterServicePlanRef.build():null;
  }
  public A withClusterServicePlanRef(io.fabric8.servicecatalog.api.model.ClusterObjectReference clusterServicePlanRef) {
    _visitables.get("clusterServicePlanRef").remove(this.clusterServicePlanRef);
    if (clusterServicePlanRef!=null){ this.clusterServicePlanRef= new io.fabric8.servicecatalog.api.model.ClusterObjectReferenceBuilder(clusterServicePlanRef); _visitables.get("clusterServicePlanRef").add(this.clusterServicePlanRef);} return (A) this;
  }
  public java.lang.Boolean hasClusterServicePlanRef() {
    return this.clusterServicePlanRef != null;
  }
  public A withNewClusterServicePlanRef(java.lang.String name) {
    return (A)withClusterServicePlanRef(new ClusterObjectReference(name));
  }
  public io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluent.ClusterServicePlanRefNested<A> withNewClusterServicePlanRef() {
    return new io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluentImpl.ClusterServicePlanRefNestedImpl();
  }
  public io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluent.ClusterServicePlanRefNested<A> withNewClusterServicePlanRefLike(io.fabric8.servicecatalog.api.model.ClusterObjectReference item) {
    return new io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluentImpl.ClusterServicePlanRefNestedImpl(item);
  }
  public io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluent.ClusterServicePlanRefNested<A> editClusterServicePlanRef() {
    return withNewClusterServicePlanRefLike(getClusterServicePlanRef());
  }
  public io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluent.ClusterServicePlanRefNested<A> editOrNewClusterServicePlanRef() {
    return withNewClusterServicePlanRefLike(getClusterServicePlanRef() != null ? getClusterServicePlanRef(): new io.fabric8.servicecatalog.api.model.ClusterObjectReferenceBuilder().build());
  }
  public io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluent.ClusterServicePlanRefNested<A> editOrNewClusterServicePlanRefLike(io.fabric8.servicecatalog.api.model.ClusterObjectReference item) {
    return withNewClusterServicePlanRefLike(getClusterServicePlanRef() != null ? getClusterServicePlanRef(): item);
  }
  public java.lang.String getExternalID() {
    return this.externalID;
  }
  public A withExternalID(java.lang.String externalID) {
    this.externalID=externalID; return (A) this;
  }
  public java.lang.Boolean hasExternalID() {
    return this.externalID != null;
  }
  
  /**
   * Method is deprecated. use withExternalID instead.
   */
  @java.lang.Deprecated
  public A withNewExternalID(java.lang.String arg0) {
    return (A)withExternalID(new String(arg0));
  }
  public A addToParameters(java.lang.String key,java.lang.Object value) {
    if(this.parameters == null && key != null && value != null) { this.parameters = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(); }
    if(key != null && value != null) {this.parameters.put(key, value);} return (A)this;
  }
  public A addToParameters(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.parameters == null && map != null) { this.parameters = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(); }
    if(map != null) { this.parameters.putAll(map);} return (A)this;
  }
  public A removeFromParameters(java.lang.String key) {
    if(this.parameters == null) { return (A) this; }
    if(key != null && this.parameters != null) {this.parameters.remove(key);} return (A)this;
  }
  public A removeFromParameters(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.parameters == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.parameters != null){this.parameters.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getParameters() {
    return this.parameters;
  }
  public <K,V>A withParameters(java.util.Map<java.lang.String,java.lang.Object> parameters) {
    if (parameters == null) { this.parameters =  null;} else {this.parameters = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(parameters);} return (A) this;
  }
  public java.lang.Boolean hasParameters() {
    return this.parameters != null;
  }
  public A addToParametersFrom(java.lang.Integer index,io.fabric8.servicecatalog.api.model.ParametersFromSource item) {
    if (this.parametersFrom == null) {this.parametersFrom = new java.util.ArrayList<io.fabric8.servicecatalog.api.model.ParametersFromSourceBuilder>();}
    io.fabric8.servicecatalog.api.model.ParametersFromSourceBuilder builder = new io.fabric8.servicecatalog.api.model.ParametersFromSourceBuilder(item);_visitables.get("parametersFrom").add(index >= 0 ? index : _visitables.get("parametersFrom").size(), builder);this.parametersFrom.add(index >= 0 ? index : parametersFrom.size(), builder); return (A)this;
  }
  public A setToParametersFrom(java.lang.Integer index,io.fabric8.servicecatalog.api.model.ParametersFromSource item) {
    if (this.parametersFrom == null) {this.parametersFrom = new java.util.ArrayList<io.fabric8.servicecatalog.api.model.ParametersFromSourceBuilder>();}
    io.fabric8.servicecatalog.api.model.ParametersFromSourceBuilder builder = new io.fabric8.servicecatalog.api.model.ParametersFromSourceBuilder(item);
    if (index < 0 || index >= _visitables.get("parametersFrom").size()) { _visitables.get("parametersFrom").add(builder); } else { _visitables.get("parametersFrom").set(index, builder);}
    if (index < 0 || index >= parametersFrom.size()) { parametersFrom.add(builder); } else { parametersFrom.set(index, builder);}
     return (A)this;
  }
  public A addToParametersFrom(io.fabric8.servicecatalog.api.model.ParametersFromSource... items) {
    if (this.parametersFrom == null) {this.parametersFrom = new java.util.ArrayList<io.fabric8.servicecatalog.api.model.ParametersFromSourceBuilder>();}
    for (io.fabric8.servicecatalog.api.model.ParametersFromSource item : items) {io.fabric8.servicecatalog.api.model.ParametersFromSourceBuilder builder = new io.fabric8.servicecatalog.api.model.ParametersFromSourceBuilder(item);_visitables.get("parametersFrom").add(builder);this.parametersFrom.add(builder);} return (A)this;
  }
  public A addAllToParametersFrom(java.util.Collection<io.fabric8.servicecatalog.api.model.ParametersFromSource> items) {
    if (this.parametersFrom == null) {this.parametersFrom = new java.util.ArrayList<io.fabric8.servicecatalog.api.model.ParametersFromSourceBuilder>();}
    for (io.fabric8.servicecatalog.api.model.ParametersFromSource item : items) {io.fabric8.servicecatalog.api.model.ParametersFromSourceBuilder builder = new io.fabric8.servicecatalog.api.model.ParametersFromSourceBuilder(item);_visitables.get("parametersFrom").add(builder);this.parametersFrom.add(builder);} return (A)this;
  }
  public A removeFromParametersFrom(io.fabric8.servicecatalog.api.model.ParametersFromSource... items) {
    for (io.fabric8.servicecatalog.api.model.ParametersFromSource item : items) {io.fabric8.servicecatalog.api.model.ParametersFromSourceBuilder builder = new io.fabric8.servicecatalog.api.model.ParametersFromSourceBuilder(item);_visitables.get("parametersFrom").remove(builder);if (this.parametersFrom != null) {this.parametersFrom.remove(builder);}} return (A)this;
  }
  public A removeAllFromParametersFrom(java.util.Collection<io.fabric8.servicecatalog.api.model.ParametersFromSource> items) {
    for (io.fabric8.servicecatalog.api.model.ParametersFromSource item : items) {io.fabric8.servicecatalog.api.model.ParametersFromSourceBuilder builder = new io.fabric8.servicecatalog.api.model.ParametersFromSourceBuilder(item);_visitables.get("parametersFrom").remove(builder);if (this.parametersFrom != null) {this.parametersFrom.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromParametersFrom(java.util.function.Predicate<io.fabric8.servicecatalog.api.model.ParametersFromSourceBuilder> predicate) {
    if (parametersFrom == null) return (A) this;
    final Iterator<io.fabric8.servicecatalog.api.model.ParametersFromSourceBuilder> each = parametersFrom.iterator();
    final List visitables = _visitables.get("parametersFrom");
    while (each.hasNext()) {
      io.fabric8.servicecatalog.api.model.ParametersFromSourceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildParametersFrom instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.servicecatalog.api.model.ParametersFromSource> getParametersFrom() {
    return build(parametersFrom);
  }
  public java.util.List<io.fabric8.servicecatalog.api.model.ParametersFromSource> buildParametersFrom() {
    return build(parametersFrom);
  }
  public io.fabric8.servicecatalog.api.model.ParametersFromSource buildParametersFrom(java.lang.Integer index) {
    return this.parametersFrom.get(index).build();
  }
  public io.fabric8.servicecatalog.api.model.ParametersFromSource buildFirstParametersFrom() {
    return this.parametersFrom.get(0).build();
  }
  public io.fabric8.servicecatalog.api.model.ParametersFromSource buildLastParametersFrom() {
    return this.parametersFrom.get(parametersFrom.size() - 1).build();
  }
  public io.fabric8.servicecatalog.api.model.ParametersFromSource buildMatchingParametersFrom(java.util.function.Predicate<io.fabric8.servicecatalog.api.model.ParametersFromSourceBuilder> predicate) {
    for (io.fabric8.servicecatalog.api.model.ParametersFromSourceBuilder item: parametersFrom) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingParametersFrom(java.util.function.Predicate<io.fabric8.servicecatalog.api.model.ParametersFromSourceBuilder> predicate) {
    for (io.fabric8.servicecatalog.api.model.ParametersFromSourceBuilder item: parametersFrom) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withParametersFrom(java.util.List<io.fabric8.servicecatalog.api.model.ParametersFromSource> parametersFrom) {
    if (this.parametersFrom != null) { _visitables.get("parametersFrom").removeAll(this.parametersFrom);}
    if (parametersFrom != null) {this.parametersFrom = new java.util.ArrayList<io.fabric8.servicecatalog.api.model.ParametersFromSourceBuilder>(); for (io.fabric8.servicecatalog.api.model.ParametersFromSource item : parametersFrom){this.addToParametersFrom(item);}} else { this.parametersFrom = null;} return (A) this;
  }
  public A withParametersFrom(io.fabric8.servicecatalog.api.model.ParametersFromSource... parametersFrom) {
    if (this.parametersFrom != null) {this.parametersFrom.clear();}
    if (parametersFrom != null) {for (io.fabric8.servicecatalog.api.model.ParametersFromSource item :parametersFrom){ this.addToParametersFrom(item);}} return (A) this;
  }
  public java.lang.Boolean hasParametersFrom() {
    return parametersFrom != null && !parametersFrom.isEmpty();
  }
  public io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluent.ParametersFromNested<A> addNewParametersFrom() {
    return new io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluentImpl.ParametersFromNestedImpl();
  }
  public io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluent.ParametersFromNested<A> addNewParametersFromLike(io.fabric8.servicecatalog.api.model.ParametersFromSource item) {
    return new io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluentImpl.ParametersFromNestedImpl(-1, item);
  }
  public io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluent.ParametersFromNested<A> setNewParametersFromLike(java.lang.Integer index,io.fabric8.servicecatalog.api.model.ParametersFromSource item) {
    return new io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluentImpl.ParametersFromNestedImpl(index, item);
  }
  public io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluent.ParametersFromNested<A> editParametersFrom(java.lang.Integer index) {
    if (parametersFrom.size() <= index) throw new RuntimeException("Can't edit parametersFrom. Index exceeds size.");
    return setNewParametersFromLike(index, buildParametersFrom(index));
  }
  public io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluent.ParametersFromNested<A> editFirstParametersFrom() {
    if (parametersFrom.size() == 0) throw new RuntimeException("Can't edit first parametersFrom. The list is empty.");
    return setNewParametersFromLike(0, buildParametersFrom(0));
  }
  public io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluent.ParametersFromNested<A> editLastParametersFrom() {
    int index = parametersFrom.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last parametersFrom. The list is empty.");
    return setNewParametersFromLike(index, buildParametersFrom(index));
  }
  public io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluent.ParametersFromNested<A> editMatchingParametersFrom(java.util.function.Predicate<io.fabric8.servicecatalog.api.model.ParametersFromSourceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<parametersFrom.size();i++) { 
    if (predicate.test(parametersFrom.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching parametersFrom. No match found.");
    return setNewParametersFromLike(index, buildParametersFrom(index));
  }
  public java.lang.String getServiceClassExternalID() {
    return this.serviceClassExternalID;
  }
  public A withServiceClassExternalID(java.lang.String serviceClassExternalID) {
    this.serviceClassExternalID=serviceClassExternalID; return (A) this;
  }
  public java.lang.Boolean hasServiceClassExternalID() {
    return this.serviceClassExternalID != null;
  }
  
  /**
   * Method is deprecated. use withServiceClassExternalID instead.
   */
  @java.lang.Deprecated
  public A withNewServiceClassExternalID(java.lang.String arg0) {
    return (A)withServiceClassExternalID(new String(arg0));
  }
  public java.lang.String getServiceClassExternalName() {
    return this.serviceClassExternalName;
  }
  public A withServiceClassExternalName(java.lang.String serviceClassExternalName) {
    this.serviceClassExternalName=serviceClassExternalName; return (A) this;
  }
  public java.lang.Boolean hasServiceClassExternalName() {
    return this.serviceClassExternalName != null;
  }
  
  /**
   * Method is deprecated. use withServiceClassExternalName instead.
   */
  @java.lang.Deprecated
  public A withNewServiceClassExternalName(java.lang.String arg0) {
    return (A)withServiceClassExternalName(new String(arg0));
  }
  public java.lang.String getServiceClassName() {
    return this.serviceClassName;
  }
  public A withServiceClassName(java.lang.String serviceClassName) {
    this.serviceClassName=serviceClassName; return (A) this;
  }
  public java.lang.Boolean hasServiceClassName() {
    return this.serviceClassName != null;
  }
  
  /**
   * Method is deprecated. use withServiceClassName instead.
   */
  @java.lang.Deprecated
  public A withNewServiceClassName(java.lang.String arg0) {
    return (A)withServiceClassName(new String(arg0));
  }
  
  /**
   * This method has been deprecated, please use method buildServiceClassRef instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.servicecatalog.api.model.LocalObjectReference getServiceClassRef() {
    return this.serviceClassRef!=null?this.serviceClassRef.build():null;
  }
  public io.fabric8.servicecatalog.api.model.LocalObjectReference buildServiceClassRef() {
    return this.serviceClassRef!=null?this.serviceClassRef.build():null;
  }
  public A withServiceClassRef(io.fabric8.servicecatalog.api.model.LocalObjectReference serviceClassRef) {
    _visitables.get("serviceClassRef").remove(this.serviceClassRef);
    if (serviceClassRef!=null){ this.serviceClassRef= new io.fabric8.servicecatalog.api.model.LocalObjectReferenceBuilder(serviceClassRef); _visitables.get("serviceClassRef").add(this.serviceClassRef);} return (A) this;
  }
  public java.lang.Boolean hasServiceClassRef() {
    return this.serviceClassRef != null;
  }
  public A withNewServiceClassRef(java.lang.String name) {
    return (A)withServiceClassRef(new LocalObjectReference(name));
  }
  public io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluent.ServiceClassRefNested<A> withNewServiceClassRef() {
    return new io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluentImpl.ServiceClassRefNestedImpl();
  }
  public io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluent.ServiceClassRefNested<A> withNewServiceClassRefLike(io.fabric8.servicecatalog.api.model.LocalObjectReference item) {
    return new io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluentImpl.ServiceClassRefNestedImpl(item);
  }
  public io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluent.ServiceClassRefNested<A> editServiceClassRef() {
    return withNewServiceClassRefLike(getServiceClassRef());
  }
  public io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluent.ServiceClassRefNested<A> editOrNewServiceClassRef() {
    return withNewServiceClassRefLike(getServiceClassRef() != null ? getServiceClassRef(): new io.fabric8.servicecatalog.api.model.LocalObjectReferenceBuilder().build());
  }
  public io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluent.ServiceClassRefNested<A> editOrNewServiceClassRefLike(io.fabric8.servicecatalog.api.model.LocalObjectReference item) {
    return withNewServiceClassRefLike(getServiceClassRef() != null ? getServiceClassRef(): item);
  }
  public java.lang.String getServicePlanExternalID() {
    return this.servicePlanExternalID;
  }
  public A withServicePlanExternalID(java.lang.String servicePlanExternalID) {
    this.servicePlanExternalID=servicePlanExternalID; return (A) this;
  }
  public java.lang.Boolean hasServicePlanExternalID() {
    return this.servicePlanExternalID != null;
  }
  
  /**
   * Method is deprecated. use withServicePlanExternalID instead.
   */
  @java.lang.Deprecated
  public A withNewServicePlanExternalID(java.lang.String arg0) {
    return (A)withServicePlanExternalID(new String(arg0));
  }
  public java.lang.String getServicePlanExternalName() {
    return this.servicePlanExternalName;
  }
  public A withServicePlanExternalName(java.lang.String servicePlanExternalName) {
    this.servicePlanExternalName=servicePlanExternalName; return (A) this;
  }
  public java.lang.Boolean hasServicePlanExternalName() {
    return this.servicePlanExternalName != null;
  }
  
  /**
   * Method is deprecated. use withServicePlanExternalName instead.
   */
  @java.lang.Deprecated
  public A withNewServicePlanExternalName(java.lang.String arg0) {
    return (A)withServicePlanExternalName(new String(arg0));
  }
  public java.lang.String getServicePlanName() {
    return this.servicePlanName;
  }
  public A withServicePlanName(java.lang.String servicePlanName) {
    this.servicePlanName=servicePlanName; return (A) this;
  }
  public java.lang.Boolean hasServicePlanName() {
    return this.servicePlanName != null;
  }
  
  /**
   * Method is deprecated. use withServicePlanName instead.
   */
  @java.lang.Deprecated
  public A withNewServicePlanName(java.lang.String arg0) {
    return (A)withServicePlanName(new String(arg0));
  }
  
  /**
   * This method has been deprecated, please use method buildServicePlanRef instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.servicecatalog.api.model.LocalObjectReference getServicePlanRef() {
    return this.servicePlanRef!=null?this.servicePlanRef.build():null;
  }
  public io.fabric8.servicecatalog.api.model.LocalObjectReference buildServicePlanRef() {
    return this.servicePlanRef!=null?this.servicePlanRef.build():null;
  }
  public A withServicePlanRef(io.fabric8.servicecatalog.api.model.LocalObjectReference servicePlanRef) {
    _visitables.get("servicePlanRef").remove(this.servicePlanRef);
    if (servicePlanRef!=null){ this.servicePlanRef= new io.fabric8.servicecatalog.api.model.LocalObjectReferenceBuilder(servicePlanRef); _visitables.get("servicePlanRef").add(this.servicePlanRef);} return (A) this;
  }
  public java.lang.Boolean hasServicePlanRef() {
    return this.servicePlanRef != null;
  }
  public A withNewServicePlanRef(java.lang.String name) {
    return (A)withServicePlanRef(new LocalObjectReference(name));
  }
  public io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluent.ServicePlanRefNested<A> withNewServicePlanRef() {
    return new io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluentImpl.ServicePlanRefNestedImpl();
  }
  public io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluent.ServicePlanRefNested<A> withNewServicePlanRefLike(io.fabric8.servicecatalog.api.model.LocalObjectReference item) {
    return new io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluentImpl.ServicePlanRefNestedImpl(item);
  }
  public io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluent.ServicePlanRefNested<A> editServicePlanRef() {
    return withNewServicePlanRefLike(getServicePlanRef());
  }
  public io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluent.ServicePlanRefNested<A> editOrNewServicePlanRef() {
    return withNewServicePlanRefLike(getServicePlanRef() != null ? getServicePlanRef(): new io.fabric8.servicecatalog.api.model.LocalObjectReferenceBuilder().build());
  }
  public io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluent.ServicePlanRefNested<A> editOrNewServicePlanRefLike(io.fabric8.servicecatalog.api.model.LocalObjectReference item) {
    return withNewServicePlanRefLike(getServicePlanRef() != null ? getServicePlanRef(): item);
  }
  public java.lang.Long getUpdateRequests() {
    return this.updateRequests;
  }
  public A withUpdateRequests(java.lang.Long updateRequests) {
    this.updateRequests=updateRequests; return (A) this;
  }
  public java.lang.Boolean hasUpdateRequests() {
    return this.updateRequests != null;
  }
  
  /**
   * This method has been deprecated, please use method buildUserInfo instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.servicecatalog.api.model.UserInfo getUserInfo() {
    return this.userInfo!=null?this.userInfo.build():null;
  }
  public io.fabric8.servicecatalog.api.model.UserInfo buildUserInfo() {
    return this.userInfo!=null?this.userInfo.build():null;
  }
  public A withUserInfo(io.fabric8.servicecatalog.api.model.UserInfo userInfo) {
    _visitables.get("userInfo").remove(this.userInfo);
    if (userInfo!=null){ this.userInfo= new io.fabric8.servicecatalog.api.model.UserInfoBuilder(userInfo); _visitables.get("userInfo").add(this.userInfo);} return (A) this;
  }
  public java.lang.Boolean hasUserInfo() {
    return this.userInfo != null;
  }
  public io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluent.UserInfoNested<A> withNewUserInfo() {
    return new io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluentImpl.UserInfoNestedImpl();
  }
  public io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluent.UserInfoNested<A> withNewUserInfoLike(io.fabric8.servicecatalog.api.model.UserInfo item) {
    return new io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluentImpl.UserInfoNestedImpl(item);
  }
  public io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluent.UserInfoNested<A> editUserInfo() {
    return withNewUserInfoLike(getUserInfo());
  }
  public io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluent.UserInfoNested<A> editOrNewUserInfo() {
    return withNewUserInfoLike(getUserInfo() != null ? getUserInfo(): new io.fabric8.servicecatalog.api.model.UserInfoBuilder().build());
  }
  public io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluent.UserInfoNested<A> editOrNewUserInfoLike(io.fabric8.servicecatalog.api.model.UserInfo item) {
    return withNewUserInfoLike(getUserInfo() != null ? getUserInfo(): item);
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ServiceInstanceSpecFluentImpl that = (ServiceInstanceSpecFluentImpl) o;
    if (clusterServiceClassExternalID != null ? !clusterServiceClassExternalID.equals(that.clusterServiceClassExternalID) :that.clusterServiceClassExternalID != null) return false;
    if (clusterServiceClassExternalName != null ? !clusterServiceClassExternalName.equals(that.clusterServiceClassExternalName) :that.clusterServiceClassExternalName != null) return false;
    if (clusterServiceClassName != null ? !clusterServiceClassName.equals(that.clusterServiceClassName) :that.clusterServiceClassName != null) return false;
    if (clusterServiceClassRef != null ? !clusterServiceClassRef.equals(that.clusterServiceClassRef) :that.clusterServiceClassRef != null) return false;
    if (clusterServicePlanExternalID != null ? !clusterServicePlanExternalID.equals(that.clusterServicePlanExternalID) :that.clusterServicePlanExternalID != null) return false;
    if (clusterServicePlanExternalName != null ? !clusterServicePlanExternalName.equals(that.clusterServicePlanExternalName) :that.clusterServicePlanExternalName != null) return false;
    if (clusterServicePlanName != null ? !clusterServicePlanName.equals(that.clusterServicePlanName) :that.clusterServicePlanName != null) return false;
    if (clusterServicePlanRef != null ? !clusterServicePlanRef.equals(that.clusterServicePlanRef) :that.clusterServicePlanRef != null) return false;
    if (externalID != null ? !externalID.equals(that.externalID) :that.externalID != null) return false;
    if (parameters != null ? !parameters.equals(that.parameters) :that.parameters != null) return false;
    if (parametersFrom != null ? !parametersFrom.equals(that.parametersFrom) :that.parametersFrom != null) return false;
    if (serviceClassExternalID != null ? !serviceClassExternalID.equals(that.serviceClassExternalID) :that.serviceClassExternalID != null) return false;
    if (serviceClassExternalName != null ? !serviceClassExternalName.equals(that.serviceClassExternalName) :that.serviceClassExternalName != null) return false;
    if (serviceClassName != null ? !serviceClassName.equals(that.serviceClassName) :that.serviceClassName != null) return false;
    if (serviceClassRef != null ? !serviceClassRef.equals(that.serviceClassRef) :that.serviceClassRef != null) return false;
    if (servicePlanExternalID != null ? !servicePlanExternalID.equals(that.servicePlanExternalID) :that.servicePlanExternalID != null) return false;
    if (servicePlanExternalName != null ? !servicePlanExternalName.equals(that.servicePlanExternalName) :that.servicePlanExternalName != null) return false;
    if (servicePlanName != null ? !servicePlanName.equals(that.servicePlanName) :that.servicePlanName != null) return false;
    if (servicePlanRef != null ? !servicePlanRef.equals(that.servicePlanRef) :that.servicePlanRef != null) return false;
    if (updateRequests != null ? !updateRequests.equals(that.updateRequests) :that.updateRequests != null) return false;
    if (userInfo != null ? !userInfo.equals(that.userInfo) :that.userInfo != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(clusterServiceClassExternalID,  clusterServiceClassExternalName,  clusterServiceClassName,  clusterServiceClassRef,  clusterServicePlanExternalID,  clusterServicePlanExternalName,  clusterServicePlanName,  clusterServicePlanRef,  externalID,  parameters,  parametersFrom,  serviceClassExternalID,  serviceClassExternalName,  serviceClassName,  serviceClassRef,  servicePlanExternalID,  servicePlanExternalName,  servicePlanName,  servicePlanRef,  updateRequests,  userInfo,  super.hashCode());
  }
  public class ClusterServiceClassRefNestedImpl<N> extends io.fabric8.servicecatalog.api.model.ClusterObjectReferenceFluentImpl<io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluent.ClusterServiceClassRefNested<N>> implements io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluent.ClusterServiceClassRefNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ClusterServiceClassRefNestedImpl(io.fabric8.servicecatalog.api.model.ClusterObjectReference item) {
      this.builder = new io.fabric8.servicecatalog.api.model.ClusterObjectReferenceBuilder(this, item);
    }
    ClusterServiceClassRefNestedImpl() {
      this.builder = new io.fabric8.servicecatalog.api.model.ClusterObjectReferenceBuilder(this);
    }
    io.fabric8.servicecatalog.api.model.ClusterObjectReferenceBuilder builder;
    public N and() {
      return (N) ServiceInstanceSpecFluentImpl.this.withClusterServiceClassRef(builder.build());
    }
    public N endClusterServiceClassRef() {
      return and();
    }
    
  }
  public class ClusterServicePlanRefNestedImpl<N> extends io.fabric8.servicecatalog.api.model.ClusterObjectReferenceFluentImpl<io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluent.ClusterServicePlanRefNested<N>> implements io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluent.ClusterServicePlanRefNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ClusterServicePlanRefNestedImpl(io.fabric8.servicecatalog.api.model.ClusterObjectReference item) {
      this.builder = new io.fabric8.servicecatalog.api.model.ClusterObjectReferenceBuilder(this, item);
    }
    ClusterServicePlanRefNestedImpl() {
      this.builder = new io.fabric8.servicecatalog.api.model.ClusterObjectReferenceBuilder(this);
    }
    io.fabric8.servicecatalog.api.model.ClusterObjectReferenceBuilder builder;
    public N and() {
      return (N) ServiceInstanceSpecFluentImpl.this.withClusterServicePlanRef(builder.build());
    }
    public N endClusterServicePlanRef() {
      return and();
    }
    
  }
  public class ParametersFromNestedImpl<N> extends io.fabric8.servicecatalog.api.model.ParametersFromSourceFluentImpl<io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluent.ParametersFromNested<N>> implements io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluent.ParametersFromNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ParametersFromNestedImpl(java.lang.Integer index,io.fabric8.servicecatalog.api.model.ParametersFromSource item) {
      this.index = index;
      this.builder = new io.fabric8.servicecatalog.api.model.ParametersFromSourceBuilder(this, item);
    }
    ParametersFromNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.servicecatalog.api.model.ParametersFromSourceBuilder(this);
    }
    io.fabric8.servicecatalog.api.model.ParametersFromSourceBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) ServiceInstanceSpecFluentImpl.this.setToParametersFrom(index,builder.build());
    }
    public N endParametersFrom() {
      return and();
    }
    
  }
  public class ServiceClassRefNestedImpl<N> extends io.fabric8.servicecatalog.api.model.LocalObjectReferenceFluentImpl<io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluent.ServiceClassRefNested<N>> implements io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluent.ServiceClassRefNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ServiceClassRefNestedImpl(io.fabric8.servicecatalog.api.model.LocalObjectReference item) {
      this.builder = new io.fabric8.servicecatalog.api.model.LocalObjectReferenceBuilder(this, item);
    }
    ServiceClassRefNestedImpl() {
      this.builder = new io.fabric8.servicecatalog.api.model.LocalObjectReferenceBuilder(this);
    }
    io.fabric8.servicecatalog.api.model.LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) ServiceInstanceSpecFluentImpl.this.withServiceClassRef(builder.build());
    }
    public N endServiceClassRef() {
      return and();
    }
    
  }
  public class ServicePlanRefNestedImpl<N> extends io.fabric8.servicecatalog.api.model.LocalObjectReferenceFluentImpl<io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluent.ServicePlanRefNested<N>> implements io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluent.ServicePlanRefNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ServicePlanRefNestedImpl(io.fabric8.servicecatalog.api.model.LocalObjectReference item) {
      this.builder = new io.fabric8.servicecatalog.api.model.LocalObjectReferenceBuilder(this, item);
    }
    ServicePlanRefNestedImpl() {
      this.builder = new io.fabric8.servicecatalog.api.model.LocalObjectReferenceBuilder(this);
    }
    io.fabric8.servicecatalog.api.model.LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) ServiceInstanceSpecFluentImpl.this.withServicePlanRef(builder.build());
    }
    public N endServicePlanRef() {
      return and();
    }
    
  }
  public class UserInfoNestedImpl<N> extends io.fabric8.servicecatalog.api.model.UserInfoFluentImpl<io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluent.UserInfoNested<N>> implements io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluent.UserInfoNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    UserInfoNestedImpl(io.fabric8.servicecatalog.api.model.UserInfo item) {
      this.builder = new io.fabric8.servicecatalog.api.model.UserInfoBuilder(this, item);
    }
    UserInfoNestedImpl() {
      this.builder = new io.fabric8.servicecatalog.api.model.UserInfoBuilder(this);
    }
    io.fabric8.servicecatalog.api.model.UserInfoBuilder builder;
    public N and() {
      return (N) ServiceInstanceSpecFluentImpl.this.withUserInfo(builder.build());
    }
    public N endUserInfo() {
      return and();
    }
    
  }
  
}