package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class ServiceInstanceConditionBuilder extends io.fabric8.servicecatalog.api.model.ServiceInstanceConditionFluentImpl<io.fabric8.servicecatalog.api.model.ServiceInstanceConditionBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.servicecatalog.api.model.ServiceInstanceCondition,io.fabric8.servicecatalog.api.model.ServiceInstanceConditionBuilder>{
  public ServiceInstanceConditionBuilder() {
    this(false);
  }
  public ServiceInstanceConditionBuilder(java.lang.Boolean validationEnabled) {
    this(new ServiceInstanceCondition(), validationEnabled);
  }
  public ServiceInstanceConditionBuilder(io.fabric8.servicecatalog.api.model.ServiceInstanceConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceInstanceConditionBuilder(io.fabric8.servicecatalog.api.model.ServiceInstanceConditionFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ServiceInstanceCondition(), validationEnabled);
  }
  public ServiceInstanceConditionBuilder(io.fabric8.servicecatalog.api.model.ServiceInstanceConditionFluent<?> fluent,io.fabric8.servicecatalog.api.model.ServiceInstanceCondition instance) {
    this(fluent, instance, false);
  }
  public ServiceInstanceConditionBuilder(io.fabric8.servicecatalog.api.model.ServiceInstanceConditionFluent<?> fluent,io.fabric8.servicecatalog.api.model.ServiceInstanceCondition instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLastTransitionTime(instance.getLastTransitionTime()); 
    fluent.withMessage(instance.getMessage()); 
    fluent.withReason(instance.getReason()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withType(instance.getType()); 
    this.validationEnabled = validationEnabled; 
  }
  public ServiceInstanceConditionBuilder(io.fabric8.servicecatalog.api.model.ServiceInstanceCondition instance) {
    this(instance,false);
  }
  public ServiceInstanceConditionBuilder(io.fabric8.servicecatalog.api.model.ServiceInstanceCondition instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withLastTransitionTime(instance.getLastTransitionTime()); 
    this.withMessage(instance.getMessage()); 
    this.withReason(instance.getReason()); 
    this.withStatus(instance.getStatus()); 
    this.withType(instance.getType()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.servicecatalog.api.model.ServiceInstanceConditionFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.servicecatalog.api.model.ServiceInstanceCondition build() {
    ServiceInstanceCondition buildable = new ServiceInstanceCondition(fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ServiceInstanceConditionBuilder that = (ServiceInstanceConditionBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}