/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.servicecatalog.client.internal;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.base.BaseOperation;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.servicecatalog.api.model.ClusterServicePlan;
import io.fabric8.servicecatalog.api.model.ClusterServicePlanList;
import io.fabric8.servicecatalog.api.model.ServiceInstance;
import io.fabric8.servicecatalog.api.model.ServiceInstanceBuilder;
import io.fabric8.servicecatalog.api.model.ServiceInstanceFluent;
import io.fabric8.servicecatalog.client.internal.ClusterServicePlanResource;
import io.fabric8.servicecatalog.client.internal.ServiceInstanceOperationsImpl;
import io.fabric8.servicecatalog.client.internal.ServiceInstanceResource;
import okhttp3.OkHttpClient;

public class ClusterServicePlanOperationsImpl
extends HasMetadataOperation<ClusterServicePlan, ClusterServicePlanList, ClusterServicePlanResource>
implements ClusterServicePlanResource {
    public ClusterServicePlanOperationsImpl(OkHttpClient client, Config config) {
        this(new OperationContext().withOkhttpClient(client).withConfig(config));
    }

    public ClusterServicePlanOperationsImpl(OperationContext ctx) {
        super(ctx.withApiGroupName("servicecatalog.k8s.io").withApiGroupVersion("v1beta1").withPlural("clusterserviceplans"), ClusterServicePlan.class, ClusterServicePlanList.class);
    }

    public BaseOperation<ClusterServicePlan, ClusterServicePlanList, ClusterServicePlanResource> newInstance(OperationContext context) {
        return new ClusterServicePlanOperationsImpl(context);
    }

    public boolean isResourceNamespaced() {
        return false;
    }

    @Override
    public ServiceInstance instantiate(String ... args) {
        String instanceNamespace;
        String instanceName;
        if (args.length == 1) {
            instanceName = args[0];
            instanceNamespace = this.config.getNamespace();
        } else if (args.length == 2) {
            instanceNamespace = args[0];
            instanceName = args[1];
        } else {
            throw new IllegalArgumentException("Instantiate needs to be called with either <namespace> <instance name> or <instance name> arguments, but instead found: " + args.length + " arguments.");
        }
        ClusterServicePlan item = (ClusterServicePlan)this.get();
        return (ServiceInstance)new ServiceInstanceOperationsImpl(this.context.withItem(null)).create(((ServiceInstanceBuilder)((ServiceInstanceFluent.SpecNested)((ServiceInstanceFluent.SpecNested)((ServiceInstanceBuilder)((ServiceInstanceFluent.MetadataNested)((ServiceInstanceFluent.MetadataNested)new ServiceInstanceBuilder().withNewMetadata().withName(instanceName)).withNamespace(instanceNamespace)).endMetadata()).withNewSpec().withClusterServiceClassName(item.getSpec().getClusterServiceClassRef().getName())).withClusterServicePlanName(item.getMetadata().getName())).endSpec()).build());
    }

    @Override
    public ServiceInstanceResource instantiateAnd(String ... args) {
        ServiceInstance item = this.instantiate(args);
        return new ServiceInstanceOperationsImpl(this.context.withItem((Object)item));
    }
}

