/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.server.mock;

import io.fabric8.kubernetes.client.server.mock.KubernetesMixedDispatcher;
import io.fabric8.kubernetes.client.server.mock.KubernetesMockServerExtension;
import io.fabric8.mockwebserver.Context;
import io.fabric8.mockwebserver.ServerRequest;
import io.fabric8.mockwebserver.ServerResponse;
import io.fabric8.openshift.client.NamespacedOpenShiftClient;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.server.mock.EnableOpenShiftMockClient;
import io.fabric8.openshift.client.server.mock.OpenShiftMockServer;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Queue;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockWebServer;
import org.junit.jupiter.api.extension.ExtensionContext;

public class OpenShiftMockServerExtension
extends KubernetesMockServerExtension {
    private OpenShiftMockServer staticOpenShiftMockServer;
    private NamespacedOpenShiftClient staticOpenShiftClient;
    private OpenShiftMockServer instantOpenShiftMockServer;
    private NamespacedOpenShiftClient instantOpenShiftClient;

    protected void destroyStatic() {
        this.staticOpenShiftMockServer.destroy();
        this.staticOpenShiftClient.close();
    }

    protected void destroy() {
        if (this.instantOpenShiftMockServer != null) {
            this.instantOpenShiftMockServer.destroy();
        }
        if (this.instantOpenShiftClient != null) {
            this.instantOpenShiftClient.close();
        }
    }

    protected Class<?> getClientType() {
        return OpenShiftClient.class;
    }

    protected Class<?> getKubernetesMockServerType() {
        return OpenShiftMockServer.class;
    }

    protected void initializeKubernetesClientAndMockServer(Class<?> testClass, boolean isStatic) {
        EnableOpenShiftMockClient a = testClass.getAnnotation(EnableOpenShiftMockClient.class);
        HashMap<ServerRequest, Queue<ServerResponse>> responses = new HashMap<ServerRequest, Queue<ServerResponse>>();
        OpenShiftMockServer openShiftMockServer = a.crud() ? new OpenShiftMockServer(new Context(), new MockWebServer(), responses, (Dispatcher)new KubernetesMixedDispatcher(responses), a.https()) : new OpenShiftMockServer(a.https());
        openShiftMockServer.init();
        NamespacedOpenShiftClient openShiftClient = openShiftMockServer.createOpenShiftClient();
        if (isStatic) {
            this.staticOpenShiftMockServer = openShiftMockServer;
            this.staticOpenShiftClient = openShiftClient;
        } else {
            this.instantOpenShiftMockServer = openShiftMockServer;
            this.instantOpenShiftClient = openShiftClient;
        }
    }

    protected void setFieldIfKubernetesClientOrMockServer(ExtensionContext context, boolean isStatic, Field field) throws IllegalAccessException {
        OpenShiftMockServer openShiftMockServer;
        NamespacedOpenShiftClient openShiftClient;
        if (isStatic) {
            openShiftClient = this.staticOpenShiftClient;
            openShiftMockServer = this.staticOpenShiftMockServer;
        } else {
            openShiftClient = this.instantOpenShiftClient;
            openShiftMockServer = this.instantOpenShiftMockServer;
        }
        this.setFieldIfEqualsToProvidedType(context, isStatic, field, this.getClientType(), (i, f) -> f.set(i, openShiftClient));
        this.setFieldIfEqualsToProvidedType(context, isStatic, field, this.getKubernetesMockServerType(), (i, f) -> f.set(i, (Object)openShiftMockServer));
    }
}

