/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.GitInfo;
import io.fabric8.openshift.api.model.GitRefInfo;
import io.fabric8.openshift.api.model.GitRefInfoBuilder;
import io.fabric8.openshift.api.model.GitRefInfoFluent;
import io.fabric8.openshift.api.model.SourceControlUser;
import io.fabric8.openshift.api.model.SourceControlUserBuilder;
import io.fabric8.openshift.api.model.SourceControlUserFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class GitInfoFluent<A extends GitInfoFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private SourceControlUserBuilder author;
    private String commit;
    private SourceControlUserBuilder committer;
    private String httpProxy;
    private String httpsProxy;
    private String message;
    private String noProxy;
    private String ref;
    private ArrayList<GitRefInfoBuilder> refs = new ArrayList();
    private String uri;

    public GitInfoFluent() {
    }

    public GitInfoFluent(GitInfo instance) {
        this.copyInstance(instance);
    }

    public A addAllToRefs(Collection<GitRefInfo> items) {
        if (this.refs == null) {
            this.refs = new ArrayList();
        }
        for (GitRefInfo item : items) {
            GitRefInfoBuilder builder = new GitRefInfoBuilder(item);
            this._visitables.get((Object)"refs").add(builder);
            this.refs.add(builder);
        }
        return (A)((Object)this);
    }

    public RefsNested<A> addNewRef() {
        return new RefsNested(-1, null);
    }

    public RefsNested<A> addNewRefLike(GitRefInfo item) {
        return new RefsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToRefs(GitRefInfo ... items) {
        if (this.refs == null) {
            this.refs = new ArrayList();
        }
        for (GitRefInfo item : items) {
            GitRefInfoBuilder builder = new GitRefInfoBuilder(item);
            this._visitables.get((Object)"refs").add(builder);
            this.refs.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToRefs(int index, GitRefInfo item) {
        if (this.refs == null) {
            this.refs = new ArrayList();
        }
        GitRefInfoBuilder builder = new GitRefInfoBuilder(item);
        if (index < 0 || index >= this.refs.size()) {
            this._visitables.get((Object)"refs").add(builder);
            this.refs.add(builder);
        } else {
            this._visitables.get((Object)"refs").add(builder);
            this.refs.add(index, builder);
        }
        return (A)((Object)this);
    }

    public SourceControlUser buildAuthor() {
        return this.author != null ? this.author.build() : null;
    }

    public SourceControlUser buildCommitter() {
        return this.committer != null ? this.committer.build() : null;
    }

    public GitRefInfo buildFirstRef() {
        return this.refs.get(0).build();
    }

    public GitRefInfo buildLastRef() {
        return this.refs.get(this.refs.size() - 1).build();
    }

    public GitRefInfo buildMatchingRef(Predicate<GitRefInfoBuilder> predicate) {
        for (GitRefInfoBuilder item : this.refs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public GitRefInfo buildRef(int index) {
        return this.refs.get(index).build();
    }

    public List<GitRefInfo> buildRefs() {
        return this.refs != null ? GitInfoFluent.build(this.refs) : null;
    }

    protected void copyInstance(GitInfo instance) {
        GitInfo gitInfo = instance = instance != null ? instance : new GitInfo();
        if (instance != null) {
            this.withAuthor(instance.getAuthor());
            this.withCommit(instance.getCommit());
            this.withCommitter(instance.getCommitter());
            this.withHttpProxy(instance.getHttpProxy());
            this.withHttpsProxy(instance.getHttpsProxy());
            this.withMessage(instance.getMessage());
            this.withNoProxy(instance.getNoProxy());
            this.withRef(instance.getRef());
            this.withRefs(instance.getRefs());
            this.withUri(instance.getUri());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public AuthorNested<A> editAuthor() {
        return this.withNewAuthorLike(Optional.ofNullable(this.buildAuthor()).orElse(null));
    }

    public CommitterNested<A> editCommitter() {
        return this.withNewCommitterLike(Optional.ofNullable(this.buildCommitter()).orElse(null));
    }

    public RefsNested<A> editFirstRef() {
        if (this.refs.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "refs"));
        }
        return this.setNewRefLike(0, this.buildRef(0));
    }

    public RefsNested<A> editLastRef() {
        int index = this.refs.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "refs"));
        }
        return this.setNewRefLike(index, this.buildRef(index));
    }

    public RefsNested<A> editMatchingRef(Predicate<GitRefInfoBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.refs.size(); ++i) {
            if (!predicate.test(this.refs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "refs"));
        }
        return this.setNewRefLike(index, this.buildRef(index));
    }

    public AuthorNested<A> editOrNewAuthor() {
        return this.withNewAuthorLike(Optional.ofNullable(this.buildAuthor()).orElse(new SourceControlUserBuilder().build()));
    }

    public AuthorNested<A> editOrNewAuthorLike(SourceControlUser item) {
        return this.withNewAuthorLike(Optional.ofNullable(this.buildAuthor()).orElse(item));
    }

    public CommitterNested<A> editOrNewCommitter() {
        return this.withNewCommitterLike(Optional.ofNullable(this.buildCommitter()).orElse(new SourceControlUserBuilder().build()));
    }

    public CommitterNested<A> editOrNewCommitterLike(SourceControlUser item) {
        return this.withNewCommitterLike(Optional.ofNullable(this.buildCommitter()).orElse(item));
    }

    public RefsNested<A> editRef(int index) {
        if (this.refs.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "refs"));
        }
        return this.setNewRefLike(index, this.buildRef(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GitInfoFluent that = (GitInfoFluent)((Object)o);
        if (!Objects.equals((Object)this.author, (Object)that.author)) {
            return false;
        }
        if (!Objects.equals(this.commit, that.commit)) {
            return false;
        }
        if (!Objects.equals((Object)this.committer, (Object)that.committer)) {
            return false;
        }
        if (!Objects.equals(this.httpProxy, that.httpProxy)) {
            return false;
        }
        if (!Objects.equals(this.httpsProxy, that.httpsProxy)) {
            return false;
        }
        if (!Objects.equals(this.message, that.message)) {
            return false;
        }
        if (!Objects.equals(this.noProxy, that.noProxy)) {
            return false;
        }
        if (!Objects.equals(this.ref, that.ref)) {
            return false;
        }
        if (!Objects.equals(this.refs, that.refs)) {
            return false;
        }
        if (!Objects.equals(this.uri, that.uri)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getCommit() {
        return this.commit;
    }

    public String getHttpProxy() {
        return this.httpProxy;
    }

    public String getHttpsProxy() {
        return this.httpsProxy;
    }

    public String getMessage() {
        return this.message;
    }

    public String getNoProxy() {
        return this.noProxy;
    }

    public String getRef() {
        return this.ref;
    }

    public String getUri() {
        return this.uri;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasAuthor() {
        return this.author != null;
    }

    public boolean hasCommit() {
        return this.commit != null;
    }

    public boolean hasCommitter() {
        return this.committer != null;
    }

    public boolean hasHttpProxy() {
        return this.httpProxy != null;
    }

    public boolean hasHttpsProxy() {
        return this.httpsProxy != null;
    }

    public boolean hasMatchingRef(Predicate<GitRefInfoBuilder> predicate) {
        for (GitRefInfoBuilder item : this.refs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMessage() {
        return this.message != null;
    }

    public boolean hasNoProxy() {
        return this.noProxy != null;
    }

    public boolean hasRef() {
        return this.ref != null;
    }

    public boolean hasRefs() {
        return this.refs != null && !this.refs.isEmpty();
    }

    public boolean hasUri() {
        return this.uri != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.author, this.commit, this.committer, this.httpProxy, this.httpsProxy, this.message, this.noProxy, this.ref, this.refs, this.uri, this.additionalProperties});
    }

    public A removeAllFromRefs(Collection<GitRefInfo> items) {
        if (this.refs == null) {
            return (A)((Object)this);
        }
        for (GitRefInfo item : items) {
            GitRefInfoBuilder builder = new GitRefInfoBuilder(item);
            this._visitables.get((Object)"refs").remove((Object)builder);
            this.refs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromRefs(GitRefInfo ... items) {
        if (this.refs == null) {
            return (A)((Object)this);
        }
        for (GitRefInfo item : items) {
            GitRefInfoBuilder builder = new GitRefInfoBuilder(item);
            this._visitables.get((Object)"refs").remove((Object)builder);
            this.refs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromRefs(Predicate<GitRefInfoBuilder> predicate) {
        if (this.refs == null) {
            return (A)((Object)this);
        }
        Iterator<GitRefInfoBuilder> each = this.refs.iterator();
        List visitables = this._visitables.get((Object)"refs");
        while (each.hasNext()) {
            GitRefInfoBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public RefsNested<A> setNewRefLike(int index, GitRefInfo item) {
        return new RefsNested(index, item);
    }

    public A setToRefs(int index, GitRefInfo item) {
        if (this.refs == null) {
            this.refs = new ArrayList();
        }
        GitRefInfoBuilder builder = new GitRefInfoBuilder(item);
        if (index < 0 || index >= this.refs.size()) {
            this._visitables.get((Object)"refs").add(builder);
            this.refs.add(builder);
        } else {
            this._visitables.get((Object)"refs").add(builder);
            this.refs.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.author != null) {
            sb.append("author:");
            sb.append((Object)this.author);
            sb.append(",");
        }
        if (this.commit != null) {
            sb.append("commit:");
            sb.append(this.commit);
            sb.append(",");
        }
        if (this.committer != null) {
            sb.append("committer:");
            sb.append((Object)this.committer);
            sb.append(",");
        }
        if (this.httpProxy != null) {
            sb.append("httpProxy:");
            sb.append(this.httpProxy);
            sb.append(",");
        }
        if (this.httpsProxy != null) {
            sb.append("httpsProxy:");
            sb.append(this.httpsProxy);
            sb.append(",");
        }
        if (this.message != null) {
            sb.append("message:");
            sb.append(this.message);
            sb.append(",");
        }
        if (this.noProxy != null) {
            sb.append("noProxy:");
            sb.append(this.noProxy);
            sb.append(",");
        }
        if (this.ref != null) {
            sb.append("ref:");
            sb.append(this.ref);
            sb.append(",");
        }
        if (this.refs != null && !this.refs.isEmpty()) {
            sb.append("refs:");
            sb.append(this.refs);
            sb.append(",");
        }
        if (this.uri != null) {
            sb.append("uri:");
            sb.append(this.uri);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withAuthor(SourceControlUser author) {
        this._visitables.remove((Object)"author");
        if (author != null) {
            this.author = new SourceControlUserBuilder(author);
            this._visitables.get((Object)"author").add(this.author);
        } else {
            this.author = null;
            this._visitables.get((Object)"author").remove((Object)this.author);
        }
        return (A)((Object)this);
    }

    public A withCommit(String commit) {
        this.commit = commit;
        return (A)((Object)this);
    }

    public A withCommitter(SourceControlUser committer) {
        this._visitables.remove((Object)"committer");
        if (committer != null) {
            this.committer = new SourceControlUserBuilder(committer);
            this._visitables.get((Object)"committer").add(this.committer);
        } else {
            this.committer = null;
            this._visitables.get((Object)"committer").remove((Object)this.committer);
        }
        return (A)((Object)this);
    }

    public A withHttpProxy(String httpProxy) {
        this.httpProxy = httpProxy;
        return (A)((Object)this);
    }

    public A withHttpsProxy(String httpsProxy) {
        this.httpsProxy = httpsProxy;
        return (A)((Object)this);
    }

    public A withMessage(String message) {
        this.message = message;
        return (A)((Object)this);
    }

    public AuthorNested<A> withNewAuthor() {
        return new AuthorNested(null);
    }

    public A withNewAuthor(String email, String name) {
        return this.withAuthor(new SourceControlUser(email, name));
    }

    public AuthorNested<A> withNewAuthorLike(SourceControlUser item) {
        return new AuthorNested(item);
    }

    public CommitterNested<A> withNewCommitter() {
        return new CommitterNested(null);
    }

    public A withNewCommitter(String email, String name) {
        return this.withCommitter(new SourceControlUser(email, name));
    }

    public CommitterNested<A> withNewCommitterLike(SourceControlUser item) {
        return new CommitterNested(item);
    }

    public A withNoProxy(String noProxy) {
        this.noProxy = noProxy;
        return (A)((Object)this);
    }

    public A withRef(String ref) {
        this.ref = ref;
        return (A)((Object)this);
    }

    public A withRefs(List<GitRefInfo> refs) {
        if (this.refs != null) {
            this._visitables.get((Object)"refs").clear();
        }
        if (refs != null) {
            this.refs = new ArrayList();
            for (GitRefInfo item : refs) {
                this.addToRefs(item);
            }
        } else {
            this.refs = null;
        }
        return (A)((Object)this);
    }

    public A withRefs(GitRefInfo ... refs) {
        if (this.refs != null) {
            this.refs.clear();
            this._visitables.remove((Object)"refs");
        }
        if (refs != null) {
            for (GitRefInfo item : refs) {
                this.addToRefs(item);
            }
        }
        return (A)((Object)this);
    }

    public A withUri(String uri) {
        this.uri = uri;
        return (A)((Object)this);
    }

    public class RefsNested<N>
    extends GitRefInfoFluent<RefsNested<N>>
    implements Nested<N> {
        GitRefInfoBuilder builder;
        int index;

        RefsNested(int index, GitRefInfo item) {
            this.index = index;
            this.builder = new GitRefInfoBuilder(this, item);
        }

        public N and() {
            return (N)GitInfoFluent.this.setToRefs(this.index, this.builder.build());
        }

        public N endRef() {
            return this.and();
        }
    }

    public class CommitterNested<N>
    extends SourceControlUserFluent<CommitterNested<N>>
    implements Nested<N> {
        SourceControlUserBuilder builder;

        CommitterNested(SourceControlUser item) {
            this.builder = new SourceControlUserBuilder(this, item);
        }

        public N and() {
            return (N)GitInfoFluent.this.withCommitter(this.builder.build());
        }

        public N endCommitter() {
            return this.and();
        }
    }

    public class AuthorNested<N>
    extends SourceControlUserFluent<AuthorNested<N>>
    implements Nested<N> {
        SourceControlUserBuilder builder;

        AuthorNested(SourceControlUser item) {
            this.builder = new SourceControlUserBuilder(this, item);
        }

        public N and() {
            return (N)GitInfoFluent.this.withAuthor(this.builder.build());
        }

        public N endAuthor() {
            return this.and();
        }
    }
}

