/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.openshift.api.model.ConfigMapBuildSource;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ConfigMapBuildSourceFluent<A extends ConfigMapBuildSourceFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private LocalObjectReferenceBuilder configMap;
    private String destinationDir;

    public ConfigMapBuildSourceFluent() {
    }

    public ConfigMapBuildSourceFluent(ConfigMapBuildSource instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public LocalObjectReference buildConfigMap() {
        return this.configMap != null ? this.configMap.build() : null;
    }

    protected void copyInstance(ConfigMapBuildSource instance) {
        ConfigMapBuildSource configMapBuildSource = instance = instance != null ? instance : new ConfigMapBuildSource();
        if (instance != null) {
            this.withConfigMap(instance.getConfigMap());
            this.withDestinationDir(instance.getDestinationDir());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ConfigMapNested<A> editConfigMap() {
        return this.withNewConfigMapLike(Optional.ofNullable(this.buildConfigMap()).orElse(null));
    }

    public ConfigMapNested<A> editOrNewConfigMap() {
        return this.withNewConfigMapLike(Optional.ofNullable(this.buildConfigMap()).orElse(new LocalObjectReferenceBuilder().build()));
    }

    public ConfigMapNested<A> editOrNewConfigMapLike(LocalObjectReference item) {
        return this.withNewConfigMapLike(Optional.ofNullable(this.buildConfigMap()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConfigMapBuildSourceFluent that = (ConfigMapBuildSourceFluent)((Object)o);
        if (!Objects.equals(this.configMap, that.configMap)) {
            return false;
        }
        if (!Objects.equals(this.destinationDir, that.destinationDir)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getDestinationDir() {
        return this.destinationDir;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasConfigMap() {
        return this.configMap != null;
    }

    public boolean hasDestinationDir() {
        return this.destinationDir != null;
    }

    public int hashCode() {
        return Objects.hash(this.configMap, this.destinationDir, this.additionalProperties);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.configMap != null) {
            sb.append("configMap:");
            sb.append(this.configMap);
            sb.append(",");
        }
        if (this.destinationDir != null) {
            sb.append("destinationDir:");
            sb.append(this.destinationDir);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withConfigMap(LocalObjectReference configMap) {
        this._visitables.remove((Object)"configMap");
        if (configMap != null) {
            this.configMap = new LocalObjectReferenceBuilder(configMap);
            this._visitables.get((Object)"configMap").add(this.configMap);
        } else {
            this.configMap = null;
            this._visitables.get((Object)"configMap").remove(this.configMap);
        }
        return (A)((Object)this);
    }

    public A withDestinationDir(String destinationDir) {
        this.destinationDir = destinationDir;
        return (A)((Object)this);
    }

    public ConfigMapNested<A> withNewConfigMap() {
        return new ConfigMapNested(null);
    }

    public A withNewConfigMap(String name) {
        return this.withConfigMap(new LocalObjectReference(name));
    }

    public ConfigMapNested<A> withNewConfigMapLike(LocalObjectReference item) {
        return new ConfigMapNested(item);
    }

    public class ConfigMapNested<N>
    extends LocalObjectReferenceFluent<ConfigMapNested<N>>
    implements Nested<N> {
        LocalObjectReferenceBuilder builder;

        ConfigMapNested(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder((LocalObjectReferenceFluent)this, item);
        }

        public N and() {
            return (N)ConfigMapBuildSourceFluent.this.withConfigMap(this.builder.build());
        }

        public N endConfigMap() {
            return this.and();
        }
    }
}

