/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.openshift.api.model.PodSecurityPolicySubjectReviewStatus;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class PodSecurityPolicySubjectReviewStatusFluent<A extends PodSecurityPolicySubjectReviewStatusFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private ObjectReferenceBuilder allowedBy;
    private String reason;
    private PodTemplateSpecBuilder template;

    public PodSecurityPolicySubjectReviewStatusFluent() {
    }

    public PodSecurityPolicySubjectReviewStatusFluent(PodSecurityPolicySubjectReviewStatus instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public ObjectReference buildAllowedBy() {
        return this.allowedBy != null ? this.allowedBy.build() : null;
    }

    public PodTemplateSpec buildTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    protected void copyInstance(PodSecurityPolicySubjectReviewStatus instance) {
        PodSecurityPolicySubjectReviewStatus podSecurityPolicySubjectReviewStatus = instance = instance != null ? instance : new PodSecurityPolicySubjectReviewStatus();
        if (instance != null) {
            this.withAllowedBy(instance.getAllowedBy());
            this.withReason(instance.getReason());
            this.withTemplate(instance.getTemplate());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public AllowedByNested<A> editAllowedBy() {
        return this.withNewAllowedByLike(Optional.ofNullable(this.buildAllowedBy()).orElse(null));
    }

    public AllowedByNested<A> editOrNewAllowedBy() {
        return this.withNewAllowedByLike(Optional.ofNullable(this.buildAllowedBy()).orElse(new ObjectReferenceBuilder().build()));
    }

    public AllowedByNested<A> editOrNewAllowedByLike(ObjectReference item) {
        return this.withNewAllowedByLike(Optional.ofNullable(this.buildAllowedBy()).orElse(item));
    }

    public TemplateNested<A> editOrNewTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(new PodTemplateSpecBuilder().build()));
    }

    public TemplateNested<A> editOrNewTemplateLike(PodTemplateSpec item) {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(item));
    }

    public TemplateNested<A> editTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodSecurityPolicySubjectReviewStatusFluent that = (PodSecurityPolicySubjectReviewStatusFluent)((Object)o);
        if (!Objects.equals(this.allowedBy, that.allowedBy)) {
            return false;
        }
        if (!Objects.equals(this.reason, that.reason)) {
            return false;
        }
        if (!Objects.equals(this.template, that.template)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getReason() {
        return this.reason;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasAllowedBy() {
        return this.allowedBy != null;
    }

    public boolean hasReason() {
        return this.reason != null;
    }

    public boolean hasTemplate() {
        return this.template != null;
    }

    public int hashCode() {
        return Objects.hash(this.allowedBy, this.reason, this.template, this.additionalProperties);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allowedBy != null) {
            sb.append("allowedBy:");
            sb.append(this.allowedBy);
            sb.append(",");
        }
        if (this.reason != null) {
            sb.append("reason:");
            sb.append(this.reason);
            sb.append(",");
        }
        if (this.template != null) {
            sb.append("template:");
            sb.append(this.template);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withAllowedBy(ObjectReference allowedBy) {
        this._visitables.remove((Object)"allowedBy");
        if (allowedBy != null) {
            this.allowedBy = new ObjectReferenceBuilder(allowedBy);
            this._visitables.get((Object)"allowedBy").add(this.allowedBy);
        } else {
            this.allowedBy = null;
            this._visitables.get((Object)"allowedBy").remove(this.allowedBy);
        }
        return (A)((Object)this);
    }

    public AllowedByNested<A> withNewAllowedBy() {
        return new AllowedByNested(null);
    }

    public AllowedByNested<A> withNewAllowedByLike(ObjectReference item) {
        return new AllowedByNested(item);
    }

    public TemplateNested<A> withNewTemplate() {
        return new TemplateNested(null);
    }

    public TemplateNested<A> withNewTemplateLike(PodTemplateSpec item) {
        return new TemplateNested(item);
    }

    public A withReason(String reason) {
        this.reason = reason;
        return (A)((Object)this);
    }

    public A withTemplate(PodTemplateSpec template) {
        this._visitables.remove((Object)"template");
        if (template != null) {
            this.template = new PodTemplateSpecBuilder(template);
            this._visitables.get((Object)"template").add(this.template);
        } else {
            this.template = null;
            this._visitables.get((Object)"template").remove(this.template);
        }
        return (A)((Object)this);
    }

    public class TemplateNested<N>
    extends PodTemplateSpecFluent<TemplateNested<N>>
    implements Nested<N> {
        PodTemplateSpecBuilder builder;

        TemplateNested(PodTemplateSpec item) {
            this.builder = new PodTemplateSpecBuilder((PodTemplateSpecFluent)this, item);
        }

        public N and() {
            return (N)PodSecurityPolicySubjectReviewStatusFluent.this.withTemplate(this.builder.build());
        }

        public N endTemplate() {
            return this.and();
        }
    }

    public class AllowedByNested<N>
    extends ObjectReferenceFluent<AllowedByNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;

        AllowedByNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder((ObjectReferenceFluent)this, item);
        }

        public N and() {
            return (N)PodSecurityPolicySubjectReviewStatusFluent.this.withAllowedBy(this.builder.build());
        }

        public N endAllowedBy() {
            return this.and();
        }
    }
}

