/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.ClusterRoleBinding;
import io.fabric8.openshift.api.model.ClusterRoleBindingBuilder;
import io.fabric8.openshift.api.model.ClusterRoleBindingFluent;
import io.fabric8.openshift.api.model.NamedClusterRoleBinding;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class NamedClusterRoleBindingFluent<A extends NamedClusterRoleBindingFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String name;
    private ClusterRoleBindingBuilder roleBinding;

    public NamedClusterRoleBindingFluent() {
    }

    public NamedClusterRoleBindingFluent(NamedClusterRoleBinding instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public ClusterRoleBinding buildRoleBinding() {
        return this.roleBinding != null ? this.roleBinding.build() : null;
    }

    protected void copyInstance(NamedClusterRoleBinding instance) {
        NamedClusterRoleBinding namedClusterRoleBinding = instance = instance != null ? instance : new NamedClusterRoleBinding();
        if (instance != null) {
            this.withName(instance.getName());
            this.withRoleBinding(instance.getRoleBinding());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public RoleBindingNested<A> editOrNewRoleBinding() {
        return this.withNewRoleBindingLike(Optional.ofNullable(this.buildRoleBinding()).orElse(new ClusterRoleBindingBuilder().build()));
    }

    public RoleBindingNested<A> editOrNewRoleBindingLike(ClusterRoleBinding item) {
        return this.withNewRoleBindingLike(Optional.ofNullable(this.buildRoleBinding()).orElse(item));
    }

    public RoleBindingNested<A> editRoleBinding() {
        return this.withNewRoleBindingLike(Optional.ofNullable(this.buildRoleBinding()).orElse(null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NamedClusterRoleBindingFluent that = (NamedClusterRoleBindingFluent)((Object)o);
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals((Object)this.roleBinding, (Object)that.roleBinding)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public boolean hasRoleBinding() {
        return this.roleBinding != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.roleBinding, this.additionalProperties});
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name);
            sb.append(",");
        }
        if (this.roleBinding != null) {
            sb.append("roleBinding:");
            sb.append((Object)this.roleBinding);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public RoleBindingNested<A> withNewRoleBinding() {
        return new RoleBindingNested(null);
    }

    public RoleBindingNested<A> withNewRoleBindingLike(ClusterRoleBinding item) {
        return new RoleBindingNested(item);
    }

    public A withRoleBinding(ClusterRoleBinding roleBinding) {
        this._visitables.remove((Object)"roleBinding");
        if (roleBinding != null) {
            this.roleBinding = new ClusterRoleBindingBuilder(roleBinding);
            this._visitables.get((Object)"roleBinding").add(this.roleBinding);
        } else {
            this.roleBinding = null;
            this._visitables.get((Object)"roleBinding").remove((Object)this.roleBinding);
        }
        return (A)((Object)this);
    }

    public class RoleBindingNested<N>
    extends ClusterRoleBindingFluent<RoleBindingNested<N>>
    implements Nested<N> {
        ClusterRoleBindingBuilder builder;

        RoleBindingNested(ClusterRoleBinding item) {
            this.builder = new ClusterRoleBindingBuilder(this, item);
        }

        public N and() {
            return (N)NamedClusterRoleBindingFluent.this.withRoleBinding(this.builder.build());
        }

        public N endRoleBinding() {
            return this.and();
        }
    }
}

