/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.BuildConfigStatus;
import io.fabric8.openshift.api.model.ImageChangeTriggerStatus;
import io.fabric8.openshift.api.model.ImageChangeTriggerStatusBuilder;
import io.fabric8.openshift.api.model.ImageChangeTriggerStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class BuildConfigStatusFluent<A extends BuildConfigStatusFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private ArrayList<ImageChangeTriggerStatusBuilder> imageChangeTriggers = new ArrayList();
    private Long lastVersion;

    public BuildConfigStatusFluent() {
    }

    public BuildConfigStatusFluent(BuildConfigStatus instance) {
        this.copyInstance(instance);
    }

    public A addAllToImageChangeTriggers(Collection<ImageChangeTriggerStatus> items) {
        if (this.imageChangeTriggers == null) {
            this.imageChangeTriggers = new ArrayList();
        }
        for (ImageChangeTriggerStatus item : items) {
            ImageChangeTriggerStatusBuilder builder = new ImageChangeTriggerStatusBuilder(item);
            this._visitables.get((Object)"imageChangeTriggers").add(builder);
            this.imageChangeTriggers.add(builder);
        }
        return (A)((Object)this);
    }

    public ImageChangeTriggersNested<A> addNewImageChangeTrigger() {
        return new ImageChangeTriggersNested(-1, null);
    }

    public ImageChangeTriggersNested<A> addNewImageChangeTriggerLike(ImageChangeTriggerStatus item) {
        return new ImageChangeTriggersNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToImageChangeTriggers(ImageChangeTriggerStatus ... items) {
        if (this.imageChangeTriggers == null) {
            this.imageChangeTriggers = new ArrayList();
        }
        for (ImageChangeTriggerStatus item : items) {
            ImageChangeTriggerStatusBuilder builder = new ImageChangeTriggerStatusBuilder(item);
            this._visitables.get((Object)"imageChangeTriggers").add(builder);
            this.imageChangeTriggers.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToImageChangeTriggers(int index, ImageChangeTriggerStatus item) {
        if (this.imageChangeTriggers == null) {
            this.imageChangeTriggers = new ArrayList();
        }
        ImageChangeTriggerStatusBuilder builder = new ImageChangeTriggerStatusBuilder(item);
        if (index < 0 || index >= this.imageChangeTriggers.size()) {
            this._visitables.get((Object)"imageChangeTriggers").add(builder);
            this.imageChangeTriggers.add(builder);
        } else {
            this._visitables.get((Object)"imageChangeTriggers").add(builder);
            this.imageChangeTriggers.add(index, builder);
        }
        return (A)((Object)this);
    }

    public ImageChangeTriggerStatus buildFirstImageChangeTrigger() {
        return this.imageChangeTriggers.get(0).build();
    }

    public ImageChangeTriggerStatus buildImageChangeTrigger(int index) {
        return this.imageChangeTriggers.get(index).build();
    }

    public List<ImageChangeTriggerStatus> buildImageChangeTriggers() {
        return this.imageChangeTriggers != null ? BuildConfigStatusFluent.build(this.imageChangeTriggers) : null;
    }

    public ImageChangeTriggerStatus buildLastImageChangeTrigger() {
        return this.imageChangeTriggers.get(this.imageChangeTriggers.size() - 1).build();
    }

    public ImageChangeTriggerStatus buildMatchingImageChangeTrigger(Predicate<ImageChangeTriggerStatusBuilder> predicate) {
        for (ImageChangeTriggerStatusBuilder item : this.imageChangeTriggers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    protected void copyInstance(BuildConfigStatus instance) {
        BuildConfigStatus buildConfigStatus = instance = instance != null ? instance : new BuildConfigStatus();
        if (instance != null) {
            this.withImageChangeTriggers(instance.getImageChangeTriggers());
            this.withLastVersion(instance.getLastVersion());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ImageChangeTriggersNested<A> editFirstImageChangeTrigger() {
        if (this.imageChangeTriggers.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "imageChangeTriggers"));
        }
        return this.setNewImageChangeTriggerLike(0, this.buildImageChangeTrigger(0));
    }

    public ImageChangeTriggersNested<A> editImageChangeTrigger(int index) {
        if (this.imageChangeTriggers.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "imageChangeTriggers"));
        }
        return this.setNewImageChangeTriggerLike(index, this.buildImageChangeTrigger(index));
    }

    public ImageChangeTriggersNested<A> editLastImageChangeTrigger() {
        int index = this.imageChangeTriggers.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "imageChangeTriggers"));
        }
        return this.setNewImageChangeTriggerLike(index, this.buildImageChangeTrigger(index));
    }

    public ImageChangeTriggersNested<A> editMatchingImageChangeTrigger(Predicate<ImageChangeTriggerStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.imageChangeTriggers.size(); ++i) {
            if (!predicate.test(this.imageChangeTriggers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "imageChangeTriggers"));
        }
        return this.setNewImageChangeTriggerLike(index, this.buildImageChangeTrigger(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildConfigStatusFluent that = (BuildConfigStatusFluent)((Object)o);
        if (!Objects.equals(this.imageChangeTriggers, that.imageChangeTriggers)) {
            return false;
        }
        if (!Objects.equals(this.lastVersion, that.lastVersion)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Long getLastVersion() {
        return this.lastVersion;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasImageChangeTriggers() {
        return this.imageChangeTriggers != null && !this.imageChangeTriggers.isEmpty();
    }

    public boolean hasLastVersion() {
        return this.lastVersion != null;
    }

    public boolean hasMatchingImageChangeTrigger(Predicate<ImageChangeTriggerStatusBuilder> predicate) {
        for (ImageChangeTriggerStatusBuilder item : this.imageChangeTriggers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.imageChangeTriggers, this.lastVersion, this.additionalProperties);
    }

    public A removeAllFromImageChangeTriggers(Collection<ImageChangeTriggerStatus> items) {
        if (this.imageChangeTriggers == null) {
            return (A)((Object)this);
        }
        for (ImageChangeTriggerStatus item : items) {
            ImageChangeTriggerStatusBuilder builder = new ImageChangeTriggerStatusBuilder(item);
            this._visitables.get((Object)"imageChangeTriggers").remove((Object)builder);
            this.imageChangeTriggers.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromImageChangeTriggers(ImageChangeTriggerStatus ... items) {
        if (this.imageChangeTriggers == null) {
            return (A)((Object)this);
        }
        for (ImageChangeTriggerStatus item : items) {
            ImageChangeTriggerStatusBuilder builder = new ImageChangeTriggerStatusBuilder(item);
            this._visitables.get((Object)"imageChangeTriggers").remove((Object)builder);
            this.imageChangeTriggers.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromImageChangeTriggers(Predicate<ImageChangeTriggerStatusBuilder> predicate) {
        if (this.imageChangeTriggers == null) {
            return (A)((Object)this);
        }
        Iterator<ImageChangeTriggerStatusBuilder> each = this.imageChangeTriggers.iterator();
        List visitables = this._visitables.get((Object)"imageChangeTriggers");
        while (each.hasNext()) {
            ImageChangeTriggerStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public ImageChangeTriggersNested<A> setNewImageChangeTriggerLike(int index, ImageChangeTriggerStatus item) {
        return new ImageChangeTriggersNested(index, item);
    }

    public A setToImageChangeTriggers(int index, ImageChangeTriggerStatus item) {
        if (this.imageChangeTriggers == null) {
            this.imageChangeTriggers = new ArrayList();
        }
        ImageChangeTriggerStatusBuilder builder = new ImageChangeTriggerStatusBuilder(item);
        if (index < 0 || index >= this.imageChangeTriggers.size()) {
            this._visitables.get((Object)"imageChangeTriggers").add(builder);
            this.imageChangeTriggers.add(builder);
        } else {
            this._visitables.get((Object)"imageChangeTriggers").add(builder);
            this.imageChangeTriggers.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.imageChangeTriggers != null && !this.imageChangeTriggers.isEmpty()) {
            sb.append("imageChangeTriggers:");
            sb.append(this.imageChangeTriggers);
            sb.append(",");
        }
        if (this.lastVersion != null) {
            sb.append("lastVersion:");
            sb.append(this.lastVersion);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withImageChangeTriggers(List<ImageChangeTriggerStatus> imageChangeTriggers) {
        if (this.imageChangeTriggers != null) {
            this._visitables.get((Object)"imageChangeTriggers").clear();
        }
        if (imageChangeTriggers != null) {
            this.imageChangeTriggers = new ArrayList();
            for (ImageChangeTriggerStatus item : imageChangeTriggers) {
                this.addToImageChangeTriggers(item);
            }
        } else {
            this.imageChangeTriggers = null;
        }
        return (A)((Object)this);
    }

    public A withImageChangeTriggers(ImageChangeTriggerStatus ... imageChangeTriggers) {
        if (this.imageChangeTriggers != null) {
            this.imageChangeTriggers.clear();
            this._visitables.remove((Object)"imageChangeTriggers");
        }
        if (imageChangeTriggers != null) {
            for (ImageChangeTriggerStatus item : imageChangeTriggers) {
                this.addToImageChangeTriggers(item);
            }
        }
        return (A)((Object)this);
    }

    public A withLastVersion(Long lastVersion) {
        this.lastVersion = lastVersion;
        return (A)((Object)this);
    }

    public class ImageChangeTriggersNested<N>
    extends ImageChangeTriggerStatusFluent<ImageChangeTriggersNested<N>>
    implements Nested<N> {
        ImageChangeTriggerStatusBuilder builder;
        int index;

        ImageChangeTriggersNested(int index, ImageChangeTriggerStatus item) {
            this.index = index;
            this.builder = new ImageChangeTriggerStatusBuilder(this, item);
        }

        public N and() {
            return (N)BuildConfigStatusFluent.this.setToImageChangeTriggers(this.index, this.builder.build());
        }

        public N endImageChangeTrigger() {
            return this.and();
        }
    }
}

