/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import io.fabric8.openshift.api.model.BuildOutput;
import io.fabric8.openshift.api.model.BuildOutputBuilder;
import io.fabric8.openshift.api.model.BuildOutputFluent;
import io.fabric8.openshift.api.model.BuildPostCommitSpec;
import io.fabric8.openshift.api.model.BuildPostCommitSpecBuilder;
import io.fabric8.openshift.api.model.BuildPostCommitSpecFluent;
import io.fabric8.openshift.api.model.BuildSource;
import io.fabric8.openshift.api.model.BuildSourceBuilder;
import io.fabric8.openshift.api.model.BuildSourceFluent;
import io.fabric8.openshift.api.model.BuildStrategy;
import io.fabric8.openshift.api.model.BuildStrategyBuilder;
import io.fabric8.openshift.api.model.BuildStrategyFluent;
import io.fabric8.openshift.api.model.CommonSpec;
import io.fabric8.openshift.api.model.SourceRevision;
import io.fabric8.openshift.api.model.SourceRevisionBuilder;
import io.fabric8.openshift.api.model.SourceRevisionFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class CommonSpecFluent<A extends CommonSpecFluent<A>>
extends BaseFluent<A> {
    private Long completionDeadlineSeconds;
    private Boolean mountTrustedCA;
    private Map<String, String> nodeSelector;
    private BuildOutputBuilder output;
    private BuildPostCommitSpecBuilder postCommit;
    private ResourceRequirementsBuilder resources;
    private SourceRevisionBuilder revision;
    private String serviceAccount;
    private BuildSourceBuilder source;
    private BuildStrategyBuilder strategy;
    private Map<String, Object> additionalProperties;

    public CommonSpecFluent() {
    }

    public CommonSpecFluent(CommonSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(CommonSpec instance) {
        CommonSpec commonSpec = instance = instance != null ? instance : new CommonSpec();
        if (instance != null) {
            this.withCompletionDeadlineSeconds(instance.getCompletionDeadlineSeconds());
            this.withMountTrustedCA(instance.getMountTrustedCA());
            this.withNodeSelector(instance.getNodeSelector());
            this.withOutput(instance.getOutput());
            this.withPostCommit(instance.getPostCommit());
            this.withResources(instance.getResources());
            this.withRevision(instance.getRevision());
            this.withServiceAccount(instance.getServiceAccount());
            this.withSource(instance.getSource());
            this.withStrategy(instance.getStrategy());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Long getCompletionDeadlineSeconds() {
        return this.completionDeadlineSeconds;
    }

    public A withCompletionDeadlineSeconds(Long completionDeadlineSeconds) {
        this.completionDeadlineSeconds = completionDeadlineSeconds;
        return (A)((Object)this);
    }

    public boolean hasCompletionDeadlineSeconds() {
        return this.completionDeadlineSeconds != null;
    }

    public Boolean getMountTrustedCA() {
        return this.mountTrustedCA;
    }

    public A withMountTrustedCA(Boolean mountTrustedCA) {
        this.mountTrustedCA = mountTrustedCA;
        return (A)((Object)this);
    }

    public boolean hasMountTrustedCA() {
        return this.mountTrustedCA != null;
    }

    public A addToNodeSelector(String key, String value) {
        if (this.nodeSelector == null && key != null && value != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.nodeSelector.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null && map != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.nodeSelector.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromNodeSelector(String key) {
        if (this.nodeSelector == null) {
            return (A)((Object)this);
        }
        if (key != null && this.nodeSelector != null) {
            this.nodeSelector.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.nodeSelector == null) continue;
                this.nodeSelector.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getNodeSelector() {
        return this.nodeSelector;
    }

    public <K, V> A withNodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector = nodeSelector == null ? null : new LinkedHashMap<String, String>(nodeSelector);
        return (A)((Object)this);
    }

    public boolean hasNodeSelector() {
        return this.nodeSelector != null;
    }

    public BuildOutput buildOutput() {
        return this.output != null ? this.output.build() : null;
    }

    public A withOutput(BuildOutput output) {
        this._visitables.remove((Object)"output");
        if (output != null) {
            this.output = new BuildOutputBuilder(output);
            this._visitables.get((Object)"output").add(this.output);
        } else {
            this.output = null;
            this._visitables.get((Object)"output").remove((Object)this.output);
        }
        return (A)((Object)this);
    }

    public boolean hasOutput() {
        return this.output != null;
    }

    public OutputNested<A> withNewOutput() {
        return new OutputNested(null);
    }

    public OutputNested<A> withNewOutputLike(BuildOutput item) {
        return new OutputNested(item);
    }

    public OutputNested<A> editOutput() {
        return this.withNewOutputLike(Optional.ofNullable(this.buildOutput()).orElse(null));
    }

    public OutputNested<A> editOrNewOutput() {
        return this.withNewOutputLike(Optional.ofNullable(this.buildOutput()).orElse(new BuildOutputBuilder().build()));
    }

    public OutputNested<A> editOrNewOutputLike(BuildOutput item) {
        return this.withNewOutputLike(Optional.ofNullable(this.buildOutput()).orElse(item));
    }

    public BuildPostCommitSpec buildPostCommit() {
        return this.postCommit != null ? this.postCommit.build() : null;
    }

    public A withPostCommit(BuildPostCommitSpec postCommit) {
        this._visitables.remove((Object)"postCommit");
        if (postCommit != null) {
            this.postCommit = new BuildPostCommitSpecBuilder(postCommit);
            this._visitables.get((Object)"postCommit").add(this.postCommit);
        } else {
            this.postCommit = null;
            this._visitables.get((Object)"postCommit").remove((Object)this.postCommit);
        }
        return (A)((Object)this);
    }

    public boolean hasPostCommit() {
        return this.postCommit != null;
    }

    public PostCommitNested<A> withNewPostCommit() {
        return new PostCommitNested(null);
    }

    public PostCommitNested<A> withNewPostCommitLike(BuildPostCommitSpec item) {
        return new PostCommitNested(item);
    }

    public PostCommitNested<A> editPostCommit() {
        return this.withNewPostCommitLike(Optional.ofNullable(this.buildPostCommit()).orElse(null));
    }

    public PostCommitNested<A> editOrNewPostCommit() {
        return this.withNewPostCommitLike(Optional.ofNullable(this.buildPostCommit()).orElse(new BuildPostCommitSpecBuilder().build()));
    }

    public PostCommitNested<A> editOrNewPostCommitLike(BuildPostCommitSpec item) {
        return this.withNewPostCommitLike(Optional.ofNullable(this.buildPostCommit()).orElse(item));
    }

    public ResourceRequirements buildResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    public A withResources(ResourceRequirements resources) {
        this._visitables.remove((Object)"resources");
        if (resources != null) {
            this.resources = new ResourceRequirementsBuilder(resources);
            this._visitables.get((Object)"resources").add(this.resources);
        } else {
            this.resources = null;
            this._visitables.get((Object)"resources").remove(this.resources);
        }
        return (A)((Object)this);
    }

    public boolean hasResources() {
        return this.resources != null;
    }

    public ResourcesNested<A> withNewResources() {
        return new ResourcesNested(null);
    }

    public ResourcesNested<A> withNewResourcesLike(ResourceRequirements item) {
        return new ResourcesNested(item);
    }

    public ResourcesNested<A> editResources() {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(null));
    }

    public ResourcesNested<A> editOrNewResources() {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(new ResourceRequirementsBuilder().build()));
    }

    public ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item) {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(item));
    }

    public SourceRevision buildRevision() {
        return this.revision != null ? this.revision.build() : null;
    }

    public A withRevision(SourceRevision revision) {
        this._visitables.remove((Object)"revision");
        if (revision != null) {
            this.revision = new SourceRevisionBuilder(revision);
            this._visitables.get((Object)"revision").add(this.revision);
        } else {
            this.revision = null;
            this._visitables.get((Object)"revision").remove((Object)this.revision);
        }
        return (A)((Object)this);
    }

    public boolean hasRevision() {
        return this.revision != null;
    }

    public RevisionNested<A> withNewRevision() {
        return new RevisionNested(null);
    }

    public RevisionNested<A> withNewRevisionLike(SourceRevision item) {
        return new RevisionNested(item);
    }

    public RevisionNested<A> editRevision() {
        return this.withNewRevisionLike(Optional.ofNullable(this.buildRevision()).orElse(null));
    }

    public RevisionNested<A> editOrNewRevision() {
        return this.withNewRevisionLike(Optional.ofNullable(this.buildRevision()).orElse(new SourceRevisionBuilder().build()));
    }

    public RevisionNested<A> editOrNewRevisionLike(SourceRevision item) {
        return this.withNewRevisionLike(Optional.ofNullable(this.buildRevision()).orElse(item));
    }

    public String getServiceAccount() {
        return this.serviceAccount;
    }

    public A withServiceAccount(String serviceAccount) {
        this.serviceAccount = serviceAccount;
        return (A)((Object)this);
    }

    public boolean hasServiceAccount() {
        return this.serviceAccount != null;
    }

    public BuildSource buildSource() {
        return this.source != null ? this.source.build() : null;
    }

    public A withSource(BuildSource source) {
        this._visitables.remove((Object)"source");
        if (source != null) {
            this.source = new BuildSourceBuilder(source);
            this._visitables.get((Object)"source").add(this.source);
        } else {
            this.source = null;
            this._visitables.get((Object)"source").remove((Object)this.source);
        }
        return (A)((Object)this);
    }

    public boolean hasSource() {
        return this.source != null;
    }

    public SourceNested<A> withNewSource() {
        return new SourceNested(null);
    }

    public SourceNested<A> withNewSourceLike(BuildSource item) {
        return new SourceNested(item);
    }

    public SourceNested<A> editSource() {
        return this.withNewSourceLike(Optional.ofNullable(this.buildSource()).orElse(null));
    }

    public SourceNested<A> editOrNewSource() {
        return this.withNewSourceLike(Optional.ofNullable(this.buildSource()).orElse(new BuildSourceBuilder().build()));
    }

    public SourceNested<A> editOrNewSourceLike(BuildSource item) {
        return this.withNewSourceLike(Optional.ofNullable(this.buildSource()).orElse(item));
    }

    public BuildStrategy buildStrategy() {
        return this.strategy != null ? this.strategy.build() : null;
    }

    public A withStrategy(BuildStrategy strategy) {
        this._visitables.remove((Object)"strategy");
        if (strategy != null) {
            this.strategy = new BuildStrategyBuilder(strategy);
            this._visitables.get((Object)"strategy").add(this.strategy);
        } else {
            this.strategy = null;
            this._visitables.get((Object)"strategy").remove((Object)this.strategy);
        }
        return (A)((Object)this);
    }

    public boolean hasStrategy() {
        return this.strategy != null;
    }

    public StrategyNested<A> withNewStrategy() {
        return new StrategyNested(null);
    }

    public StrategyNested<A> withNewStrategyLike(BuildStrategy item) {
        return new StrategyNested(item);
    }

    public StrategyNested<A> editStrategy() {
        return this.withNewStrategyLike(Optional.ofNullable(this.buildStrategy()).orElse(null));
    }

    public StrategyNested<A> editOrNewStrategy() {
        return this.withNewStrategyLike(Optional.ofNullable(this.buildStrategy()).orElse(new BuildStrategyBuilder().build()));
    }

    public StrategyNested<A> editOrNewStrategyLike(BuildStrategy item) {
        return this.withNewStrategyLike(Optional.ofNullable(this.buildStrategy()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CommonSpecFluent that = (CommonSpecFluent)((Object)o);
        if (!Objects.equals(this.completionDeadlineSeconds, that.completionDeadlineSeconds)) {
            return false;
        }
        if (!Objects.equals(this.mountTrustedCA, that.mountTrustedCA)) {
            return false;
        }
        if (!Objects.equals(this.nodeSelector, that.nodeSelector)) {
            return false;
        }
        if (!Objects.equals((Object)this.output, (Object)that.output)) {
            return false;
        }
        if (!Objects.equals((Object)this.postCommit, (Object)that.postCommit)) {
            return false;
        }
        if (!Objects.equals(this.resources, that.resources)) {
            return false;
        }
        if (!Objects.equals((Object)this.revision, (Object)that.revision)) {
            return false;
        }
        if (!Objects.equals(this.serviceAccount, that.serviceAccount)) {
            return false;
        }
        if (!Objects.equals((Object)this.source, (Object)that.source)) {
            return false;
        }
        if (!Objects.equals((Object)this.strategy, (Object)that.strategy)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.completionDeadlineSeconds, this.mountTrustedCA, this.nodeSelector, this.output, this.postCommit, this.resources, this.revision, this.serviceAccount, this.source, this.strategy, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.completionDeadlineSeconds != null) {
            sb.append("completionDeadlineSeconds:");
            sb.append(this.completionDeadlineSeconds + ",");
        }
        if (this.mountTrustedCA != null) {
            sb.append("mountTrustedCA:");
            sb.append(this.mountTrustedCA + ",");
        }
        if (this.nodeSelector != null && !this.nodeSelector.isEmpty()) {
            sb.append("nodeSelector:");
            sb.append(this.nodeSelector + ",");
        }
        if (this.output != null) {
            sb.append("output:");
            sb.append(this.output + ",");
        }
        if (this.postCommit != null) {
            sb.append("postCommit:");
            sb.append(this.postCommit + ",");
        }
        if (this.resources != null) {
            sb.append("resources:");
            sb.append(this.resources + ",");
        }
        if (this.revision != null) {
            sb.append("revision:");
            sb.append(this.revision + ",");
        }
        if (this.serviceAccount != null) {
            sb.append("serviceAccount:");
            sb.append(this.serviceAccount + ",");
        }
        if (this.source != null) {
            sb.append("source:");
            sb.append(this.source + ",");
        }
        if (this.strategy != null) {
            sb.append("strategy:");
            sb.append(this.strategy + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withMountTrustedCA() {
        return this.withMountTrustedCA(true);
    }

    public class StrategyNested<N>
    extends BuildStrategyFluent<StrategyNested<N>>
    implements Nested<N> {
        BuildStrategyBuilder builder;

        StrategyNested(BuildStrategy item) {
            this.builder = new BuildStrategyBuilder(this, item);
        }

        public N and() {
            return (N)CommonSpecFluent.this.withStrategy(this.builder.build());
        }

        public N endStrategy() {
            return this.and();
        }
    }

    public class SourceNested<N>
    extends BuildSourceFluent<SourceNested<N>>
    implements Nested<N> {
        BuildSourceBuilder builder;

        SourceNested(BuildSource item) {
            this.builder = new BuildSourceBuilder(this, item);
        }

        public N and() {
            return (N)CommonSpecFluent.this.withSource(this.builder.build());
        }

        public N endSource() {
            return this.and();
        }
    }

    public class RevisionNested<N>
    extends SourceRevisionFluent<RevisionNested<N>>
    implements Nested<N> {
        SourceRevisionBuilder builder;

        RevisionNested(SourceRevision item) {
            this.builder = new SourceRevisionBuilder(this, item);
        }

        public N and() {
            return (N)CommonSpecFluent.this.withRevision(this.builder.build());
        }

        public N endRevision() {
            return this.and();
        }
    }

    public class ResourcesNested<N>
    extends ResourceRequirementsFluent<ResourcesNested<N>>
    implements Nested<N> {
        ResourceRequirementsBuilder builder;

        ResourcesNested(ResourceRequirements item) {
            this.builder = new ResourceRequirementsBuilder((ResourceRequirementsFluent)this, item);
        }

        public N and() {
            return (N)CommonSpecFluent.this.withResources(this.builder.build());
        }

        public N endResources() {
            return this.and();
        }
    }

    public class PostCommitNested<N>
    extends BuildPostCommitSpecFluent<PostCommitNested<N>>
    implements Nested<N> {
        BuildPostCommitSpecBuilder builder;

        PostCommitNested(BuildPostCommitSpec item) {
            this.builder = new BuildPostCommitSpecBuilder(this, item);
        }

        public N and() {
            return (N)CommonSpecFluent.this.withPostCommit(this.builder.build());
        }

        public N endPostCommit() {
            return this.and();
        }
    }

    public class OutputNested<N>
    extends BuildOutputFluent<OutputNested<N>>
    implements Nested<N> {
        BuildOutputBuilder builder;

        OutputNested(BuildOutput item) {
            this.builder = new BuildOutputBuilder(this, item);
        }

        public N and() {
            return (N)CommonSpecFluent.this.withOutput(this.builder.build());
        }

        public N endOutput() {
            return this.and();
        }
    }
}

