package io.fabric8.openshift.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class WebHookTriggerFluent<A extends WebHookTriggerFluent<A>> extends BaseFluent<A>{
  public WebHookTriggerFluent() {
  }
  
  public WebHookTriggerFluent(WebHookTrigger instance) {
    this.copyInstance(instance);
  }
  private Boolean allowEnv;
  private String secret;
  private SecretLocalReferenceBuilder secretReference;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(WebHookTrigger instance) {
    instance = (instance != null ? instance : new WebHookTrigger());
    if (instance != null) {
          this.withAllowEnv(instance.getAllowEnv());
          this.withSecret(instance.getSecret());
          this.withSecretReference(instance.getSecretReference());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Boolean getAllowEnv() {
    return this.allowEnv;
  }
  
  public A withAllowEnv(Boolean allowEnv) {
    this.allowEnv = allowEnv;
    return (A) this;
  }
  
  public boolean hasAllowEnv() {
    return this.allowEnv != null;
  }
  
  public String getSecret() {
    return this.secret;
  }
  
  public A withSecret(String secret) {
    this.secret = secret;
    return (A) this;
  }
  
  public boolean hasSecret() {
    return this.secret != null;
  }
  
  public SecretLocalReference buildSecretReference() {
    return this.secretReference != null ? this.secretReference.build() : null;
  }
  
  public A withSecretReference(SecretLocalReference secretReference) {
    this._visitables.remove("secretReference");
    if (secretReference != null) {
        this.secretReference = new SecretLocalReferenceBuilder(secretReference);
        this._visitables.get("secretReference").add(this.secretReference);
    } else {
        this.secretReference = null;
        this._visitables.get("secretReference").remove(this.secretReference);
    }
    return (A) this;
  }
  
  public boolean hasSecretReference() {
    return this.secretReference != null;
  }
  
  public A withNewSecretReference(String name) {
    return (A)withSecretReference(new SecretLocalReference(name));
  }
  
  public SecretReferenceNested<A> withNewSecretReference() {
    return new SecretReferenceNested(null);
  }
  
  public SecretReferenceNested<A> withNewSecretReferenceLike(SecretLocalReference item) {
    return new SecretReferenceNested(item);
  }
  
  public SecretReferenceNested<A> editSecretReference() {
    return withNewSecretReferenceLike(java.util.Optional.ofNullable(buildSecretReference()).orElse(null));
  }
  
  public SecretReferenceNested<A> editOrNewSecretReference() {
    return withNewSecretReferenceLike(java.util.Optional.ofNullable(buildSecretReference()).orElse(new SecretLocalReferenceBuilder().build()));
  }
  
  public SecretReferenceNested<A> editOrNewSecretReferenceLike(SecretLocalReference item) {
    return withNewSecretReferenceLike(java.util.Optional.ofNullable(buildSecretReference()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    WebHookTriggerFluent that = (WebHookTriggerFluent) o;
    if (!java.util.Objects.equals(allowEnv, that.allowEnv)) return false;
    if (!java.util.Objects.equals(secret, that.secret)) return false;
    if (!java.util.Objects.equals(secretReference, that.secretReference)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(allowEnv,  secret,  secretReference,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (allowEnv != null) { sb.append("allowEnv:"); sb.append(allowEnv + ","); }
    if (secret != null) { sb.append("secret:"); sb.append(secret + ","); }
    if (secretReference != null) { sb.append("secretReference:"); sb.append(secretReference + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withAllowEnv() {
    return withAllowEnv(true);
  }
  public class SecretReferenceNested<N> extends SecretLocalReferenceFluent<SecretReferenceNested<N>> implements Nested<N>{
    SecretReferenceNested(SecretLocalReference item) {
      this.builder = new SecretLocalReferenceBuilder(this, item);
    }
    SecretLocalReferenceBuilder builder;
    
    public N and() {
      return (N) WebHookTriggerFluent.this.withSecretReference(builder.build());
    }
    
    public N endSecretReference() {
      return and();
    }
    
  
  }

}