package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ProxyConfigBuilder extends ProxyConfigFluent<ProxyConfigBuilder> implements VisitableBuilder<ProxyConfig,ProxyConfigBuilder>{
  public ProxyConfigBuilder() {
    this(new ProxyConfig());
  }
  
  public ProxyConfigBuilder(ProxyConfigFluent<?> fluent) {
    this(fluent, new ProxyConfig());
  }
  
  public ProxyConfigBuilder(ProxyConfigFluent<?> fluent,ProxyConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ProxyConfigBuilder(ProxyConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ProxyConfigFluent<?> fluent;
  
  public ProxyConfig build() {
    ProxyConfig buildable = new ProxyConfig(fluent.getHttpProxy(),fluent.getHttpsProxy(),fluent.getNoProxy());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}