package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ParameterBuilder extends ParameterFluent<ParameterBuilder> implements VisitableBuilder<Parameter,ParameterBuilder>{
  public ParameterBuilder() {
    this(new Parameter());
  }
  
  public ParameterBuilder(ParameterFluent<?> fluent) {
    this(fluent, new Parameter());
  }
  
  public ParameterBuilder(ParameterFluent<?> fluent,Parameter instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ParameterBuilder(Parameter instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ParameterFluent<?> fluent;
  
  public Parameter build() {
    Parameter buildable = new Parameter(fluent.getDescription(),fluent.getDisplayName(),fluent.getFrom(),fluent.getGenerate(),fluent.getName(),fluent.getRequired(),fluent.getValue());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}