package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class NamedRoleBindingBuilder extends NamedRoleBindingFluent<NamedRoleBindingBuilder> implements VisitableBuilder<NamedRoleBinding,NamedRoleBindingBuilder>{
  public NamedRoleBindingBuilder() {
    this(new NamedRoleBinding());
  }
  
  public NamedRoleBindingBuilder(NamedRoleBindingFluent<?> fluent) {
    this(fluent, new NamedRoleBinding());
  }
  
  public NamedRoleBindingBuilder(NamedRoleBindingFluent<?> fluent,NamedRoleBinding instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public NamedRoleBindingBuilder(NamedRoleBinding instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  NamedRoleBindingFluent<?> fluent;
  
  public NamedRoleBinding build() {
    NamedRoleBinding buildable = new NamedRoleBinding(fluent.getName(),fluent.buildRoleBinding());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}