package io.fabric8.openshift.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class NamedClusterRoleFluent<A extends NamedClusterRoleFluent<A>> extends BaseFluent<A>{
  public NamedClusterRoleFluent() {
  }
  
  public NamedClusterRoleFluent(NamedClusterRole instance) {
    this.copyInstance(instance);
  }
  private String name;
  private ClusterRoleBuilder role;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(NamedClusterRole instance) {
    instance = (instance != null ? instance : new NamedClusterRole());
    if (instance != null) {
          this.withName(instance.getName());
          this.withRole(instance.getRole());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public ClusterRole buildRole() {
    return this.role != null ? this.role.build() : null;
  }
  
  public A withRole(ClusterRole role) {
    this._visitables.remove("role");
    if (role != null) {
        this.role = new ClusterRoleBuilder(role);
        this._visitables.get("role").add(this.role);
    } else {
        this.role = null;
        this._visitables.get("role").remove(this.role);
    }
    return (A) this;
  }
  
  public boolean hasRole() {
    return this.role != null;
  }
  
  public RoleNested<A> withNewRole() {
    return new RoleNested(null);
  }
  
  public RoleNested<A> withNewRoleLike(ClusterRole item) {
    return new RoleNested(item);
  }
  
  public RoleNested<A> editRole() {
    return withNewRoleLike(java.util.Optional.ofNullable(buildRole()).orElse(null));
  }
  
  public RoleNested<A> editOrNewRole() {
    return withNewRoleLike(java.util.Optional.ofNullable(buildRole()).orElse(new ClusterRoleBuilder().build()));
  }
  
  public RoleNested<A> editOrNewRoleLike(ClusterRole item) {
    return withNewRoleLike(java.util.Optional.ofNullable(buildRole()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NamedClusterRoleFluent that = (NamedClusterRoleFluent) o;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(role, that.role)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(name,  role,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (role != null) { sb.append("role:"); sb.append(role + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class RoleNested<N> extends ClusterRoleFluent<RoleNested<N>> implements Nested<N>{
    RoleNested(ClusterRole item) {
      this.builder = new ClusterRoleBuilder(this, item);
    }
    ClusterRoleBuilder builder;
    
    public N and() {
      return (N) NamedClusterRoleFluent.this.withRole(builder.build());
    }
    
    public N endRole() {
      return and();
    }
    
  
  }

}