package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ImageChangeCauseBuilder extends ImageChangeCauseFluent<ImageChangeCauseBuilder> implements VisitableBuilder<ImageChangeCause,ImageChangeCauseBuilder>{
  public ImageChangeCauseBuilder() {
    this(new ImageChangeCause());
  }
  
  public ImageChangeCauseBuilder(ImageChangeCauseFluent<?> fluent) {
    this(fluent, new ImageChangeCause());
  }
  
  public ImageChangeCauseBuilder(ImageChangeCauseFluent<?> fluent,ImageChangeCause instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ImageChangeCauseBuilder(ImageChangeCause instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ImageChangeCauseFluent<?> fluent;
  
  public ImageChangeCause build() {
    ImageChangeCause buildable = new ImageChangeCause(fluent.buildFromRef(),fluent.getImageID());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}