package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.EnvVar;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.EnvVarFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.util.Iterator;
import io.fabric8.kubernetes.api.model.ObjectMeta;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class BuildRequestFluent<A extends BuildRequestFluent<A>> extends BaseFluent<A>{
  public BuildRequestFluent() {
  }
  
  public BuildRequestFluent(BuildRequest instance) {
    this.copyInstance(instance);
  }
  private String apiVersion;
  private BinaryBuildSourceBuilder binary;
  private DockerStrategyOptionsBuilder dockerStrategyOptions;
  private ArrayList<EnvVarBuilder> env = new ArrayList<EnvVarBuilder>();
  private ObjectReferenceBuilder from;
  private String kind;
  private Long lastVersion;
  private ObjectMetaBuilder metadata;
  private SourceRevisionBuilder revision;
  private SourceStrategyOptionsBuilder sourceStrategyOptions;
  private ArrayList<BuildTriggerCauseBuilder> triggeredBy = new ArrayList<BuildTriggerCauseBuilder>();
  private ObjectReferenceBuilder triggeredByImage;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(BuildRequest instance) {
    instance = (instance != null ? instance : new BuildRequest());
    if (instance != null) {
          this.withApiVersion(instance.getApiVersion());
          this.withBinary(instance.getBinary());
          this.withDockerStrategyOptions(instance.getDockerStrategyOptions());
          this.withEnv(instance.getEnv());
          this.withFrom(instance.getFrom());
          this.withKind(instance.getKind());
          this.withLastVersion(instance.getLastVersion());
          this.withMetadata(instance.getMetadata());
          this.withRevision(instance.getRevision());
          this.withSourceStrategyOptions(instance.getSourceStrategyOptions());
          this.withTriggeredBy(instance.getTriggeredBy());
          this.withTriggeredByImage(instance.getTriggeredByImage());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getApiVersion() {
    return this.apiVersion;
  }
  
  public A withApiVersion(String apiVersion) {
    this.apiVersion = apiVersion;
    return (A) this;
  }
  
  public boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  public BinaryBuildSource buildBinary() {
    return this.binary != null ? this.binary.build() : null;
  }
  
  public A withBinary(BinaryBuildSource binary) {
    this._visitables.remove("binary");
    if (binary != null) {
        this.binary = new BinaryBuildSourceBuilder(binary);
        this._visitables.get("binary").add(this.binary);
    } else {
        this.binary = null;
        this._visitables.get("binary").remove(this.binary);
    }
    return (A) this;
  }
  
  public boolean hasBinary() {
    return this.binary != null;
  }
  
  public A withNewBinary(String asFile) {
    return (A)withBinary(new BinaryBuildSource(asFile));
  }
  
  public BinaryNested<A> withNewBinary() {
    return new BinaryNested(null);
  }
  
  public BinaryNested<A> withNewBinaryLike(BinaryBuildSource item) {
    return new BinaryNested(item);
  }
  
  public BinaryNested<A> editBinary() {
    return withNewBinaryLike(java.util.Optional.ofNullable(buildBinary()).orElse(null));
  }
  
  public BinaryNested<A> editOrNewBinary() {
    return withNewBinaryLike(java.util.Optional.ofNullable(buildBinary()).orElse(new BinaryBuildSourceBuilder().build()));
  }
  
  public BinaryNested<A> editOrNewBinaryLike(BinaryBuildSource item) {
    return withNewBinaryLike(java.util.Optional.ofNullable(buildBinary()).orElse(item));
  }
  
  public DockerStrategyOptions buildDockerStrategyOptions() {
    return this.dockerStrategyOptions != null ? this.dockerStrategyOptions.build() : null;
  }
  
  public A withDockerStrategyOptions(DockerStrategyOptions dockerStrategyOptions) {
    this._visitables.remove("dockerStrategyOptions");
    if (dockerStrategyOptions != null) {
        this.dockerStrategyOptions = new DockerStrategyOptionsBuilder(dockerStrategyOptions);
        this._visitables.get("dockerStrategyOptions").add(this.dockerStrategyOptions);
    } else {
        this.dockerStrategyOptions = null;
        this._visitables.get("dockerStrategyOptions").remove(this.dockerStrategyOptions);
    }
    return (A) this;
  }
  
  public boolean hasDockerStrategyOptions() {
    return this.dockerStrategyOptions != null;
  }
  
  public DockerStrategyOptionsNested<A> withNewDockerStrategyOptions() {
    return new DockerStrategyOptionsNested(null);
  }
  
  public DockerStrategyOptionsNested<A> withNewDockerStrategyOptionsLike(DockerStrategyOptions item) {
    return new DockerStrategyOptionsNested(item);
  }
  
  public DockerStrategyOptionsNested<A> editDockerStrategyOptions() {
    return withNewDockerStrategyOptionsLike(java.util.Optional.ofNullable(buildDockerStrategyOptions()).orElse(null));
  }
  
  public DockerStrategyOptionsNested<A> editOrNewDockerStrategyOptions() {
    return withNewDockerStrategyOptionsLike(java.util.Optional.ofNullable(buildDockerStrategyOptions()).orElse(new DockerStrategyOptionsBuilder().build()));
  }
  
  public DockerStrategyOptionsNested<A> editOrNewDockerStrategyOptionsLike(DockerStrategyOptions item) {
    return withNewDockerStrategyOptionsLike(java.util.Optional.ofNullable(buildDockerStrategyOptions()).orElse(item));
  }
  
  public A addToEnv(int index,EnvVar item) {
    if (this.env == null) {this.env = new ArrayList<EnvVarBuilder>();}
    EnvVarBuilder builder = new EnvVarBuilder(item);
    if (index < 0 || index >= env.size()) { _visitables.get("env").add(builder); env.add(builder); } else { _visitables.get("env").add(index, builder); env.add(index, builder);}
    return (A)this;
  }
  
  public A setToEnv(int index,EnvVar item) {
    if (this.env == null) {this.env = new ArrayList<EnvVarBuilder>();}
    EnvVarBuilder builder = new EnvVarBuilder(item);
    if (index < 0 || index >= env.size()) { _visitables.get("env").add(builder); env.add(builder); } else { _visitables.get("env").set(index, builder); env.set(index, builder);}
    return (A)this;
  }
  
  public A addToEnv(io.fabric8.kubernetes.api.model.EnvVar... items) {
    if (this.env == null) {this.env = new ArrayList<EnvVarBuilder>();}
    for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.get("env").add(builder);this.env.add(builder);} return (A)this;
  }
  
  public A addAllToEnv(Collection<EnvVar> items) {
    if (this.env == null) {this.env = new ArrayList<EnvVarBuilder>();}
    for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.get("env").add(builder);this.env.add(builder);} return (A)this;
  }
  
  public A removeFromEnv(io.fabric8.kubernetes.api.model.EnvVar... items) {
    if (this.env == null) return (A)this;
    for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.get("env").remove(builder); this.env.remove(builder);} return (A)this;
  }
  
  public A removeAllFromEnv(Collection<EnvVar> items) {
    if (this.env == null) return (A)this;
    for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.get("env").remove(builder); this.env.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromEnv(Predicate<EnvVarBuilder> predicate) {
    if (env == null) return (A) this;
    final Iterator<EnvVarBuilder> each = env.iterator();
    final List visitables = _visitables.get("env");
    while (each.hasNext()) {
      EnvVarBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<EnvVar> buildEnv() {
    return this.env != null ? build(env) : null;
  }
  
  public EnvVar buildEnv(int index) {
    return this.env.get(index).build();
  }
  
  public EnvVar buildFirstEnv() {
    return this.env.get(0).build();
  }
  
  public EnvVar buildLastEnv() {
    return this.env.get(env.size() - 1).build();
  }
  
  public EnvVar buildMatchingEnv(Predicate<EnvVarBuilder> predicate) {
      for (EnvVarBuilder item : env) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingEnv(Predicate<EnvVarBuilder> predicate) {
      for (EnvVarBuilder item : env) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withEnv(List<EnvVar> env) {
    if (this.env != null) {
      this._visitables.get("env").clear();
    }
    if (env != null) {
        this.env = new ArrayList();
        for (EnvVar item : env) {
          this.addToEnv(item);
        }
    } else {
      this.env = null;
    }
    return (A) this;
  }
  
  public A withEnv(io.fabric8.kubernetes.api.model.EnvVar... env) {
    if (this.env != null) {
        this.env.clear();
        _visitables.remove("env");
    }
    if (env != null) {
      for (EnvVar item : env) {
        this.addToEnv(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasEnv() {
    return this.env != null && !this.env.isEmpty();
  }
  
  public EnvNested<A> addNewEnv() {
    return new EnvNested(-1, null);
  }
  
  public EnvNested<A> addNewEnvLike(EnvVar item) {
    return new EnvNested(-1, item);
  }
  
  public EnvNested<A> setNewEnvLike(int index,EnvVar item) {
    return new EnvNested(index, item);
  }
  
  public EnvNested<A> editEnv(int index) {
    if (env.size() <= index) throw new RuntimeException("Can't edit env. Index exceeds size.");
    return setNewEnvLike(index, buildEnv(index));
  }
  
  public EnvNested<A> editFirstEnv() {
    if (env.size() == 0) throw new RuntimeException("Can't edit first env. The list is empty.");
    return setNewEnvLike(0, buildEnv(0));
  }
  
  public EnvNested<A> editLastEnv() {
    int index = env.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last env. The list is empty.");
    return setNewEnvLike(index, buildEnv(index));
  }
  
  public EnvNested<A> editMatchingEnv(Predicate<EnvVarBuilder> predicate) {
    int index = -1;
    for (int i=0;i<env.size();i++) { 
    if (predicate.test(env.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching env. No match found.");
    return setNewEnvLike(index, buildEnv(index));
  }
  
  public ObjectReference buildFrom() {
    return this.from != null ? this.from.build() : null;
  }
  
  public A withFrom(ObjectReference from) {
    this._visitables.remove("from");
    if (from != null) {
        this.from = new ObjectReferenceBuilder(from);
        this._visitables.get("from").add(this.from);
    } else {
        this.from = null;
        this._visitables.get("from").remove(this.from);
    }
    return (A) this;
  }
  
  public boolean hasFrom() {
    return this.from != null;
  }
  
  public FromNested<A> withNewFrom() {
    return new FromNested(null);
  }
  
  public FromNested<A> withNewFromLike(ObjectReference item) {
    return new FromNested(item);
  }
  
  public FromNested<A> editFrom() {
    return withNewFromLike(java.util.Optional.ofNullable(buildFrom()).orElse(null));
  }
  
  public FromNested<A> editOrNewFrom() {
    return withNewFromLike(java.util.Optional.ofNullable(buildFrom()).orElse(new ObjectReferenceBuilder().build()));
  }
  
  public FromNested<A> editOrNewFromLike(ObjectReference item) {
    return withNewFromLike(java.util.Optional.ofNullable(buildFrom()).orElse(item));
  }
  
  public String getKind() {
    return this.kind;
  }
  
  public A withKind(String kind) {
    this.kind = kind;
    return (A) this;
  }
  
  public boolean hasKind() {
    return this.kind != null;
  }
  
  public Long getLastVersion() {
    return this.lastVersion;
  }
  
  public A withLastVersion(Long lastVersion) {
    this.lastVersion = lastVersion;
    return (A) this;
  }
  
  public boolean hasLastVersion() {
    return this.lastVersion != null;
  }
  
  public ObjectMeta buildMetadata() {
    return this.metadata != null ? this.metadata.build() : null;
  }
  
  public A withMetadata(ObjectMeta metadata) {
    this._visitables.remove("metadata");
    if (metadata != null) {
        this.metadata = new ObjectMetaBuilder(metadata);
        this._visitables.get("metadata").add(this.metadata);
    } else {
        this.metadata = null;
        this._visitables.get("metadata").remove(this.metadata);
    }
    return (A) this;
  }
  
  public boolean hasMetadata() {
    return this.metadata != null;
  }
  
  public MetadataNested<A> withNewMetadata() {
    return new MetadataNested(null);
  }
  
  public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new MetadataNested(item);
  }
  
  public MetadataNested<A> editMetadata() {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(null));
  }
  
  public MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(new ObjectMetaBuilder().build()));
  }
  
  public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(item));
  }
  
  public SourceRevision buildRevision() {
    return this.revision != null ? this.revision.build() : null;
  }
  
  public A withRevision(SourceRevision revision) {
    this._visitables.remove("revision");
    if (revision != null) {
        this.revision = new SourceRevisionBuilder(revision);
        this._visitables.get("revision").add(this.revision);
    } else {
        this.revision = null;
        this._visitables.get("revision").remove(this.revision);
    }
    return (A) this;
  }
  
  public boolean hasRevision() {
    return this.revision != null;
  }
  
  public RevisionNested<A> withNewRevision() {
    return new RevisionNested(null);
  }
  
  public RevisionNested<A> withNewRevisionLike(SourceRevision item) {
    return new RevisionNested(item);
  }
  
  public RevisionNested<A> editRevision() {
    return withNewRevisionLike(java.util.Optional.ofNullable(buildRevision()).orElse(null));
  }
  
  public RevisionNested<A> editOrNewRevision() {
    return withNewRevisionLike(java.util.Optional.ofNullable(buildRevision()).orElse(new SourceRevisionBuilder().build()));
  }
  
  public RevisionNested<A> editOrNewRevisionLike(SourceRevision item) {
    return withNewRevisionLike(java.util.Optional.ofNullable(buildRevision()).orElse(item));
  }
  
  public SourceStrategyOptions buildSourceStrategyOptions() {
    return this.sourceStrategyOptions != null ? this.sourceStrategyOptions.build() : null;
  }
  
  public A withSourceStrategyOptions(SourceStrategyOptions sourceStrategyOptions) {
    this._visitables.remove("sourceStrategyOptions");
    if (sourceStrategyOptions != null) {
        this.sourceStrategyOptions = new SourceStrategyOptionsBuilder(sourceStrategyOptions);
        this._visitables.get("sourceStrategyOptions").add(this.sourceStrategyOptions);
    } else {
        this.sourceStrategyOptions = null;
        this._visitables.get("sourceStrategyOptions").remove(this.sourceStrategyOptions);
    }
    return (A) this;
  }
  
  public boolean hasSourceStrategyOptions() {
    return this.sourceStrategyOptions != null;
  }
  
  public A withNewSourceStrategyOptions(Boolean incremental) {
    return (A)withSourceStrategyOptions(new SourceStrategyOptions(incremental));
  }
  
  public SourceStrategyOptionsNested<A> withNewSourceStrategyOptions() {
    return new SourceStrategyOptionsNested(null);
  }
  
  public SourceStrategyOptionsNested<A> withNewSourceStrategyOptionsLike(SourceStrategyOptions item) {
    return new SourceStrategyOptionsNested(item);
  }
  
  public SourceStrategyOptionsNested<A> editSourceStrategyOptions() {
    return withNewSourceStrategyOptionsLike(java.util.Optional.ofNullable(buildSourceStrategyOptions()).orElse(null));
  }
  
  public SourceStrategyOptionsNested<A> editOrNewSourceStrategyOptions() {
    return withNewSourceStrategyOptionsLike(java.util.Optional.ofNullable(buildSourceStrategyOptions()).orElse(new SourceStrategyOptionsBuilder().build()));
  }
  
  public SourceStrategyOptionsNested<A> editOrNewSourceStrategyOptionsLike(SourceStrategyOptions item) {
    return withNewSourceStrategyOptionsLike(java.util.Optional.ofNullable(buildSourceStrategyOptions()).orElse(item));
  }
  
  public A addToTriggeredBy(int index,BuildTriggerCause item) {
    if (this.triggeredBy == null) {this.triggeredBy = new ArrayList<BuildTriggerCauseBuilder>();}
    BuildTriggerCauseBuilder builder = new BuildTriggerCauseBuilder(item);
    if (index < 0 || index >= triggeredBy.size()) { _visitables.get("triggeredBy").add(builder); triggeredBy.add(builder); } else { _visitables.get("triggeredBy").add(index, builder); triggeredBy.add(index, builder);}
    return (A)this;
  }
  
  public A setToTriggeredBy(int index,BuildTriggerCause item) {
    if (this.triggeredBy == null) {this.triggeredBy = new ArrayList<BuildTriggerCauseBuilder>();}
    BuildTriggerCauseBuilder builder = new BuildTriggerCauseBuilder(item);
    if (index < 0 || index >= triggeredBy.size()) { _visitables.get("triggeredBy").add(builder); triggeredBy.add(builder); } else { _visitables.get("triggeredBy").set(index, builder); triggeredBy.set(index, builder);}
    return (A)this;
  }
  
  public A addToTriggeredBy(io.fabric8.openshift.api.model.BuildTriggerCause... items) {
    if (this.triggeredBy == null) {this.triggeredBy = new ArrayList<BuildTriggerCauseBuilder>();}
    for (BuildTriggerCause item : items) {BuildTriggerCauseBuilder builder = new BuildTriggerCauseBuilder(item);_visitables.get("triggeredBy").add(builder);this.triggeredBy.add(builder);} return (A)this;
  }
  
  public A addAllToTriggeredBy(Collection<BuildTriggerCause> items) {
    if (this.triggeredBy == null) {this.triggeredBy = new ArrayList<BuildTriggerCauseBuilder>();}
    for (BuildTriggerCause item : items) {BuildTriggerCauseBuilder builder = new BuildTriggerCauseBuilder(item);_visitables.get("triggeredBy").add(builder);this.triggeredBy.add(builder);} return (A)this;
  }
  
  public A removeFromTriggeredBy(io.fabric8.openshift.api.model.BuildTriggerCause... items) {
    if (this.triggeredBy == null) return (A)this;
    for (BuildTriggerCause item : items) {BuildTriggerCauseBuilder builder = new BuildTriggerCauseBuilder(item);_visitables.get("triggeredBy").remove(builder); this.triggeredBy.remove(builder);} return (A)this;
  }
  
  public A removeAllFromTriggeredBy(Collection<BuildTriggerCause> items) {
    if (this.triggeredBy == null) return (A)this;
    for (BuildTriggerCause item : items) {BuildTriggerCauseBuilder builder = new BuildTriggerCauseBuilder(item);_visitables.get("triggeredBy").remove(builder); this.triggeredBy.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromTriggeredBy(Predicate<BuildTriggerCauseBuilder> predicate) {
    if (triggeredBy == null) return (A) this;
    final Iterator<BuildTriggerCauseBuilder> each = triggeredBy.iterator();
    final List visitables = _visitables.get("triggeredBy");
    while (each.hasNext()) {
      BuildTriggerCauseBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<BuildTriggerCause> buildTriggeredBy() {
    return this.triggeredBy != null ? build(triggeredBy) : null;
  }
  
  public BuildTriggerCause buildTriggeredBy(int index) {
    return this.triggeredBy.get(index).build();
  }
  
  public BuildTriggerCause buildFirstTriggeredBy() {
    return this.triggeredBy.get(0).build();
  }
  
  public BuildTriggerCause buildLastTriggeredBy() {
    return this.triggeredBy.get(triggeredBy.size() - 1).build();
  }
  
  public BuildTriggerCause buildMatchingTriggeredBy(Predicate<BuildTriggerCauseBuilder> predicate) {
      for (BuildTriggerCauseBuilder item : triggeredBy) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingTriggeredBy(Predicate<BuildTriggerCauseBuilder> predicate) {
      for (BuildTriggerCauseBuilder item : triggeredBy) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withTriggeredBy(List<BuildTriggerCause> triggeredBy) {
    if (this.triggeredBy != null) {
      this._visitables.get("triggeredBy").clear();
    }
    if (triggeredBy != null) {
        this.triggeredBy = new ArrayList();
        for (BuildTriggerCause item : triggeredBy) {
          this.addToTriggeredBy(item);
        }
    } else {
      this.triggeredBy = null;
    }
    return (A) this;
  }
  
  public A withTriggeredBy(io.fabric8.openshift.api.model.BuildTriggerCause... triggeredBy) {
    if (this.triggeredBy != null) {
        this.triggeredBy.clear();
        _visitables.remove("triggeredBy");
    }
    if (triggeredBy != null) {
      for (BuildTriggerCause item : triggeredBy) {
        this.addToTriggeredBy(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasTriggeredBy() {
    return this.triggeredBy != null && !this.triggeredBy.isEmpty();
  }
  
  public TriggeredByNested<A> addNewTriggeredBy() {
    return new TriggeredByNested(-1, null);
  }
  
  public TriggeredByNested<A> addNewTriggeredByLike(BuildTriggerCause item) {
    return new TriggeredByNested(-1, item);
  }
  
  public TriggeredByNested<A> setNewTriggeredByLike(int index,BuildTriggerCause item) {
    return new TriggeredByNested(index, item);
  }
  
  public TriggeredByNested<A> editTriggeredBy(int index) {
    if (triggeredBy.size() <= index) throw new RuntimeException("Can't edit triggeredBy. Index exceeds size.");
    return setNewTriggeredByLike(index, buildTriggeredBy(index));
  }
  
  public TriggeredByNested<A> editFirstTriggeredBy() {
    if (triggeredBy.size() == 0) throw new RuntimeException("Can't edit first triggeredBy. The list is empty.");
    return setNewTriggeredByLike(0, buildTriggeredBy(0));
  }
  
  public TriggeredByNested<A> editLastTriggeredBy() {
    int index = triggeredBy.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last triggeredBy. The list is empty.");
    return setNewTriggeredByLike(index, buildTriggeredBy(index));
  }
  
  public TriggeredByNested<A> editMatchingTriggeredBy(Predicate<BuildTriggerCauseBuilder> predicate) {
    int index = -1;
    for (int i=0;i<triggeredBy.size();i++) { 
    if (predicate.test(triggeredBy.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching triggeredBy. No match found.");
    return setNewTriggeredByLike(index, buildTriggeredBy(index));
  }
  
  public ObjectReference buildTriggeredByImage() {
    return this.triggeredByImage != null ? this.triggeredByImage.build() : null;
  }
  
  public A withTriggeredByImage(ObjectReference triggeredByImage) {
    this._visitables.remove("triggeredByImage");
    if (triggeredByImage != null) {
        this.triggeredByImage = new ObjectReferenceBuilder(triggeredByImage);
        this._visitables.get("triggeredByImage").add(this.triggeredByImage);
    } else {
        this.triggeredByImage = null;
        this._visitables.get("triggeredByImage").remove(this.triggeredByImage);
    }
    return (A) this;
  }
  
  public boolean hasTriggeredByImage() {
    return this.triggeredByImage != null;
  }
  
  public TriggeredByImageNested<A> withNewTriggeredByImage() {
    return new TriggeredByImageNested(null);
  }
  
  public TriggeredByImageNested<A> withNewTriggeredByImageLike(ObjectReference item) {
    return new TriggeredByImageNested(item);
  }
  
  public TriggeredByImageNested<A> editTriggeredByImage() {
    return withNewTriggeredByImageLike(java.util.Optional.ofNullable(buildTriggeredByImage()).orElse(null));
  }
  
  public TriggeredByImageNested<A> editOrNewTriggeredByImage() {
    return withNewTriggeredByImageLike(java.util.Optional.ofNullable(buildTriggeredByImage()).orElse(new ObjectReferenceBuilder().build()));
  }
  
  public TriggeredByImageNested<A> editOrNewTriggeredByImageLike(ObjectReference item) {
    return withNewTriggeredByImageLike(java.util.Optional.ofNullable(buildTriggeredByImage()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    BuildRequestFluent that = (BuildRequestFluent) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;
    if (!java.util.Objects.equals(binary, that.binary)) return false;
    if (!java.util.Objects.equals(dockerStrategyOptions, that.dockerStrategyOptions)) return false;
    if (!java.util.Objects.equals(env, that.env)) return false;
    if (!java.util.Objects.equals(from, that.from)) return false;
    if (!java.util.Objects.equals(kind, that.kind)) return false;
    if (!java.util.Objects.equals(lastVersion, that.lastVersion)) return false;
    if (!java.util.Objects.equals(metadata, that.metadata)) return false;
    if (!java.util.Objects.equals(revision, that.revision)) return false;
    if (!java.util.Objects.equals(sourceStrategyOptions, that.sourceStrategyOptions)) return false;
    if (!java.util.Objects.equals(triggeredBy, that.triggeredBy)) return false;
    if (!java.util.Objects.equals(triggeredByImage, that.triggeredByImage)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  binary,  dockerStrategyOptions,  env,  from,  kind,  lastVersion,  metadata,  revision,  sourceStrategyOptions,  triggeredBy,  triggeredByImage,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (binary != null) { sb.append("binary:"); sb.append(binary + ","); }
    if (dockerStrategyOptions != null) { sb.append("dockerStrategyOptions:"); sb.append(dockerStrategyOptions + ","); }
    if (env != null && !env.isEmpty()) { sb.append("env:"); sb.append(env + ","); }
    if (from != null) { sb.append("from:"); sb.append(from + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (lastVersion != null) { sb.append("lastVersion:"); sb.append(lastVersion + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (revision != null) { sb.append("revision:"); sb.append(revision + ","); }
    if (sourceStrategyOptions != null) { sb.append("sourceStrategyOptions:"); sb.append(sourceStrategyOptions + ","); }
    if (triggeredBy != null && !triggeredBy.isEmpty()) { sb.append("triggeredBy:"); sb.append(triggeredBy + ","); }
    if (triggeredByImage != null) { sb.append("triggeredByImage:"); sb.append(triggeredByImage + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class BinaryNested<N> extends BinaryBuildSourceFluent<BinaryNested<N>> implements Nested<N>{
    BinaryNested(BinaryBuildSource item) {
      this.builder = new BinaryBuildSourceBuilder(this, item);
    }
    BinaryBuildSourceBuilder builder;
    
    public N and() {
      return (N) BuildRequestFluent.this.withBinary(builder.build());
    }
    
    public N endBinary() {
      return and();
    }
    
  
  }
  public class DockerStrategyOptionsNested<N> extends DockerStrategyOptionsFluent<DockerStrategyOptionsNested<N>> implements Nested<N>{
    DockerStrategyOptionsNested(DockerStrategyOptions item) {
      this.builder = new DockerStrategyOptionsBuilder(this, item);
    }
    DockerStrategyOptionsBuilder builder;
    
    public N and() {
      return (N) BuildRequestFluent.this.withDockerStrategyOptions(builder.build());
    }
    
    public N endDockerStrategyOptions() {
      return and();
    }
    
  
  }
  public class EnvNested<N> extends EnvVarFluent<EnvNested<N>> implements Nested<N>{
    EnvNested(int index,EnvVar item) {
      this.index = index;
      this.builder = new EnvVarBuilder(this, item);
    }
    EnvVarBuilder builder;
    int index;
    
    public N and() {
      return (N) BuildRequestFluent.this.setToEnv(index,builder.build());
    }
    
    public N endEnv() {
      return and();
    }
    
  
  }
  public class FromNested<N> extends ObjectReferenceFluent<FromNested<N>> implements Nested<N>{
    FromNested(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    
    public N and() {
      return (N) BuildRequestFluent.this.withFrom(builder.build());
    }
    
    public N endFrom() {
      return and();
    }
    
  
  }
  public class MetadataNested<N> extends ObjectMetaFluent<MetadataNested<N>> implements Nested<N>{
    MetadataNested(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    ObjectMetaBuilder builder;
    
    public N and() {
      return (N) BuildRequestFluent.this.withMetadata(builder.build());
    }
    
    public N endMetadata() {
      return and();
    }
    
  
  }
  public class RevisionNested<N> extends SourceRevisionFluent<RevisionNested<N>> implements Nested<N>{
    RevisionNested(SourceRevision item) {
      this.builder = new SourceRevisionBuilder(this, item);
    }
    SourceRevisionBuilder builder;
    
    public N and() {
      return (N) BuildRequestFluent.this.withRevision(builder.build());
    }
    
    public N endRevision() {
      return and();
    }
    
  
  }
  public class SourceStrategyOptionsNested<N> extends SourceStrategyOptionsFluent<SourceStrategyOptionsNested<N>> implements Nested<N>{
    SourceStrategyOptionsNested(SourceStrategyOptions item) {
      this.builder = new SourceStrategyOptionsBuilder(this, item);
    }
    SourceStrategyOptionsBuilder builder;
    
    public N and() {
      return (N) BuildRequestFluent.this.withSourceStrategyOptions(builder.build());
    }
    
    public N endSourceStrategyOptions() {
      return and();
    }
    
  
  }
  public class TriggeredByNested<N> extends BuildTriggerCauseFluent<TriggeredByNested<N>> implements Nested<N>{
    TriggeredByNested(int index,BuildTriggerCause item) {
      this.index = index;
      this.builder = new BuildTriggerCauseBuilder(this, item);
    }
    BuildTriggerCauseBuilder builder;
    int index;
    
    public N and() {
      return (N) BuildRequestFluent.this.setToTriggeredBy(index,builder.build());
    }
    
    public N endTriggeredBy() {
      return and();
    }
    
  
  }
  public class TriggeredByImageNested<N> extends ObjectReferenceFluent<TriggeredByImageNested<N>> implements Nested<N>{
    TriggeredByImageNested(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    
    public N and() {
      return (N) BuildRequestFluent.this.withTriggeredByImage(builder.build());
    }
    
    public N endTriggeredByImage() {
      return and();
    }
    
  
  }

}