package io.fabric8.openshift.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class BuildLogOptionsFluent<A extends BuildLogOptionsFluent<A>> extends BaseFluent<A>{
  public BuildLogOptionsFluent() {
  }
  
  public BuildLogOptionsFluent(BuildLogOptions instance) {
    this.copyInstance(instance);
  }
  private String apiVersion;
  private String container;
  private Boolean follow;
  private Boolean insecureSkipTLSVerifyBackend;
  private String kind;
  private Long limitBytes;
  private Boolean nowait;
  private Boolean previous;
  private Long sinceSeconds;
  private String sinceTime;
  private Long tailLines;
  private Boolean timestamps;
  private Long version;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(BuildLogOptions instance) {
    instance = (instance != null ? instance : new BuildLogOptions());
    if (instance != null) {
          this.withApiVersion(instance.getApiVersion());
          this.withContainer(instance.getContainer());
          this.withFollow(instance.getFollow());
          this.withInsecureSkipTLSVerifyBackend(instance.getInsecureSkipTLSVerifyBackend());
          this.withKind(instance.getKind());
          this.withLimitBytes(instance.getLimitBytes());
          this.withNowait(instance.getNowait());
          this.withPrevious(instance.getPrevious());
          this.withSinceSeconds(instance.getSinceSeconds());
          this.withSinceTime(instance.getSinceTime());
          this.withTailLines(instance.getTailLines());
          this.withTimestamps(instance.getTimestamps());
          this.withVersion(instance.getVersion());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getApiVersion() {
    return this.apiVersion;
  }
  
  public A withApiVersion(String apiVersion) {
    this.apiVersion = apiVersion;
    return (A) this;
  }
  
  public boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  public String getContainer() {
    return this.container;
  }
  
  public A withContainer(String container) {
    this.container = container;
    return (A) this;
  }
  
  public boolean hasContainer() {
    return this.container != null;
  }
  
  public Boolean getFollow() {
    return this.follow;
  }
  
  public A withFollow(Boolean follow) {
    this.follow = follow;
    return (A) this;
  }
  
  public boolean hasFollow() {
    return this.follow != null;
  }
  
  public Boolean getInsecureSkipTLSVerifyBackend() {
    return this.insecureSkipTLSVerifyBackend;
  }
  
  public A withInsecureSkipTLSVerifyBackend(Boolean insecureSkipTLSVerifyBackend) {
    this.insecureSkipTLSVerifyBackend = insecureSkipTLSVerifyBackend;
    return (A) this;
  }
  
  public boolean hasInsecureSkipTLSVerifyBackend() {
    return this.insecureSkipTLSVerifyBackend != null;
  }
  
  public String getKind() {
    return this.kind;
  }
  
  public A withKind(String kind) {
    this.kind = kind;
    return (A) this;
  }
  
  public boolean hasKind() {
    return this.kind != null;
  }
  
  public Long getLimitBytes() {
    return this.limitBytes;
  }
  
  public A withLimitBytes(Long limitBytes) {
    this.limitBytes = limitBytes;
    return (A) this;
  }
  
  public boolean hasLimitBytes() {
    return this.limitBytes != null;
  }
  
  public Boolean getNowait() {
    return this.nowait;
  }
  
  public A withNowait(Boolean nowait) {
    this.nowait = nowait;
    return (A) this;
  }
  
  public boolean hasNowait() {
    return this.nowait != null;
  }
  
  public Boolean getPrevious() {
    return this.previous;
  }
  
  public A withPrevious(Boolean previous) {
    this.previous = previous;
    return (A) this;
  }
  
  public boolean hasPrevious() {
    return this.previous != null;
  }
  
  public Long getSinceSeconds() {
    return this.sinceSeconds;
  }
  
  public A withSinceSeconds(Long sinceSeconds) {
    this.sinceSeconds = sinceSeconds;
    return (A) this;
  }
  
  public boolean hasSinceSeconds() {
    return this.sinceSeconds != null;
  }
  
  public String getSinceTime() {
    return this.sinceTime;
  }
  
  public A withSinceTime(String sinceTime) {
    this.sinceTime = sinceTime;
    return (A) this;
  }
  
  public boolean hasSinceTime() {
    return this.sinceTime != null;
  }
  
  public Long getTailLines() {
    return this.tailLines;
  }
  
  public A withTailLines(Long tailLines) {
    this.tailLines = tailLines;
    return (A) this;
  }
  
  public boolean hasTailLines() {
    return this.tailLines != null;
  }
  
  public Boolean getTimestamps() {
    return this.timestamps;
  }
  
  public A withTimestamps(Boolean timestamps) {
    this.timestamps = timestamps;
    return (A) this;
  }
  
  public boolean hasTimestamps() {
    return this.timestamps != null;
  }
  
  public Long getVersion() {
    return this.version;
  }
  
  public A withVersion(Long version) {
    this.version = version;
    return (A) this;
  }
  
  public boolean hasVersion() {
    return this.version != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    BuildLogOptionsFluent that = (BuildLogOptionsFluent) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;
    if (!java.util.Objects.equals(container, that.container)) return false;
    if (!java.util.Objects.equals(follow, that.follow)) return false;
    if (!java.util.Objects.equals(insecureSkipTLSVerifyBackend, that.insecureSkipTLSVerifyBackend)) return false;
    if (!java.util.Objects.equals(kind, that.kind)) return false;
    if (!java.util.Objects.equals(limitBytes, that.limitBytes)) return false;
    if (!java.util.Objects.equals(nowait, that.nowait)) return false;
    if (!java.util.Objects.equals(previous, that.previous)) return false;
    if (!java.util.Objects.equals(sinceSeconds, that.sinceSeconds)) return false;
    if (!java.util.Objects.equals(sinceTime, that.sinceTime)) return false;
    if (!java.util.Objects.equals(tailLines, that.tailLines)) return false;
    if (!java.util.Objects.equals(timestamps, that.timestamps)) return false;
    if (!java.util.Objects.equals(version, that.version)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  container,  follow,  insecureSkipTLSVerifyBackend,  kind,  limitBytes,  nowait,  previous,  sinceSeconds,  sinceTime,  tailLines,  timestamps,  version,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (container != null) { sb.append("container:"); sb.append(container + ","); }
    if (follow != null) { sb.append("follow:"); sb.append(follow + ","); }
    if (insecureSkipTLSVerifyBackend != null) { sb.append("insecureSkipTLSVerifyBackend:"); sb.append(insecureSkipTLSVerifyBackend + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (limitBytes != null) { sb.append("limitBytes:"); sb.append(limitBytes + ","); }
    if (nowait != null) { sb.append("nowait:"); sb.append(nowait + ","); }
    if (previous != null) { sb.append("previous:"); sb.append(previous + ","); }
    if (sinceSeconds != null) { sb.append("sinceSeconds:"); sb.append(sinceSeconds + ","); }
    if (sinceTime != null) { sb.append("sinceTime:"); sb.append(sinceTime + ","); }
    if (tailLines != null) { sb.append("tailLines:"); sb.append(tailLines + ","); }
    if (timestamps != null) { sb.append("timestamps:"); sb.append(timestamps + ","); }
    if (version != null) { sb.append("version:"); sb.append(version + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withFollow() {
    return withFollow(true);
  }
  
  public A withInsecureSkipTLSVerifyBackend() {
    return withInsecureSkipTLSVerifyBackend(true);
  }
  
  public A withNowait() {
    return withNowait(true);
  }
  
  public A withPrevious() {
    return withPrevious(true);
  }
  
  public A withTimestamps() {
    return withTimestamps(true);
  }
  

}